/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import org.apache.bookkeeper.shaded.com.google.common.annotations.VisibleForTesting;

public class ByteBufList
extends AbstractReferenceCounted {
    private final ArrayList<ByteBuf> buffers;
    private final Recycler.Handle<ByteBufList> recyclerHandle;
    private static final int INITIAL_LIST_SIZE = 4;
    private static final Recycler<ByteBufList> RECYCLER = new Recycler<ByteBufList>(){

        protected ByteBufList newObject(Recycler.Handle<ByteBufList> handle) {
            return new ByteBufList(handle);
        }
    };
    public static final Encoder ENCODER = new Encoder();

    private ByteBufList(Recycler.Handle<ByteBufList> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
        this.buffers = new ArrayList(4);
    }

    public static ByteBufList get(ByteBuf b1, ByteBuf b2) {
        ByteBufList buf = ByteBufList.get();
        buf.add(b1);
        buf.add(b2);
        return buf;
    }

    public static ByteBufList get(ByteBuf b1) {
        ByteBufList buf = ByteBufList.get();
        buf.add(b1);
        return buf;
    }

    public static ByteBufList clone(ByteBufList other) {
        ByteBufList buf = ByteBufList.get();
        for (int i = 0; i < other.buffers.size(); ++i) {
            buf.add(other.buffers.get(i).retainedDuplicate());
        }
        return buf;
    }

    private static ByteBufList get() {
        ByteBufList buf = (ByteBufList)((Object)RECYCLER.get());
        buf.setRefCnt(1);
        return buf;
    }

    public void add(ByteBuf buf) {
        this.buffers.add(buf);
    }

    public void prepend(ByteBuf buf) {
        this.buffers.add(0, buf);
    }

    public int readableBytes() {
        int readableBytes = 0;
        for (int i = 0; i < this.buffers.size(); ++i) {
            readableBytes += this.buffers.get(i).readableBytes();
        }
        return readableBytes;
    }

    public ByteBuf getBuffer(int index) {
        return this.buffers.get(index);
    }

    public int size() {
        return this.buffers.size();
    }

    public int getBytes(byte[] dst) {
        int len;
        int copied = 0;
        for (int idx = 0; idx < this.buffers.size() && copied < dst.length; copied += len, ++idx) {
            ByteBuf b = this.buffers.get(idx);
            len = Math.min(b.readableBytes(), dst.length - copied);
            b.getBytes(b.readerIndex(), dst, copied, len);
        }
        return copied;
    }

    public byte[] toArray() {
        byte[] a = new byte[this.readableBytes()];
        this.getBytes(a);
        return a;
    }

    public boolean hasArray() {
        return this.buffers.size() == 1 && this.buffers.get(0).hasArray();
    }

    public byte[] array() {
        return this.buffers.get(0).array();
    }

    public int arrayOffset() {
        return this.buffers.get(0).arrayOffset();
    }

    @VisibleForTesting
    public static ByteBuf coalesce(ByteBufList list) {
        ByteBuf res = Unpooled.buffer((int)list.readableBytes());
        for (int i = 0; i < list.buffers.size(); ++i) {
            ByteBuf b = list.buffers.get(i);
            res.writeBytes(b, b.readerIndex(), b.readableBytes());
        }
        return res;
    }

    public ByteBufList retain() {
        super.retain();
        return this;
    }

    protected void deallocate() {
        for (int i = 0; i < this.buffers.size(); ++i) {
            this.buffers.get(i).release();
        }
        this.buffers.clear();
        this.recyclerHandle.recycle((Object)this);
    }

    public ReferenceCounted touch(Object hint) {
        for (int i = 0; i < this.buffers.size(); ++i) {
            this.buffers.get(i).touch(hint);
        }
        return this;
    }

    @ChannelHandler.Sharable
    public static class Encoder
    extends ChannelOutboundHandlerAdapter {
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof ByteBufList) {
                ByteBufList b = (ByteBufList)((Object)msg);
                ChannelPromise compositePromise = ctx.newPromise();
                compositePromise.addListener(future -> {
                    ReferenceCountUtil.safeRelease((Object)((Object)b));
                    if (promise != null && !promise.isVoid()) {
                        if (future.isSuccess()) {
                            promise.setSuccess();
                        } else {
                            promise.setFailure(future.cause());
                        }
                    }
                });
                int buffersCount = b.buffers.size();
                for (int i = 0; i < buffersCount; ++i) {
                    ByteBuf bx = (ByteBuf)b.buffers.get(i);
                    ctx.write((Object)bx.retainedDuplicate(), i == buffersCount - 1 ? compositePromise : ctx.voidPromise());
                }
            } else {
                ctx.write(msg, promise);
            }
        }
    }
}

