/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.shaded.com.google.common.base.Preconditions;
import org.apache.bookkeeper.tools.cli.commands.bookie.SanityTestCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieSanityService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(BookieSanityService.class);
    private final ServerConfiguration config;
    private Semaphore lock = new Semaphore(1);
    private static final int TIMEOUT_MS = 5000;
    private static final int MAX_CONCURRENT_REQUESTS = 1;

    public BookieSanityService(ServerConfiguration config) {
        this.config = Preconditions.checkNotNull(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET != request.getMethod()) {
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("Only support GET method to retrieve bookie sanity state.");
            return response;
        }
        BookieSanity bs = new BookieSanity();
        if (this.config.isForceReadOnlyBookie()) {
            bs.readOnly = true;
        } else {
            try {
                try {
                    this.lock.tryAcquire(1, 5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    LOG.error("Timing out due to max {} of sanity request are running concurrently", (Object)1);
                    response.setCode(HttpServer.StatusCode.INTERNAL_ERROR);
                    response.setBody("Timing out due to max number of sanity request are running concurrently");
                    HttpServiceResponse httpServiceResponse = response;
                    this.lock.release();
                    return httpServiceResponse;
                }
                SanityTestCommand sanity = new SanityTestCommand();
                bs.passed = sanity.apply(this.config, new SanityTestCommand.SanityFlags());
            }
            finally {
                this.lock.release();
            }
        }
        String jsonResponse = JsonUtil.toJson(bs);
        response.setBody(jsonResponse);
        response.setCode(HttpServer.StatusCode.OK);
        return response;
    }

    public static class BookieSanity {
        private boolean passed;
        private boolean readOnly;

        public boolean isPassed() {
            return this.passed;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setPassed(boolean passed) {
            this.passed = passed;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BookieSanity)) {
                return false;
            }
            BookieSanity other = (BookieSanity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPassed() != other.isPassed()) {
                return false;
            }
            return this.isReadOnly() == other.isReadOnly();
        }

        protected boolean canEqual(Object other) {
            return other instanceof BookieSanity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPassed() ? 79 : 97);
            result = result * 59 + (this.isReadOnly() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "BookieSanityService.BookieSanity(passed=" + this.isPassed() + ", readOnly=" + this.isReadOnly() + ")";
        }
    }
}

