/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerAuditorManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StatsDoc(name="auditor", help="Auditor related stats")
public class AuditorElector {
    private static final Logger LOG = LoggerFactory.getLogger(AuditorElector.class);
    private final String bookieId;
    private final ServerConfiguration conf;
    private final BookKeeper bkc;
    private final boolean ownBkc;
    private final ExecutorService executor;
    private final LedgerAuditorManager ledgerAuditorManager;
    Auditor auditor;
    private AtomicBoolean running = new AtomicBoolean(false);
    private final StatsLogger statsLogger;
    Runnable shutdownTask = new Runnable(){

        @Override
        public void run() {
            if (!AuditorElector.this.running.compareAndSet(true, false)) {
                return;
            }
            try {
                AuditorElector.this.ledgerAuditorManager.close();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOG.warn("InterruptedException while closing ledger auditor manager", (Throwable)ie);
            }
            catch (Exception ke) {
                LOG.error("Exception while closing ledger auditor manager", (Throwable)ke);
            }
        }
    };

    @VisibleForTesting
    public AuditorElector(String bookieId, ServerConfiguration conf) throws ReplicationException.UnavailableException {
        this(bookieId, conf, Auditor.createBookKeeperClientThrowUnavailableException(conf), true);
    }

    public AuditorElector(String bookieId, ServerConfiguration conf, BookKeeper bkc, boolean ownBkc) throws ReplicationException.UnavailableException {
        this(bookieId, conf, bkc, NullStatsLogger.INSTANCE, ownBkc);
    }

    public AuditorElector(final String bookieId, ServerConfiguration conf, BookKeeper bkc, StatsLogger statsLogger, boolean ownBkc) throws ReplicationException.UnavailableException {
        this.bookieId = bookieId;
        this.conf = conf;
        this.bkc = bkc;
        this.ownBkc = ownBkc;
        this.statsLogger = statsLogger;
        try {
            this.ledgerAuditorManager = bkc.getLedgerManagerFactory().newLedgerAuditorManager();
        }
        catch (Exception e) {
            throw new ReplicationException.UnavailableException("Failed to instantiate the ledger auditor manager", e);
        }
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "AuditorElector-" + bookieId);
            }
        });
    }

    public Future<?> start() {
        this.running.set(true);
        return this.submitElectionTask();
    }

    private Future<?> submitShutdownTask() {
        return this.executor.submit(this.shutdownTask);
    }

    @VisibleForTesting
    Future<?> submitElectionTask() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (!AuditorElector.this.running.get()) {
                    return;
                }
                try {
                    AuditorElector.this.ledgerAuditorManager.tryToBecomeAuditor(AuditorElector.this.bookieId, e -> AuditorElector.this.handleAuditorEvent(e));
                    AuditorElector.this.auditor = new Auditor(AuditorElector.this.bookieId, AuditorElector.this.conf, AuditorElector.this.bkc, false, AuditorElector.this.statsLogger);
                    AuditorElector.this.auditor.start();
                }
                catch (InterruptedException e2) {
                    LOG.error("Interrupted while performing auditor election", (Throwable)e2);
                    Thread.currentThread().interrupt();
                    AuditorElector.this.submitShutdownTask();
                }
                catch (Exception e3) {
                    LOG.error("Exception while performing auditor election", (Throwable)e3);
                    AuditorElector.this.submitShutdownTask();
                }
            }
        };
        try {
            return this.executor.submit(r);
        }
        catch (RejectedExecutionException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executor was already closed");
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    private void handleAuditorEvent(LedgerAuditorManager.AuditorEvent e) {
        switch (e) {
            case SessionLost: {
                LOG.error("Lost ZK connection, shutting down");
                this.submitShutdownTask();
                break;
            }
            case VoteWasDeleted: {
                this.submitElectionTask();
            }
        }
    }

    @VisibleForTesting
    Auditor getAuditor() {
        return this.auditor;
    }

    public BookieId getCurrentAuditor() throws IOException, InterruptedException {
        return this.ledgerAuditorManager.getCurrentAuditor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException {
        AuditorElector auditorElector = this;
        synchronized (auditorElector) {
            if (this.executor.isShutdown()) {
                return;
            }
            try {
                this.submitShutdownTask().get(10L, TimeUnit.SECONDS);
                this.executor.shutdown();
            }
            catch (ExecutionException e) {
                LOG.warn("Failed to close auditor manager", (Throwable)e);
                this.executor.shutdownNow();
                this.shutdownTask.run();
            }
            catch (TimeoutException e) {
                LOG.warn("Failed to close auditor manager in 10 seconds", (Throwable)e);
                this.executor.shutdownNow();
                this.shutdownTask.run();
            }
        }
        if (this.auditor != null) {
            this.auditor.shutdown();
            this.auditor = null;
        }
        if (this.ownBkc) {
            try {
                this.bkc.close();
            }
            catch (BKException e) {
                LOG.warn("Failed to close bookkeeper client", (Throwable)e);
            }
        }
    }

    public boolean isRunning() {
        if (this.auditor != null) {
            return this.auditor.isRunning();
        }
        return this.running.get();
    }

    public String toString() {
        return "AuditorElector for " + this.bookieId;
    }
}

