/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.SpeculativeRequestExecutionPolicy;
import org.apache.bookkeeper.client.SpeculativeRequestExecutor;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.Futures;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSpeculativeRequestExecutionPolicy
implements SpeculativeRequestExecutionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSpeculativeRequestExecutionPolicy.class);
    final int firstSpeculativeRequestTimeout;
    final int maxSpeculativeRequestTimeout;
    final float backoffMultiplier;

    public DefaultSpeculativeRequestExecutionPolicy(int firstSpeculativeRequestTimeout, int maxSpeculativeRequestTimeout, float backoffMultiplier) {
        this.firstSpeculativeRequestTimeout = firstSpeculativeRequestTimeout;
        this.maxSpeculativeRequestTimeout = maxSpeculativeRequestTimeout;
        this.backoffMultiplier = backoffMultiplier;
        if (backoffMultiplier <= 0.0f) {
            throw new IllegalArgumentException("Invalid value provided for backoffMultiplier");
        }
        if (Math.round((double)maxSpeculativeRequestTimeout * (double)backoffMultiplier) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid values for maxSpeculativeRequestTimeout and backoffMultiplier");
        }
    }

    @Override
    public ScheduledFuture<?> initiateSpeculativeRequest(ScheduledExecutorService scheduler, SpeculativeRequestExecutor requestExecutor) {
        return this.scheduleSpeculativeRead(scheduler, requestExecutor, this.firstSpeculativeRequestTimeout);
    }

    private ScheduledFuture<?> scheduleSpeculativeRead(final ScheduledExecutorService scheduler, final SpeculativeRequestExecutor requestExecutor, final int speculativeRequestTimeout) {
        try {
            return scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    ListenableFuture<Boolean> issueNextRequest = requestExecutor.issueSpeculativeRequest();
                    Futures.addCallback(issueNextRequest, new FutureCallback<Boolean>(){

                        @Override
                        public void onSuccess(Boolean issueNextRequest) {
                            if (issueNextRequest.booleanValue()) {
                                DefaultSpeculativeRequestExecutionPolicy.this.scheduleSpeculativeRead(scheduler, requestExecutor, Math.min(DefaultSpeculativeRequestExecutionPolicy.this.maxSpeculativeRequestTimeout, Math.round((float)speculativeRequestTimeout * DefaultSpeculativeRequestExecutionPolicy.this.backoffMultiplier)));
                            } else if (LOG.isTraceEnabled()) {
                                LOG.trace("Stopped issuing speculative requests for {}, speculativeReadTimeout = {}", (Object)requestExecutor, (Object)speculativeRequestTimeout);
                            }
                        }

                        @Override
                        public void onFailure(Throwable thrown) {
                            LOG.warn("Failed to issue speculative request for {}, speculativeReadTimeout = {} : ", new Object[]{requestExecutor, speculativeRequestTimeout, thrown});
                        }
                    }, MoreExecutors.directExecutor());
                }
            }, (long)speculativeRequestTimeout, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException re) {
            if (!scheduler.isShutdown()) {
                LOG.warn("Failed to schedule speculative request for {}, speculativeReadTimeout = {} : ", new Object[]{requestExecutor, speculativeRequestTimeout, re});
            }
            return null;
        }
    }
}

