/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PrimitiveIterator;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.GarbageCollectionStatus;
import org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.RateLimiter;
import org.apache.bookkeeper.stats.StatsLogger;

public interface LedgerStorage {
    public void initialize(ServerConfiguration var1, LedgerManager var2, LedgerDirsManager var3, LedgerDirsManager var4, StatsLogger var5, ByteBufAllocator var6) throws IOException;

    public void setStateManager(StateManager var1);

    public void setCheckpointSource(CheckpointSource var1);

    public void setCheckpointer(Checkpointer var1);

    public void start();

    public void shutdown() throws InterruptedException;

    public boolean ledgerExists(long var1) throws IOException;

    public boolean entryExists(long var1, long var3) throws IOException, BookieException;

    public boolean setFenced(long var1) throws IOException;

    public boolean isFenced(long var1) throws IOException, BookieException;

    public void setLimboState(long var1) throws IOException;

    public boolean hasLimboState(long var1) throws IOException;

    public void clearLimboState(long var1) throws IOException;

    public void setMasterKey(long var1, byte[] var3) throws IOException;

    public byte[] readMasterKey(long var1) throws IOException, BookieException;

    public long addEntry(ByteBuf var1) throws IOException, BookieException;

    public ByteBuf getEntry(long var1, long var3) throws IOException, BookieException;

    public long getLastAddConfirmed(long var1) throws IOException, BookieException;

    public boolean waitForLastAddConfirmedUpdate(long var1, long var3, Watcher<LastAddConfirmedUpdateNotification> var5) throws IOException;

    public void cancelWaitForLastAddConfirmedUpdate(long var1, Watcher<LastAddConfirmedUpdateNotification> var3) throws IOException;

    public void flush() throws IOException;

    public void checkpoint(CheckpointSource.Checkpoint var1) throws IOException;

    public void deleteLedger(long var1) throws IOException;

    public void registerLedgerDeletionListener(LedgerDeletionListener var1);

    public void setExplicitLac(long var1, ByteBuf var3) throws IOException;

    public ByteBuf getExplicitLac(long var1) throws IOException, BookieException;

    default public LedgerStorage getUnderlyingLedgerStorage() {
        return this;
    }

    default public void forceGC() {
    }

    default public void forceGC(boolean forceMajor, boolean forceMinor) {
    }

    default public void suspendMinorGC() {
    }

    default public void suspendMajorGC() {
    }

    default public void resumeMinorGC() {
    }

    default public void resumeMajorGC() {
    }

    default public boolean isMajorGcSuspended() {
        return false;
    }

    default public boolean isMinorGcSuspended() {
        return false;
    }

    default public void entryLocationCompact() {
    }

    default public void entryLocationCompact(List<String> locations) {
    }

    default public boolean isEntryLocationCompacting() {
        return false;
    }

    default public Map<String, Boolean> isEntryLocationCompacting(List<String> locations) {
        return Collections.emptyMap();
    }

    default public List<String> getEntryLocationDBPath() {
        return Collections.emptyList();
    }

    default public List<DetectedInconsistency> localConsistencyCheck(Optional<RateLimiter> rateLimiter) throws IOException {
        return new ArrayList<DetectedInconsistency>();
    }

    default public boolean isInForceGC() {
        return false;
    }

    default public List<GarbageCollectionStatus> getGarbageCollectionStatus() {
        return Collections.emptyList();
    }

    public PrimitiveIterator.OfLong getListOfEntriesOfLedger(long var1) throws IOException;

    public EnumSet<StorageState> getStorageStateFlags() throws IOException;

    public void setStorageStateFlag(StorageState var1) throws IOException;

    public void clearStorageStateFlag(StorageState var1) throws IOException;

    public static enum StorageState {
        NEEDS_INTEGRITY_CHECK;

    }

    public static class DetectedInconsistency {
        private long ledgerId;
        private long entryId;
        private Exception detail;

        DetectedInconsistency(long ledgerId, long entryId, Exception detail) {
            this.ledgerId = ledgerId;
            this.entryId = entryId;
            this.detail = detail;
        }

        public long getLedgerId() {
            return this.ledgerId;
        }

        public long getEntryId() {
            return this.entryId;
        }

        public Exception getException() {
            return this.detail;
        }
    }

    public static interface LedgerDeletionListener {
        public void ledgerDeleted(long var1);
    }
}

