/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.bookkeeper.bookie.DefaultEntryLogger;
import org.apache.bookkeeper.bookie.EntryLogManagerBase;
import org.apache.bookkeeper.bookie.EntryLoggerAllocator;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.bookkeeper.shaded.com.google.common.cache.CacheBuilder;
import org.apache.bookkeeper.shaded.com.google.common.cache.CacheLoader;
import org.apache.bookkeeper.shaded.com.google.common.cache.LoadingCache;
import org.apache.bookkeeper.shaded.com.google.common.cache.RemovalCause;
import org.apache.bookkeeper.shaded.com.google.common.cache.RemovalListener;
import org.apache.bookkeeper.shaded.com.google.common.cache.RemovalNotification;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.collections.ConcurrentLongHashMap;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntryLogManagerForEntryLogPerLedger
extends EntryLogManagerBase {
    private static final Logger log = LoggerFactory.getLogger(EntryLogManagerForEntryLogPerLedger.class);
    private final AtomicReferenceArray<Lock> lockArrayPool;
    private final LoadingCache<Long, EntryLogAndLockTuple> ledgerIdEntryLogMap;
    private final ConcurrentLongHashMap<BufferedLogChannelWithDirInfo> replicaOfCurrentLogChannels;
    private final CacheLoader<Long, EntryLogAndLockTuple> entryLogAndLockTupleCacheLoader;
    private final DefaultEntryLogger.RecentEntryLogsStatus recentlyCreatedEntryLogsStatus;
    private final int entrylogMapAccessExpiryTimeInSeconds;
    private final int maximumNumberOfActiveEntryLogs;
    private final int entryLogPerLedgerCounterLimitsMultFactor;
    private final StatsLogger statsLogger;
    final EntryLogsPerLedgerCounter entryLogsPerLedgerCounter;

    EntryLogManagerForEntryLogPerLedger(ServerConfiguration conf, LedgerDirsManager ledgerDirsManager, EntryLoggerAllocator entryLoggerAllocator, List<DefaultEntryLogger.EntryLogListener> listeners, DefaultEntryLogger.RecentEntryLogsStatus recentlyCreatedEntryLogsStatus, StatsLogger statsLogger) throws IOException {
        super(conf, ledgerDirsManager, entryLoggerAllocator, listeners);
        this.recentlyCreatedEntryLogsStatus = recentlyCreatedEntryLogsStatus;
        this.rotatedLogChannels = new CopyOnWriteArrayList();
        this.replicaOfCurrentLogChannels = ConcurrentLongHashMap.newBuilder().build();
        this.entrylogMapAccessExpiryTimeInSeconds = conf.getEntrylogMapAccessExpiryTimeInSeconds();
        this.maximumNumberOfActiveEntryLogs = conf.getMaximumNumberOfActiveEntryLogs();
        this.entryLogPerLedgerCounterLimitsMultFactor = conf.getEntryLogPerLedgerCounterLimitsMultFactor();
        ledgerDirsManager.addLedgerDirsListener(this.getLedgerDirsListener());
        this.lockArrayPool = new AtomicReferenceArray(this.maximumNumberOfActiveEntryLogs * 2);
        this.entryLogAndLockTupleCacheLoader = new CacheLoader<Long, EntryLogAndLockTuple>(){

            @Override
            public EntryLogAndLockTuple load(Long key) throws Exception {
                return new EntryLogAndLockTuple(key);
            }
        };
        this.ledgerIdEntryLogMap = CacheBuilder.newBuilder().expireAfterAccess(this.entrylogMapAccessExpiryTimeInSeconds, TimeUnit.SECONDS).maximumSize(this.maximumNumberOfActiveEntryLogs).removalListener(new RemovalListener<Long, EntryLogAndLockTuple>(){

            @Override
            public void onRemoval(RemovalNotification<Long, EntryLogAndLockTuple> expiredLedgerEntryLogMapEntry) {
                EntryLogManagerForEntryLogPerLedger.this.onCacheEntryRemoval(expiredLedgerEntryLogMapEntry);
            }
        }).build(this.entryLogAndLockTupleCacheLoader);
        this.statsLogger = statsLogger;
        this.entryLogsPerLedgerCounter = new EntryLogsPerLedgerCounter(this.statsLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCacheEntryRemoval(RemovalNotification<Long, EntryLogAndLockTuple> removedLedgerEntryLogMapEntry) {
        EntryLogAndLockTuple entryLogAndLockTuple;
        Long ledgerId = (Long)removedLedgerEntryLogMapEntry.getKey();
        if (log.isDebugEnabled()) {
            log.debug("LedgerId {} is being evicted from the cache map because of {}", (Object)ledgerId, (Object)removedLedgerEntryLogMapEntry.getCause());
        }
        if ((entryLogAndLockTuple = (EntryLogAndLockTuple)removedLedgerEntryLogMapEntry.getValue()) == null) {
            log.error("entryLogAndLockTuple is not supposed to be null in entry removal listener for ledger : {}", (Object)ledgerId);
            return;
        }
        Lock lock = entryLogAndLockTuple.ledgerLock;
        BufferedLogChannelWithDirInfo logChannelWithDirInfo = entryLogAndLockTuple.getEntryLogWithDirInfo();
        if (logChannelWithDirInfo == null) {
            log.error("logChannel for ledger: {} is not supposed to be null in entry removal listener", (Object)ledgerId);
            return;
        }
        lock.lock();
        try {
            DefaultEntryLogger.BufferedLogChannel logChannel = logChannelWithDirInfo.getLogChannel();
            try {
                logChannel.appendLedgersMap();
            }
            catch (Exception e) {
                log.error("Got IOException while trying to appendLedgersMap in cacheEntryRemoval callback", (Throwable)e);
            }
            this.replicaOfCurrentLogChannels.remove(logChannel.getLogId());
            this.rotatedLogChannels.add(logChannel);
            this.entryLogsPerLedgerCounter.removedLedgerFromEntryLogMapCache(ledgerId, removedLedgerEntryLogMapEntry.getCause());
        }
        finally {
            lock.unlock();
        }
    }

    private LedgerDirsManager.LedgerDirsListener getLedgerDirsListener() {
        return new LedgerDirsManager.LedgerDirsListener(){

            @Override
            public void diskFull(File disk) {
                Set<BufferedLogChannelWithDirInfo> copyOfCurrentLogsWithDirInfo = EntryLogManagerForEntryLogPerLedger.this.getCopyOfCurrentLogs();
                for (BufferedLogChannelWithDirInfo currentLogWithDirInfo : copyOfCurrentLogsWithDirInfo) {
                    if (!disk.equals(currentLogWithDirInfo.getLogChannel().getLogFile().getParentFile())) continue;
                    currentLogWithDirInfo.setLedgerDirFull(true);
                }
            }

            @Override
            public void diskWritable(File disk) {
                Set<BufferedLogChannelWithDirInfo> copyOfCurrentLogsWithDirInfo = EntryLogManagerForEntryLogPerLedger.this.getCopyOfCurrentLogs();
                for (BufferedLogChannelWithDirInfo currentLogWithDirInfo : copyOfCurrentLogsWithDirInfo) {
                    if (!disk.equals(currentLogWithDirInfo.getLogChannel().getLogFile().getParentFile())) continue;
                    currentLogWithDirInfo.setLedgerDirFull(false);
                }
            }
        };
    }

    Lock getLock(long ledgerId) throws IOException {
        try {
            return this.ledgerIdEntryLogMap.get(ledgerId).getLedgerLock();
        }
        catch (Exception e) {
            log.error("Received unexpected exception while fetching lock to acquire for ledger: " + ledgerId, (Throwable)e);
            throw new IOException("Received unexpected exception while fetching lock to acquire", e);
        }
    }

    @Override
    public void setCurrentLogForLedgerAndAddToRotate(long ledgerId, DefaultEntryLogger.BufferedLogChannel logChannel) throws IOException {
        Lock lock = this.getLock(ledgerId);
        lock.lock();
        try {
            DefaultEntryLogger.BufferedLogChannel hasToRotateLogChannel = this.getCurrentLogForLedger(ledgerId);
            boolean newLedgerInEntryLogMapCache = hasToRotateLogChannel == null;
            logChannel.setLedgerIdAssigned(ledgerId);
            BufferedLogChannelWithDirInfo logChannelWithDirInfo = new BufferedLogChannelWithDirInfo(logChannel);
            this.ledgerIdEntryLogMap.get(ledgerId).setEntryLogWithDirInfo(logChannelWithDirInfo);
            this.entryLogsPerLedgerCounter.openNewEntryLogForLedger(ledgerId, newLedgerInEntryLogMapCache);
            this.replicaOfCurrentLogChannels.put(logChannel.getLogId(), logChannelWithDirInfo);
            if (hasToRotateLogChannel != null) {
                this.replicaOfCurrentLogChannels.remove(hasToRotateLogChannel.getLogId());
                this.rotatedLogChannels.add(hasToRotateLogChannel);
            }
        }
        catch (Exception e) {
            log.error("Received unexpected exception while fetching entry from map for ledger: " + ledgerId, (Throwable)e);
            throw new IOException("Received unexpected exception while fetching entry from map", e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public DefaultEntryLogger.BufferedLogChannel getCurrentLogForLedger(long ledgerId) throws IOException {
        BufferedLogChannelWithDirInfo bufferedLogChannelWithDirInfo = this.getCurrentLogWithDirInfoForLedger(ledgerId);
        DefaultEntryLogger.BufferedLogChannel bufferedLogChannel = null;
        if (bufferedLogChannelWithDirInfo != null) {
            bufferedLogChannel = bufferedLogChannelWithDirInfo.getLogChannel();
        }
        return bufferedLogChannel;
    }

    public BufferedLogChannelWithDirInfo getCurrentLogWithDirInfoForLedger(long ledgerId) throws IOException {
        Lock lock = this.getLock(ledgerId);
        lock.lock();
        try {
            EntryLogAndLockTuple entryLogAndLockTuple = this.ledgerIdEntryLogMap.get(ledgerId);
            BufferedLogChannelWithDirInfo bufferedLogChannelWithDirInfo = entryLogAndLockTuple.getEntryLogWithDirInfo();
            return bufferedLogChannelWithDirInfo;
        }
        catch (Exception e) {
            log.error("Received unexpected exception while fetching entry from map for ledger: " + ledgerId, (Throwable)e);
            throw new IOException("Received unexpected exception while fetching entry from map", e);
        }
        finally {
            lock.unlock();
        }
    }

    public Set<BufferedLogChannelWithDirInfo> getCopyOfCurrentLogs() {
        return new HashSet<BufferedLogChannelWithDirInfo>(this.replicaOfCurrentLogChannels.values());
    }

    @Override
    public DefaultEntryLogger.BufferedLogChannel getCurrentLogIfPresent(long entryLogId) {
        BufferedLogChannelWithDirInfo bufferedLogChannelWithDirInfo = this.replicaOfCurrentLogChannels.get(entryLogId);
        DefaultEntryLogger.BufferedLogChannel logChannel = null;
        if (bufferedLogChannelWithDirInfo != null) {
            logChannel = bufferedLogChannelWithDirInfo.getLogChannel();
        }
        return logChannel;
    }

    @Override
    public void checkpoint() throws IOException {
        super.flush();
    }

    @Override
    public void prepareSortedLedgerStorageCheckpoint(long numBytesFlushed) throws IOException {
    }

    @Override
    public void prepareEntryMemTableFlush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitEntryMemTableFlush() throws IOException {
        Set<BufferedLogChannelWithDirInfo> copyOfCurrentLogsWithDirInfo = this.getCopyOfCurrentLogs();
        for (BufferedLogChannelWithDirInfo currentLogWithDirInfo : copyOfCurrentLogsWithDirInfo) {
            DefaultEntryLogger.BufferedLogChannel currentLog = currentLogWithDirInfo.getLogChannel();
            if (!this.reachEntryLogLimit(currentLog, 0L)) continue;
            Long ledgerId = currentLog.getLedgerIdAssigned();
            Lock lock = this.getLock(ledgerId);
            lock.lock();
            try {
                if (!this.reachEntryLogLimit(currentLog, 0L)) continue;
                log.info("Rolling entry logger since it reached size limitation for ledger: {}", (Object)ledgerId);
                this.createNewLog(ledgerId, "after entry log file is rotated");
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    @VisibleForTesting
    void doEntryLogMapCleanup() {
        this.ledgerIdEntryLogMap.cleanUp();
    }

    @VisibleForTesting
    ConcurrentMap<Long, EntryLogAndLockTuple> getCacheAsMap() {
        return this.ledgerIdEntryLogMap.asMap();
    }

    @Override
    public File getDirForNextEntryLog(List<File> writableLedgerDirs) {
        HashMap writableLedgerDirFrequency = new HashMap();
        writableLedgerDirs.stream().forEach(ledgerDir -> writableLedgerDirFrequency.put(ledgerDir, new MutableInt()));
        for (BufferedLogChannelWithDirInfo logChannelWithDirInfo : this.replicaOfCurrentLogChannels.values()) {
            File parentDirOfCurrentLogChannel = logChannelWithDirInfo.getLogChannel().getLogFile().getParentFile();
            if (!writableLedgerDirFrequency.containsKey(parentDirOfCurrentLogChannel)) continue;
            ((MutableInt)writableLedgerDirFrequency.get(parentDirOfCurrentLogChannel)).increment();
        }
        Optional ledgerDirWithLeastNumofCurrentLogs = writableLedgerDirFrequency.entrySet().stream().min(Map.Entry.comparingByValue());
        return (File)ledgerDirWithLeastNumofCurrentLogs.get().getKey();
    }

    @Override
    public void close() throws IOException {
        Set<BufferedLogChannelWithDirInfo> copyOfCurrentLogsWithDirInfo = this.getCopyOfCurrentLogs();
        for (BufferedLogChannelWithDirInfo currentLogWithDirInfo : copyOfCurrentLogsWithDirInfo) {
            if (currentLogWithDirInfo.getLogChannel() == null) continue;
            currentLogWithDirInfo.getLogChannel().close();
        }
    }

    @Override
    public void forceClose() {
        Set<BufferedLogChannelWithDirInfo> copyOfCurrentLogsWithDirInfo = this.getCopyOfCurrentLogs();
        for (BufferedLogChannelWithDirInfo currentLogWithDirInfo : copyOfCurrentLogsWithDirInfo) {
            IOUtils.close(log, (Closeable)currentLogWithDirInfo.getLogChannel());
        }
    }

    @Override
    void flushCurrentLogs() throws IOException {
        Set<BufferedLogChannelWithDirInfo> copyOfCurrentLogsWithDirInfo = this.getCopyOfCurrentLogs();
        for (BufferedLogChannelWithDirInfo logChannelWithDirInfo : copyOfCurrentLogsWithDirInfo) {
            this.flushLogChannel(logChannelWithDirInfo.getLogChannel(), true);
        }
    }

    @Override
    public DefaultEntryLogger.BufferedLogChannel createNewLogForCompaction() throws IOException {
        throw new UnsupportedOperationException("When entryLogPerLedger is enabled, transactional compaction should have been disabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addEntry(long ledger, ByteBuf entry, boolean rollLog) throws IOException {
        Lock lock = this.getLock(ledger);
        lock.lock();
        try {
            long l = super.addEntry(ledger, entry, rollLog);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void createNewLog(long ledgerId) throws IOException {
        Lock lock = this.getLock(ledgerId);
        lock.lock();
        try {
            super.createNewLog(ledgerId);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    DefaultEntryLogger.BufferedLogChannel getCurrentLogForLedgerForAddEntry(long ledgerId, int entrySize, boolean rollLog) throws IOException {
        Lock lock = this.getLock(ledgerId);
        lock.lock();
        try {
            boolean allDisksFull;
            BufferedLogChannelWithDirInfo logChannelWithDirInfo = this.getCurrentLogWithDirInfoForLedger(ledgerId);
            DefaultEntryLogger.BufferedLogChannel logChannel = null;
            if (logChannelWithDirInfo != null) {
                logChannel = logChannelWithDirInfo.getLogChannel();
            }
            boolean reachEntryLogLimit = rollLog ? this.reachEntryLogLimit(logChannel, entrySize) : this.readEntryLogHardLimit(logChannel, entrySize);
            boolean diskFull = logChannel == null ? false : logChannelWithDirInfo.isLedgerDirFull();
            boolean bl = allDisksFull = !this.ledgerDirsManager.hasWritableLedgerDirs();
            if (diskFull && !allDisksFull || reachEntryLogLimit || logChannel == null) {
                if (logChannel != null) {
                    logChannel.flushAndForceWriteIfRegularFlush(false);
                }
                this.createNewLog(ledgerId, ": diskFull = " + diskFull + ", allDisksFull = " + allDisksFull + ", reachEntryLogLimit = " + reachEntryLogLimit + ", logChannel = " + logChannel);
            }
            DefaultEntryLogger.BufferedLogChannel bufferedLogChannel = this.getCurrentLogForLedger(ledgerId);
            return bufferedLogChannel;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void flushRotatedLogs() throws IOException {
        for (DefaultEntryLogger.BufferedLogChannel channel : this.rotatedLogChannels) {
            channel.flushAndForceWrite(true);
            channel.close();
            this.recentlyCreatedEntryLogsStatus.flushRotatedEntryLog(channel.getLogId());
            this.rotatedLogChannels.remove(channel);
            log.info("Synced entry logger {} to disk.", (Object)channel.getLogId());
        }
    }

    @StatsDoc(name="entrylogger", category="server", help="EntryLogger related stats")
    class EntryLogsPerLedgerCounter {
        @StatsDoc(name="NUM_OF_WRITE_ACTIVE_LEDGERS", help="Number of write active ledgers")
        private final Counter numOfWriteActiveLedgers;
        @StatsDoc(name="NUM_OF_WRITE_LEDGERS_REMOVED_CACHE_EXPIRY", help="Number of write ledgers removed after cache expiry")
        private final Counter numOfWriteLedgersRemovedCacheExpiry;
        @StatsDoc(name="NUM_OF_WRITE_LEDGERS_REMOVED_CACHE_MAXSIZE", help="Number of write ledgers removed due to reach max cache size")
        private final Counter numOfWriteLedgersRemovedCacheMaxSize;
        @StatsDoc(name="NUM_LEDGERS_HAVING_MULTIPLE_ENTRYLOGS", help="Number of ledgers having multiple entry logs")
        private final Counter numLedgersHavingMultipleEntrylogs;
        @StatsDoc(name="ENTRYLOGS_PER_LEDGER", help="The distribution of number of entry logs per ledger")
        private final OpStatsLogger entryLogsPerLedger;
        private final LoadingCache<Long, MutableInt> ledgerIdEntryLogCounterCacheMap;

        EntryLogsPerLedgerCounter(StatsLogger statsLogger) {
            this.numOfWriteActiveLedgers = statsLogger.getCounter("NUM_OF_WRITE_ACTIVE_LEDGERS");
            this.numOfWriteLedgersRemovedCacheExpiry = statsLogger.getCounter("NUM_OF_WRITE_LEDGERS_REMOVED_CACHE_EXPIRY");
            this.numOfWriteLedgersRemovedCacheMaxSize = statsLogger.getCounter("NUM_OF_WRITE_LEDGERS_REMOVED_CACHE_MAXSIZE");
            this.numLedgersHavingMultipleEntrylogs = statsLogger.getCounter("NUM_LEDGERS_HAVING_MULTIPLE_ENTRYLOGS");
            this.entryLogsPerLedger = statsLogger.getOpStatsLogger("ENTRYLOGS_PER_LEDGER");
            this.ledgerIdEntryLogCounterCacheMap = CacheBuilder.newBuilder().expireAfterAccess(EntryLogManagerForEntryLogPerLedger.this.entrylogMapAccessExpiryTimeInSeconds * EntryLogManagerForEntryLogPerLedger.this.entryLogPerLedgerCounterLimitsMultFactor, TimeUnit.SECONDS).maximumSize(EntryLogManagerForEntryLogPerLedger.this.maximumNumberOfActiveEntryLogs * EntryLogManagerForEntryLogPerLedger.this.entryLogPerLedgerCounterLimitsMultFactor).removalListener(new RemovalListener<Long, MutableInt>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onRemoval(RemovalNotification<Long, MutableInt> removedEntryFromCounterMap) {
                    if (removedEntryFromCounterMap != null && removedEntryFromCounterMap.getValue() != null) {
                        EntryLogsPerLedgerCounter entryLogsPerLedgerCounter = EntryLogsPerLedgerCounter.this;
                        synchronized (entryLogsPerLedgerCounter) {
                            EntryLogsPerLedgerCounter.this.entryLogsPerLedger.registerSuccessfulValue(((MutableInt)removedEntryFromCounterMap.getValue()).intValue());
                        }
                    }
                }
            }).build(new CacheLoader<Long, MutableInt>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public MutableInt load(Long key) throws Exception {
                    EntryLogsPerLedgerCounter entryLogsPerLedgerCounter = EntryLogsPerLedgerCounter.this;
                    synchronized (entryLogsPerLedgerCounter) {
                        return new MutableInt();
                    }
                }
            });
        }

        private synchronized void openNewEntryLogForLedger(Long ledgerId, boolean newLedgerInEntryLogMapCache) {
            int numOfEntrylogsForThisLedger = this.ledgerIdEntryLogCounterCacheMap.getUnchecked(ledgerId).incrementAndGet();
            if (numOfEntrylogsForThisLedger == 2) {
                this.numLedgersHavingMultipleEntrylogs.inc();
            }
            if (newLedgerInEntryLogMapCache) {
                this.numOfWriteActiveLedgers.inc();
            }
        }

        private synchronized void removedLedgerFromEntryLogMapCache(Long ledgerId, RemovalCause cause) {
            this.numOfWriteActiveLedgers.dec();
            if (cause.equals((Object)RemovalCause.EXPIRED)) {
                this.numOfWriteLedgersRemovedCacheExpiry.inc();
            } else if (cause.equals((Object)RemovalCause.SIZE)) {
                this.numOfWriteLedgersRemovedCacheMaxSize.inc();
            }
        }

        @VisibleForTesting
        void doCounterMapCleanup() {
            this.ledgerIdEntryLogCounterCacheMap.cleanUp();
        }

        @VisibleForTesting
        ConcurrentMap<Long, MutableInt> getCounterMap() {
            return this.ledgerIdEntryLogCounterCacheMap.asMap();
        }
    }

    class EntryLogAndLockTuple {
        private final Lock ledgerLock;
        private BufferedLogChannelWithDirInfo entryLogWithDirInfo;

        private EntryLogAndLockTuple(long ledgerId) {
            int lockIndex = MathUtils.signSafeMod(Long.hashCode(ledgerId), EntryLogManagerForEntryLogPerLedger.this.lockArrayPool.length());
            if (EntryLogManagerForEntryLogPerLedger.this.lockArrayPool.get(lockIndex) == null) {
                EntryLogManagerForEntryLogPerLedger.this.lockArrayPool.compareAndSet(lockIndex, null, new ReentrantLock());
            }
            this.ledgerLock = (Lock)EntryLogManagerForEntryLogPerLedger.this.lockArrayPool.get(lockIndex);
        }

        private Lock getLedgerLock() {
            return this.ledgerLock;
        }

        BufferedLogChannelWithDirInfo getEntryLogWithDirInfo() {
            return this.entryLogWithDirInfo;
        }

        private void setEntryLogWithDirInfo(BufferedLogChannelWithDirInfo entryLogWithDirInfo) {
            this.entryLogWithDirInfo = entryLogWithDirInfo;
        }
    }

    static class BufferedLogChannelWithDirInfo {
        private final DefaultEntryLogger.BufferedLogChannel logChannel;
        volatile boolean ledgerDirFull = false;

        private BufferedLogChannelWithDirInfo(DefaultEntryLogger.BufferedLogChannel logChannel) {
            this.logChannel = logChannel;
        }

        private boolean isLedgerDirFull() {
            return this.ledgerDirFull;
        }

        private void setLedgerDirFull(boolean ledgerDirFull) {
            this.ledgerDirFull = ledgerDirFull;
        }

        DefaultEntryLogger.BufferedLogChannel getLogChannel() {
            return this.logChannel;
        }
    }
}

