/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.datainteg;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.datainteg.DataIntegrityCheck;
import org.apache.bookkeeper.bookie.datainteg.Events;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.bookkeeper.stats.StatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataIntegrityService
extends AbstractLifecycleComponent<BookieConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(DataIntegrityService.class);
    private final DataIntegrityCheck check;
    private final ScheduledExecutorService scheduler;
    private ScheduledFuture<?> scheduledFuture;

    public DataIntegrityService(BookieConfiguration conf, StatsLogger statsLogger, DataIntegrityCheck check) {
        super("data-integ", conf, statsLogger);
        this.check = check;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("bookie-data-integ-%d").setUncaughtExceptionHandler((t, ex) -> log.error("Event: {}, thread: {}", new Object[]{Events.DATA_INTEG_SERVICE_UNCAUGHT_ERROR, t, ex})).build());
        this.scheduledFuture = null;
    }

    protected int interval() {
        return 3;
    }

    protected TimeUnit intervalUnit() {
        return TimeUnit.SECONDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        log.info("Event: {}, interval: {}, intervalUnit: {}", new Object[]{Events.DATA_INTEG_SERVICE_START, this.interval(), this.intervalUnit()});
        DataIntegrityService dataIntegrityService = this;
        synchronized (dataIntegrityService) {
            this.scheduledFuture = this.scheduler.scheduleAtFixedRate(() -> {
                try {
                    if (this.check.needsFullCheck()) {
                        this.check.runFullCheck().get();
                    }
                }
                catch (InterruptedException ie) {
                    log.warn("Event: {}", (Object)Events.DATA_INTEG_SERVICE_INTERRUPTED, (Object)ie);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    log.error("Event: {}", (Object)Events.DATA_INTEG_SERVICE_ERROR, (Object)t);
                }
            }, 0L, this.interval(), this.intervalUnit());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        log.info("Event: {}", (Object)Events.DATA_INTEG_SERVICE_STOP);
        DataIntegrityService dataIntegrityService = this;
        synchronized (dataIntegrityService) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
                this.scheduledFuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws IOException {
        DataIntegrityService dataIntegrityService = this;
        synchronized (dataIntegrityService) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
                this.scheduledFuture = null;
            }
        }
        this.scheduler.shutdown();
    }
}

