/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.RateLimiter;

public abstract class AbstractLogCompactor {
    protected final ServerConfiguration conf;
    protected final Throttler throttler;
    protected final LogRemovalListener logRemovalListener;

    public AbstractLogCompactor(ServerConfiguration conf, LogRemovalListener logRemovalListener) {
        this.conf = conf;
        this.throttler = new Throttler(conf);
        this.logRemovalListener = logRemovalListener;
    }

    public abstract boolean compact(EntryLogMetadata var1);

    public void cleanUpAndRecover() {
    }

    public static class Throttler {
        private final RateLimiter rateLimiter;
        private final boolean isThrottleByBytes;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        Throttler(ServerConfiguration conf) {
            this.isThrottleByBytes = conf.getIsThrottleByBytes();
            this.rateLimiter = RateLimiter.create(this.isThrottleByBytes ? (double)conf.getCompactionRateByBytes() : (double)conf.getCompactionRateByEntries());
        }

        boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
            return this.rateLimiter.tryAcquire(this.isThrottleByBytes ? permits : 1, timeout, unit);
        }

        public void acquire(int permits) throws IOException {
            long timeout = 100L;
            long start = System.currentTimeMillis();
            while (!this.tryAcquire(permits, timeout, TimeUnit.MILLISECONDS)) {
                if (this.cancelled.get()) {
                    throw new IOException("Failed to get permits takes " + (System.currentTimeMillis() - start) + " ms may be compactor has been shutting down");
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void cancelledAcquire() {
            this.cancelled.set(true);
        }
    }

    public static interface LogRemovalListener {
        public void removeEntryLog(long var1);
    }
}

