/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.verifier;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.shaded.com.google.common.base.Preconditions;

public class BookkeeperVerifier {
    private final Queue<Exception> errors = new LinkedList<Exception>();
    private final BookkeeperDriver driver;
    private final int ensembleSize;
    private final int writeQuorum;
    private final int ackQuorum;
    private final int duration;
    private final int drainTimeout;
    private final int targetConcurrentLedgers;
    private final int targetConcurrentWrites;
    private final int targetWriteGroup;
    private final int targetReadGroup;
    private final int targetLedgers;
    private final int targetEntrySize;
    private final int targetConcurrentReads;
    private final double coldToHotRatio;
    private final long targetLedgerEntries;
    private int outstandingWriteCount = 0;
    private int outstandingReadCount = 0;
    private long nextLedger = 0L;
    private final Set<LedgerInfo> openingLedgers = new HashSet<LedgerInfo>();
    private final Set<LedgerInfo> openLedgers = new HashSet<LedgerInfo>();
    private final Set<LedgerInfo> liveLedgers = new HashSet<LedgerInfo>();
    private final Random opRand = new Random();

    private synchronized boolean checkReturn(long ledgerID, int rc) {
        if (0 != rc) {
            String error = String.format("Got error %d on ledger %d", rc, ledgerID);
            System.out.println(error);
            this.propagateExceptionToMain(BKException.create(rc));
            return true;
        }
        return false;
    }

    private synchronized void propagateExceptionToMain(Exception e) {
        this.errors.add(e);
        this.notifyAll();
    }

    private synchronized void printThrowExceptions() throws Exception {
        if (!this.errors.isEmpty()) {
            for (Exception e : this.errors) {
                System.out.format("Error found: %s%n", e.toString());
                e.printStackTrace();
            }
            throw this.errors.poll();
        }
    }

    BookkeeperVerifier(BookkeeperDriver driver, int ensembleSize, int writeQuorum, int ackQuorum, int duration, int drainTimeout, int targetConcurrentLedgers, int targetConcurrentWrites, int targetWriteGroup, int targetReadGroup, int targetLedgers, long targetLedgerSize, int targetEntrySize, int targetConcurrentReads, double coldToHotRatio) {
        this.driver = driver;
        this.ensembleSize = ensembleSize;
        this.writeQuorum = writeQuorum;
        this.ackQuorum = ackQuorum;
        this.duration = duration;
        this.drainTimeout = drainTimeout;
        this.targetConcurrentLedgers = targetConcurrentLedgers;
        this.targetConcurrentWrites = targetConcurrentWrites;
        this.targetWriteGroup = targetWriteGroup;
        this.targetReadGroup = targetReadGroup;
        this.targetLedgers = targetLedgers;
        this.targetEntrySize = targetEntrySize;
        this.targetConcurrentReads = targetConcurrentReads;
        this.coldToHotRatio = coldToHotRatio;
        this.targetLedgerEntries = targetLedgerSize / (long)targetEntrySize;
    }

    private long getNextLedgerID() {
        return this.nextLedger++;
    }

    private LedgerInfo getRandomLedger(Collection<LedgerInfo> ledgerCollection) {
        int elem = this.opRand.nextInt(ledgerCollection.size());
        Iterator<LedgerInfo> iter = ledgerCollection.iterator();
        for (int i = 0; i < elem; ++i) {
            iter.next();
        }
        return iter.next();
    }

    private synchronized boolean startRead() {
        LedgerInfo ledger;
        if (this.outstandingReadCount > this.targetConcurrentReads) {
            System.out.format("Not starting another read, enough in progress%n", new Object[0]);
            return false;
        }
        if (!this.openLedgers.isEmpty() && this.opRand.nextDouble() > this.coldToHotRatio) {
            ledger = this.getRandomLedger(this.openLedgers);
            System.out.format("Reading from open ledger %d%n", ledger.ledgerID);
        } else if (!this.liveLedgers.isEmpty()) {
            ledger = this.getRandomLedger(this.liveLedgers);
            System.out.format("Reading from cold ledger %d%n", ledger.ledgerID);
        } else {
            return false;
        }
        long lastEntryCompleted = ledger.getConfirmedLAC();
        if (lastEntryCompleted <= 0L) {
            System.out.format("No readable entries in ledger %d, let's wait%n", ledger.ledgerID);
            return false;
        }
        long start = Math.abs(this.opRand.nextLong() % lastEntryCompleted);
        long end = start + (long)this.targetReadGroup > lastEntryCompleted ? lastEntryCompleted : start + (long)this.targetReadGroup;
        System.out.format("Reading %d -> %d from ledger %d%n", start, end, ledger.ledgerID);
        LedgerInfo finalLedger = ledger;
        ledger.incReads();
        this.driver.readEntries(ledger.ledgerID, start, end, (rc, results) -> {
            BookkeeperVerifier bookkeeperVerifier = this;
            synchronized (bookkeeperVerifier) {
                if (this.checkReturn(ledger.ledgerID, (int)rc)) {
                    return;
                }
                System.out.format("Read %d -> %d from ledger %d complete%n", start, end, ledger.ledgerID);
                long current = start;
                LedgerInfo.EntryIterator iterator = finalLedger.getIterator();
                iterator.seek(current - 1L);
                for (byte[] result : results) {
                    byte[] check;
                    if (result.length != (check = iterator.next().getBuffer()).length) {
                        this.propagateExceptionToMain(new Exception(String.format("Mismatched entry length on entry %d for ledger %d, read returned %d, should be %d", current, ledger.ledgerID, result.length, check.length)));
                    }
                    if (!Arrays.equals(check, result)) {
                        int i;
                        for (i = 0; i < check.length && check[i] == result[i]; ++i) {
                        }
                        this.propagateExceptionToMain(new Exception(String.format("Mismatched entry contents on entry %d for ledger %d at offset %d, length %d", current, ledger.ledgerID, i, check.length)));
                    }
                    ++current;
                }
                finalLedger.decReads(rc2 -> {
                    BookkeeperVerifier bookkeeperVerifier = this;
                    synchronized (bookkeeperVerifier) {
                        this.checkReturn(ledger.ledgerID, (int)rc2);
                        System.out.format("Read %d -> %d from ledger %d releasing read%n", start, end, ledger.ledgerID);
                        --this.outstandingReadCount;
                        this.notifyAll();
                    }
                });
            }
        });
        ++this.outstandingReadCount;
        return true;
    }

    private synchronized boolean startWrite() {
        if (this.outstandingWriteCount > this.targetConcurrentWrites) {
            System.out.format("Write paused, too many outstanding writes%n", new Object[0]);
            return false;
        }
        if (this.openLedgers.size() + this.openingLedgers.size() < this.targetConcurrentLedgers) {
            long newID = this.getNextLedgerID();
            System.out.format("Creating new ledger %d%n", newID);
            LedgerInfo ledger = new LedgerInfo(newID, this.opRand.nextLong());
            this.openingLedgers.add(ledger);
            this.driver.createLedger(newID, this.ensembleSize, this.writeQuorum, this.ackQuorum, rc -> {
                BookkeeperVerifier bookkeeperVerifier = this;
                synchronized (bookkeeperVerifier) {
                    this.checkReturn(newID, (int)rc);
                    System.out.format("Created new ledger %d%n", newID);
                    this.openingLedgers.remove(ledger);
                    this.openLedgers.add(ledger);
                    --this.outstandingWriteCount;
                    this.notifyAll();
                }
            });
            ++this.outstandingWriteCount;
            return true;
        }
        if (this.openLedgers.isEmpty()) {
            System.out.format("Not starting a write, no open ledgers, already opening the limit%n", new Object[0]);
            return false;
        }
        LedgerInfo ledger = this.getRandomLedger(this.openLedgers);
        ArrayList<EntryInfo> toWrite = ledger.getNextEntries(this.targetWriteGroup);
        long lastEntry = toWrite.get(toWrite.size() - 1).getEntryID();
        System.out.format("Writing entries %d -> %d to ledger %d%n", toWrite.get(0).getEntryID(), lastEntry, ledger.ledgerID);
        ledger.openWrite(lastEntry);
        WriteCallback writeCB = new WriteCallback(ledger, lastEntry, ledger.getLastEntryIDCompleted(), toWrite.size());
        for (EntryInfo entry : toWrite) {
            this.driver.writeEntry(ledger.ledgerID, entry.getEntryID(), entry.getBuffer(), writeCB);
        }
        ++this.outstandingWriteCount;
        if (lastEntry >= this.targetLedgerEntries) {
            System.out.format("Marking ledger %d for close%n", ledger.ledgerID);
            this.openLedgers.remove(ledger);
            this.liveLedgers.add(ledger);
            ledger.onLastWriteComplete(rc -> this.checkReturn(ledger.ledgerID, (int)rc), cb -> {
                System.out.format("Closing ledger %d%n", ledger.ledgerID);
                this.driver.closeLedger(ledger.ledgerID, rc -> {
                    BookkeeperVerifier bookkeeperVerifier = this;
                    synchronized (bookkeeperVerifier) {
                        ledger.setClosed();
                        System.out.format("Closed ledger %d%n", ledger.ledgerID);
                        if (this.liveLedgers.size() >= this.targetLedgers) {
                            LedgerInfo toDelete = this.getRandomLedger(this.liveLedgers);
                            long ledgerID = toDelete.ledgerID;
                            System.out.format("Marking ledger %d for deletion%n", ledgerID);
                            this.liveLedgers.remove(toDelete);
                            toDelete.onLastOpComplete((Consumer<Integer>)cb, cb2 -> {
                                System.out.format("Deleting ledger %d%n", ledgerID);
                                this.driver.deleteLedger(ledgerID, rc2 -> {
                                    BookkeeperVerifier bookkeeperVerifier = this;
                                    synchronized (bookkeeperVerifier) {
                                        System.out.format("Deleted ledger %d%n", ledgerID);
                                        cb2.accept(rc2);
                                    }
                                });
                            });
                        } else {
                            cb.accept(rc);
                        }
                    }
                });
            });
        }
        Collections.shuffle(toWrite);
        return true;
    }

    public synchronized void run() throws Exception {
        long toWait;
        long start = System.currentTimeMillis();
        long testEnd = start + (long)(this.duration * 1000);
        long testDrainEnd = testEnd + (long)(this.drainTimeout * 1000);
        while (System.currentTimeMillis() < testEnd) {
            while (this.startRead() || this.startWrite()) {
            }
            toWait = testEnd - System.currentTimeMillis();
            this.wait(toWait < 0L ? 0L : toWait);
            this.printThrowExceptions();
        }
        while (System.currentTimeMillis() < testDrainEnd && (this.outstandingReadCount > 0 || this.outstandingWriteCount > 0)) {
            System.out.format("reads: %d, writes: %d%n", this.outstandingReadCount, this.outstandingWriteCount);
            System.out.format("openingLedgers:%n", new Object[0]);
            for (LedgerInfo li : this.openingLedgers) {
                System.out.format("Ledger %d has reads: %d, writes: %d%n", li.ledgerID, li.readsInProgress, li.writesInProgress.size());
            }
            System.out.format("openLedgers:%n", new Object[0]);
            for (LedgerInfo li : this.openLedgers) {
                System.out.format("Ledger %d has reads: %d, writes: %d%n", li.ledgerID, li.readsInProgress, li.writesInProgress.size());
            }
            System.out.format("liveLedgers:%n", new Object[0]);
            for (LedgerInfo li : this.liveLedgers) {
                System.out.format("Ledger %d has reads: %d, writes: %d%n", li.ledgerID, li.readsInProgress, li.writesInProgress.size());
            }
            toWait = testDrainEnd - System.currentTimeMillis();
            this.wait(toWait < 0L ? 0L : toWait);
            this.printThrowExceptions();
        }
        if (this.outstandingReadCount > 0 || this.outstandingWriteCount > 0) {
            throw new Exception("Failed to drain ops before timeout%n");
        }
    }

    class WriteCallback
    implements Consumer<Integer> {
        private int completed = 0;
        private final int toWaitFor;
        private final LedgerInfo ledger;
        private final long lastEntry;
        private final long pendingLAC;

        WriteCallback(LedgerInfo ledger, long lastEntry, long pendingLAC, int toWaitFor) {
            this.toWaitFor = toWaitFor;
            this.ledger = ledger;
            this.lastEntry = lastEntry;
            this.pendingLAC = pendingLAC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Integer rc) {
            BookkeeperVerifier bookkeeperVerifier = BookkeeperVerifier.this;
            synchronized (bookkeeperVerifier) {
                if (BookkeeperVerifier.this.checkReturn(this.ledger.ledgerID, rc)) {
                    return;
                }
                ++this.completed;
                if (this.toWaitFor == this.completed) {
                    System.out.format("Writes ending at %d complete on ledger %d%n", this.lastEntry, this.ledger.ledgerID);
                    this.ledger.closeWrite(this.lastEntry, rc2 -> {
                        BookkeeperVerifier bookkeeperVerifier = BookkeeperVerifier.this;
                        synchronized (bookkeeperVerifier) {
                            BookkeeperVerifier.this.checkReturn(this.ledger.ledgerID, rc2);
                            System.out.format("Writes ending at %d complete on ledger %d releasing write%n", this.lastEntry, this.ledger.ledgerID);
                            --BookkeeperVerifier.this.outstandingWriteCount;
                            BookkeeperVerifier.this.notifyAll();
                        }
                    });
                    this.ledger.updateLAC(this.pendingLAC);
                }
            }
        }
    }

    class LedgerInfo {
        private final long ledgerID;
        private final long seed;
        private long lastEntryIDCompleted = -1L;
        private long confirmedLAC = -1L;
        private boolean closed = false;
        final TreeSet<Long> writesInProgress = new TreeSet();
        final TreeSet<Long> writesCompleted = new TreeSet();
        int readsInProgress = 0;
        Consumer<Consumer<Integer>> onLastOp = null;
        Consumer<Consumer<Integer>> onLastWrite = null;
        EntryIterator iter;

        LedgerInfo(long ledgerID, long seed) {
            this.ledgerID = ledgerID;
            this.seed = seed;
            this.iter = new EntryIterator();
        }

        long getLastEntryIDCompleted() {
            return this.lastEntryIDCompleted;
        }

        long getConfirmedLAC() {
            return this.confirmedLAC;
        }

        ArrayList<EntryInfo> getNextEntries(int num) {
            ArrayList<EntryInfo> ret = new ArrayList<EntryInfo>();
            for (int i = 0; i < num && this.iter.hasNext(); ++i) {
                ret.add(this.iter.next());
            }
            return ret;
        }

        EntryIterator getIterator() {
            return new EntryIterator();
        }

        void openWrite(long entryID) {
            this.writesInProgress.add(entryID);
            System.out.format("Open writes, %s%n", this.writesInProgress);
        }

        void incReads() {
            ++this.readsInProgress;
            System.out.format("Inc reads to %d%n", this.readsInProgress);
        }

        void onLastOpComplete(Consumer<Integer> cb, Consumer<Consumer<Integer>> newOnLastOp) {
            Preconditions.checkState(this.onLastOp == null);
            this.onLastOp = newOnLastOp;
            this.checkOpComplete(cb);
        }

        void onLastWriteComplete(Consumer<Integer> cb, Consumer<Consumer<Integer>> newOnLastWrite) {
            assert (this.onLastWrite == null);
            this.onLastWrite = newOnLastWrite;
            this.checkWriteComplete(cb);
        }

        void closeWrite(long entryID, Consumer<Integer> cb) {
            long completedTo;
            this.writesInProgress.remove(entryID);
            this.writesCompleted.add(entryID);
            long l = completedTo = this.writesInProgress.isEmpty() ? Long.MAX_VALUE : this.writesInProgress.first();
            while (!this.writesCompleted.isEmpty() && this.writesCompleted.first() < completedTo) {
                this.lastEntryIDCompleted = this.writesCompleted.first();
                this.writesCompleted.remove(this.writesCompleted.first());
            }
            this.checkWriteComplete(rc -> {
                BookkeeperVerifier.this.checkReturn(this.ledgerID, rc);
                this.checkOpComplete(cb);
            });
        }

        void updateLAC(long lac) {
            if (lac > this.confirmedLAC) {
                this.confirmedLAC = lac;
            }
        }

        void decReads(Consumer<Integer> cb) {
            --this.readsInProgress;
            this.checkOpComplete(cb);
        }

        private void checkWriteComplete(Consumer<Integer> cb) {
            if (this.writesInProgress.isEmpty() && this.onLastWrite != null) {
                System.out.format("checkWriteComplete: done%n", new Object[0]);
                this.onLastWrite.accept(cb);
                this.onLastWrite = null;
            } else {
                System.out.format("checkWriteComplete: ledger %d, writesInProgress %s%n", this.ledgerID, this.writesInProgress);
                cb.accept(0);
            }
        }

        private void checkOpComplete(Consumer<Integer> cb) {
            if (this.readsInProgress == 0 && this.writesInProgress.isEmpty() && this.onLastOp != null) {
                System.out.format("checkOpComplete: done%n", new Object[0]);
                this.onLastOp.accept(cb);
                this.onLastOp = null;
            } else {
                System.out.format("checkOpComplete: ledger %d, writesInProgress %s, readsInProgress %d%n", this.ledgerID, this.writesInProgress, this.readsInProgress);
                cb.accept(0);
            }
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void setClosed() {
            this.closed = true;
            this.confirmedLAC = this.lastEntryIDCompleted;
        }

        class EntryIterator
        implements Iterator<EntryInfo> {
            Random rand;
            long currentID;
            long currentSeed;

            EntryIterator() {
                this.seek(-1L);
            }

            void seek(long entryID) {
                this.currentID = -1L;
                this.currentSeed = LedgerInfo.this.seed;
                this.rand = new Random(LedgerInfo.this.seed);
                while (this.currentID < entryID) {
                    this.advance();
                }
            }

            void advance() {
                this.currentSeed = this.rand.nextLong();
                ++this.currentID;
            }

            EntryInfo get() {
                return new EntryInfo(this.currentID, this.currentSeed);
            }

            @Override
            public boolean hasNext() {
                return this.currentID < BookkeeperVerifier.this.targetLedgerEntries;
            }

            @Override
            public EntryInfo next() {
                this.advance();
                return this.get();
            }
        }
    }

    @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
    class EntryInfo {
        private final long entryID;
        private final long seed;

        EntryInfo(long entryID, long seed) {
            this.entryID = entryID;
            this.seed = seed;
        }

        byte[] getBuffer() {
            Random rand = new Random(this.seed);
            byte[] ret = new byte[BookkeeperVerifier.this.targetEntrySize];
            rand.nextBytes(ret);
            return ret;
        }

        long getEntryID() {
            return this.entryID;
        }
    }

    public static interface BookkeeperDriver {
        public void createLedger(long var1, int var3, int var4, int var5, Consumer<Integer> var6);

        public void closeLedger(long var1, Consumer<Integer> var3);

        public void deleteLedger(long var1, Consumer<Integer> var3);

        public void writeEntry(long var1, long var3, byte[] var5, Consumer<Integer> var6);

        public void readEntries(long var1, long var3, long var5, BiConsumer<Integer, ArrayList<byte[]>> var7);

        public static interface ReadCallback {
            public void complete(long var1, ArrayList<byte[]> var3);
        }
    }
}

