/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import java.util.function.LongFunction;
import org.apache.bookkeeper.shaded.com.google.common.base.Preconditions;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;

public class ConcurrentLongHashMap<V> {
    private static final Object EmptyValue = null;
    private static final Object DeletedValue = new Object();
    private static final int DefaultExpectedItems = 256;
    private static final int DefaultConcurrencyLevel = 16;
    private static final float DefaultMapFillFactor = 0.66f;
    private static final float DefaultMapIdleFactor = 0.15f;
    private static final float DefaultExpandFactor = 2.0f;
    private static final float DefaultShrinkFactor = 2.0f;
    private static final boolean DefaultAutoShrink = false;
    private final Section<V>[] sections;
    private static final long HashMixer = -4132994306676758123L;
    private static final int R = 47;

    public static <V> Builder<V> newBuilder() {
        return new Builder();
    }

    @Deprecated
    public ConcurrentLongHashMap() {
        this(256);
    }

    @Deprecated
    public ConcurrentLongHashMap(int expectedItems) {
        this(expectedItems, 16);
    }

    @Deprecated
    public ConcurrentLongHashMap(int expectedItems, int concurrencyLevel) {
        this(expectedItems, concurrencyLevel, 0.66f, 0.15f, false, 2.0f, 2.0f);
    }

    public ConcurrentLongHashMap(int expectedItems, int concurrencyLevel, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
        Preconditions.checkArgument(expectedItems > 0);
        Preconditions.checkArgument(concurrencyLevel > 0);
        Preconditions.checkArgument(expectedItems >= concurrencyLevel);
        Preconditions.checkArgument(mapFillFactor > 0.0f && mapFillFactor < 1.0f);
        Preconditions.checkArgument(mapIdleFactor > 0.0f && mapIdleFactor < 1.0f);
        Preconditions.checkArgument(mapFillFactor > mapIdleFactor);
        Preconditions.checkArgument(expandFactor > 1.0f);
        Preconditions.checkArgument(shrinkFactor > 1.0f);
        int numSections = concurrencyLevel;
        int perSectionExpectedItems = expectedItems / numSections;
        int perSectionCapacity = (int)((float)perSectionExpectedItems / mapFillFactor);
        this.sections = new Section[numSections];
        for (int i = 0; i < numSections; ++i) {
            this.sections[i] = new Section(perSectionCapacity, mapFillFactor, mapIdleFactor, autoShrink, expandFactor, shrinkFactor);
        }
    }

    public long size() {
        long size = 0L;
        for (Section<V> s : this.sections) {
            size += (long)((Section)s).size;
        }
        return size;
    }

    long getUsedBucketCount() {
        long usedBucketCount = 0L;
        for (Section<V> s : this.sections) {
            usedBucketCount += (long)((Section)s).usedBuckets;
        }
        return usedBucketCount;
    }

    public long capacity() {
        long capacity = 0L;
        for (Section<V> s : this.sections) {
            capacity += (long)((Section)s).capacity;
        }
        return capacity;
    }

    public boolean isEmpty() {
        for (Section<V> s : this.sections) {
            if (((Section)s).size == 0) continue;
            return false;
        }
        return true;
    }

    public V get(long key) {
        long h = ConcurrentLongHashMap.hash(key);
        return this.getSection(h).get(key, (int)h);
    }

    public boolean containsKey(long key) {
        return this.get(key) != null;
    }

    public V put(long key, V value) {
        Preconditions.checkNotNull(value);
        long h = ConcurrentLongHashMap.hash(key);
        return this.getSection(h).put(key, value, (int)h, false, null);
    }

    public V putIfAbsent(long key, V value) {
        Preconditions.checkNotNull(value);
        long h = ConcurrentLongHashMap.hash(key);
        return this.getSection(h).put(key, value, (int)h, true, null);
    }

    public V computeIfAbsent(long key, LongFunction<V> provider) {
        Preconditions.checkNotNull(provider);
        long h = ConcurrentLongHashMap.hash(key);
        return this.getSection(h).put(key, null, (int)h, true, provider);
    }

    public V remove(long key) {
        long h = ConcurrentLongHashMap.hash(key);
        return (V)((Section)this.getSection(h)).remove(key, null, (int)h);
    }

    public boolean remove(long key, Object value) {
        Preconditions.checkNotNull(value);
        long h = ConcurrentLongHashMap.hash(key);
        return ((Section)this.getSection(h)).remove(key, value, (int)h) != null;
    }

    public int removeIf(LongObjectPredicate<V> predicate) {
        Preconditions.checkNotNull(predicate);
        int removedCount = 0;
        for (Section<V> s : this.sections) {
            removedCount += s.removeIf(predicate);
        }
        return removedCount;
    }

    private Section<V> getSection(long hash) {
        int sectionIdx = (int)(hash >>> 32) & this.sections.length - 1;
        return this.sections[sectionIdx];
    }

    public void clear() {
        for (Section<V> s : this.sections) {
            s.clear();
        }
    }

    public void forEach(EntryProcessor<V> processor) {
        for (Section<V> s : this.sections) {
            s.forEach(processor);
        }
    }

    public List<Long> keys() {
        ArrayList<Long> keys = Lists.newArrayListWithExpectedSize((int)this.size());
        this.forEach((key, value) -> keys.add(key));
        return keys;
    }

    public List<V> values() {
        ArrayList values = Lists.newArrayListWithExpectedSize((int)this.size());
        this.forEach((key, value) -> values.add(value));
        return values;
    }

    static final long hash(long key) {
        long hash = key * -4132994306676758123L;
        hash ^= hash >>> 47;
        return hash *= -4132994306676758123L;
    }

    static final int signSafeMod(long n, int max) {
        return (int)n & max - 1;
    }

    private static int alignToPowerOfTwo(int n) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(n - 1));
    }

    private static final class Section<V>
    extends StampedLock {
        private volatile long[] keys;
        private volatile V[] values;
        private volatile int capacity;
        private final int initCapacity;
        private volatile int size;
        private int usedBuckets;
        private int resizeThresholdUp;
        private int resizeThresholdBelow;
        private final float mapFillFactor;
        private final float mapIdleFactor;
        private final float expandFactor;
        private final float shrinkFactor;
        private final boolean autoShrink;

        Section(int capacity, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
            this.initCapacity = this.capacity = ConcurrentLongHashMap.alignToPowerOfTwo(capacity);
            this.keys = new long[this.capacity];
            this.values = new Object[this.capacity];
            this.size = 0;
            this.usedBuckets = 0;
            this.autoShrink = autoShrink;
            this.mapFillFactor = mapFillFactor;
            this.mapIdleFactor = mapIdleFactor;
            this.expandFactor = expandFactor;
            this.shrinkFactor = shrinkFactor;
            this.resizeThresholdUp = (int)((float)this.capacity * mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * mapIdleFactor);
        }

        V get(long key, int keyHash) {
            int bucket = keyHash;
            long stamp = this.tryOptimisticRead();
            boolean acquiredLock = false;
            try {
                while (true) {
                    int capacity = this.capacity;
                    bucket = ConcurrentLongHashMap.signSafeMod(bucket, capacity);
                    long storedKey = this.keys[bucket];
                    V storedValue = this.values[bucket];
                    if (!acquiredLock && this.validate(stamp)) {
                        if (storedKey == key) {
                            V v = storedValue != DeletedValue ? storedValue : null;
                            return v;
                        }
                        if (storedValue == EmptyValue) {
                            V v = null;
                            return v;
                        }
                    } else {
                        if (!acquiredLock) {
                            stamp = this.readLock();
                            acquiredLock = true;
                            storedKey = this.keys[bucket];
                            storedValue = this.values[bucket];
                        }
                        if (capacity != this.capacity) {
                            bucket = keyHash;
                            continue;
                        }
                        if (storedKey == key) {
                            V v = storedValue != DeletedValue ? storedValue : null;
                            return v;
                        }
                        if (storedValue == EmptyValue) {
                            V v = null;
                            return v;
                        }
                    }
                    ++bucket;
                }
            }
            finally {
                if (acquiredLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(long key, V value, int keyHash, boolean onlyIfAbsent, LongFunction<V> valueProvider) {
            int bucket = keyHash;
            long stamp = this.writeLock();
            int capacity = this.capacity;
            int firstDeletedKey = -1;
            try {
                while (true) {
                    bucket = ConcurrentLongHashMap.signSafeMod(bucket, capacity);
                    long storedKey = this.keys[bucket];
                    V storedValue = this.values[bucket];
                    if (storedKey == key) {
                        if (storedValue == EmptyValue) {
                            this.values[bucket] = value != null ? value : valueProvider.apply(key);
                            ++this.size;
                            ++this.usedBuckets;
                            V v = valueProvider != null ? (V)this.values[bucket] : null;
                            return v;
                        }
                        if (storedValue == DeletedValue) {
                            this.values[bucket] = value != null ? value : valueProvider.apply(key);
                            ++this.size;
                            V v = valueProvider != null ? (V)this.values[bucket] : null;
                            return v;
                        }
                        if (!onlyIfAbsent) {
                            this.values[bucket] = value;
                            V v = storedValue;
                            return v;
                        }
                        V v = storedValue;
                        return v;
                    }
                    if (storedValue == EmptyValue) {
                        if (firstDeletedKey != -1) {
                            bucket = firstDeletedKey;
                        } else {
                            ++this.usedBuckets;
                        }
                        this.keys[bucket] = key;
                        this.values[bucket] = value != null ? value : valueProvider.apply(key);
                        ++this.size;
                        V v = valueProvider != null ? (V)this.values[bucket] : null;
                        return v;
                    }
                    if (storedValue == DeletedValue && firstDeletedKey == -1) {
                        firstDeletedKey = bucket;
                    }
                    ++bucket;
                }
            }
            finally {
                if (this.usedBuckets > this.resizeThresholdUp) {
                    try {
                        int newCapacity = ConcurrentLongHashMap.alignToPowerOfTwo((int)((float)capacity * this.expandFactor));
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
            }
        }

        private void cleanDeletedStatus(int startBucket) {
            int lastBucket = ConcurrentLongHashMap.signSafeMod(startBucket - 1, this.capacity);
            while (this.values[lastBucket] == DeletedValue) {
                this.values[lastBucket] = EmptyValue;
                --this.usedBuckets;
                --lastBucket;
                lastBucket = ConcurrentLongHashMap.signSafeMod(lastBucket, this.capacity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private V remove(long key, Object value, int keyHash) {
            bucket = keyHash;
            stamp = this.writeLock();
            try {
                while (true) {
                    capacity = this.capacity;
                    bucket = ConcurrentLongHashMap.signSafeMod(bucket, capacity);
                    storedKey = this.keys[bucket];
                    storedValue = this.values[bucket];
                    if (storedKey == key) {
                        if (value == null || value.equals(storedValue)) {
                            if (storedValue == ConcurrentLongHashMap.access$600() || storedValue == ConcurrentLongHashMap.access$500()) {
                                var12_9 = null;
                                return var12_9;
                            }
                            --this.size;
                            nextValueInArray = this.values[ConcurrentLongHashMap.signSafeMod(bucket + 1, capacity)];
                            if (nextValueInArray == ConcurrentLongHashMap.access$600()) {
                                this.values[bucket] = ConcurrentLongHashMap.access$600();
                                --this.usedBuckets;
                                this.cleanDeletedStatus(bucket);
                            } else {
                                this.values[bucket] = ConcurrentLongHashMap.access$500();
                            }
                            newCapacity = storedValue;
                            return newCapacity;
                        }
                        var12_11 = null;
                        return var12_11;
                    }
                    if (storedValue == ConcurrentLongHashMap.access$600()) {
                        var12_12 = null;
                        return var12_12;
                    }
                    ++bucket;
                }
            }
            finally {
                if (this.autoShrink && this.size < this.resizeThresholdBelow) {
                    try {
                        newCapacity = Math.max(ConcurrentLongHashMap.access$400((int)((float)this.capacity / this.shrinkFactor)), this.initCapacity);
                        newResizeThresholdUp = (int)((float)newCapacity * this.mapFillFactor);
                        if (newCapacity >= this.capacity || newResizeThresholdUp <= this.size) ** GOTO lbl43
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
lbl43:
                // 3 sources

            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        int removeIf(LongObjectPredicate<V> filter) {
            stamp = this.writeLock();
            removedCount = 0;
            try {
                capacity = this.capacity;
                for (bucket = 0; this.size > 0 && bucket < capacity; ++bucket) {
                    storedKey = this.keys[bucket];
                    storedValue = this.values[bucket];
                    if (storedValue == ConcurrentLongHashMap.access$600() || storedValue == ConcurrentLongHashMap.access$500() || !filter.test(storedKey, storedValue)) continue;
                    --this.size;
                    ++removedCount;
                    nextValueInArray = this.values[ConcurrentLongHashMap.signSafeMod(bucket + 1, capacity)];
                    if (nextValueInArray == ConcurrentLongHashMap.access$600()) {
                        this.values[bucket] = ConcurrentLongHashMap.access$600();
                        --this.usedBuckets;
                        this.cleanDeletedStatus(bucket);
                        continue;
                    }
                    this.values[bucket] = ConcurrentLongHashMap.access$500();
                }
                var6_5 = removedCount;
                return var6_5;
            }
            finally {
                if (this.autoShrink && this.size < this.resizeThresholdBelow) {
                    try {
                        newCapacity = Math.max(ConcurrentLongHashMap.access$400((int)((float)this.capacity / this.shrinkFactor)), this.initCapacity);
                        newResizeThresholdUp = (int)((float)newCapacity * this.mapFillFactor);
                        if (newCapacity >= this.capacity || newResizeThresholdUp <= this.size) ** GOTO lbl33
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
lbl33:
                // 3 sources

            }
        }

        void clear() {
            long stamp = this.writeLock();
            try {
                if (this.autoShrink && this.capacity > this.initCapacity) {
                    this.shrinkToInitCapacity();
                } else {
                    Arrays.fill(this.keys, 0L);
                    Arrays.fill(this.values, EmptyValue);
                    this.size = 0;
                    this.usedBuckets = 0;
                }
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(EntryProcessor<V> processor) {
            long stamp = this.tryOptimisticRead();
            int capacity = this.capacity;
            long[] keys = this.keys;
            V[] values = this.values;
            boolean acquiredReadLock = false;
            try {
                if (!this.validate(stamp)) {
                    stamp = this.readLock();
                    acquiredReadLock = true;
                    capacity = this.capacity;
                    keys = this.keys;
                    values = this.values;
                }
                for (int bucket = 0; bucket < capacity; ++bucket) {
                    long storedKey = keys[bucket];
                    V storedValue = values[bucket];
                    if (!acquiredReadLock && !this.validate(stamp)) {
                        stamp = this.readLock();
                        acquiredReadLock = true;
                        storedKey = keys[bucket];
                        storedValue = values[bucket];
                    }
                    if (storedValue == DeletedValue || storedValue == EmptyValue) continue;
                    processor.accept(storedKey, storedValue);
                }
            }
            finally {
                if (acquiredReadLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        private void rehash(int newCapacity) {
            long[] newKeys = new long[newCapacity];
            Object[] newValues = new Object[newCapacity];
            for (int i = 0; i < this.keys.length; ++i) {
                long storedKey = this.keys[i];
                V storedValue = this.values[i];
                if (storedValue == EmptyValue || storedValue == DeletedValue) continue;
                Section.insertKeyValueNoLock(newKeys, newValues, storedKey, storedValue);
            }
            this.keys = newKeys;
            this.values = newValues;
            this.usedBuckets = this.size;
            this.capacity = newCapacity;
            this.resizeThresholdUp = (int)((float)this.capacity * this.mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * this.mapIdleFactor);
        }

        private void shrinkToInitCapacity() {
            long[] newKeys = new long[this.initCapacity];
            Object[] newValues = new Object[this.initCapacity];
            this.keys = newKeys;
            this.values = newValues;
            this.size = 0;
            this.usedBuckets = 0;
            this.capacity = this.initCapacity;
            this.resizeThresholdUp = (int)((float)this.capacity * this.mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * this.mapIdleFactor);
        }

        private static <V> void insertKeyValueNoLock(long[] keys, V[] values, long key, V value) {
            int bucket = (int)ConcurrentLongHashMap.hash(key);
            while (true) {
                V storedValue;
                if ((storedValue = values[bucket = ConcurrentLongHashMap.signSafeMod(bucket, keys.length)]) == EmptyValue) {
                    keys[bucket] = key;
                    values[bucket] = value;
                    return;
                }
                ++bucket;
            }
        }
    }

    public static interface EntryProcessor<V> {
        public void accept(long var1, V var3);
    }

    public static interface LongObjectPredicate<V> {
        public boolean test(long var1, V var3);
    }

    public static class Builder<T> {
        int expectedItems = 256;
        int concurrencyLevel = 16;
        float mapFillFactor = 0.66f;
        float mapIdleFactor = 0.15f;
        float expandFactor = 2.0f;
        float shrinkFactor = 2.0f;
        boolean autoShrink = false;

        public Builder<T> expectedItems(int expectedItems) {
            this.expectedItems = expectedItems;
            return this;
        }

        public Builder<T> concurrencyLevel(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder<T> mapFillFactor(float mapFillFactor) {
            this.mapFillFactor = mapFillFactor;
            return this;
        }

        public Builder<T> mapIdleFactor(float mapIdleFactor) {
            this.mapIdleFactor = mapIdleFactor;
            return this;
        }

        public Builder<T> expandFactor(float expandFactor) {
            this.expandFactor = expandFactor;
            return this;
        }

        public Builder<T> shrinkFactor(float shrinkFactor) {
            this.shrinkFactor = shrinkFactor;
            return this;
        }

        public Builder<T> autoShrink(boolean autoShrink) {
            this.autoShrink = autoShrink;
            return this;
        }

        public ConcurrentLongHashMap<T> build() {
            return new ConcurrentLongHashMap(this.expectedItems, this.concurrencyLevel, this.mapFillFactor, this.mapIdleFactor, this.autoShrink, this.expandFactor, this.shrinkFactor);
        }
    }
}

