/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import org.apache.bookkeeper.shaded.com.google.common.base.Preconditions;

public final class ArrayGroupSort {
    private static final int INSERTION_SORT_THRESHOLD = 100;
    private static final int GROUP_SIZE = 4;

    public static void sort(long[] array) {
        ArrayGroupSort.sort(array, 0, array.length);
    }

    public static void sort(long[] array, int offset, int length) {
        Preconditions.checkArgument(length % 4 == 0, "Array length must be multiple of 4");
        ArrayGroupSort.quickSort(array, offset, length + offset - 4);
    }

    private static void quickSort(long[] array, int low, int high) {
        if (low >= high) {
            return;
        }
        if (high - low < 100) {
            ArrayGroupSort.insertionSort(array, low, high);
            return;
        }
        int pivotIdx = ArrayGroupSort.partition(array, low, high);
        ArrayGroupSort.quickSort(array, low, pivotIdx - 4);
        ArrayGroupSort.quickSort(array, pivotIdx + 4, high);
    }

    private static int alignGroup(int count) {
        return count - count % 4;
    }

    private static int partition(long[] array, int low, int high) {
        int mid = low + ArrayGroupSort.alignGroup((high - low) / 2);
        ArrayGroupSort.swap(array, mid, high);
        int i = low;
        for (int j = low; j < high; j += 4) {
            if (!ArrayGroupSort.isLess(array, j, high)) continue;
            ArrayGroupSort.swap(array, j, i);
            i += 4;
        }
        ArrayGroupSort.swap(array, i, high);
        return i;
    }

    private static void swap(long[] array, int a, int b) {
        long tmp0 = array[a];
        long tmp1 = array[a + 1];
        long tmp2 = array[a + 2];
        long tmp3 = array[a + 3];
        array[a] = array[b];
        array[a + 1] = array[b + 1];
        array[a + 2] = array[b + 2];
        array[a + 3] = array[b + 3];
        array[b] = tmp0;
        array[b + 1] = tmp1;
        array[b + 2] = tmp2;
        array[b + 3] = tmp3;
    }

    private static boolean isLess(long[] array, int a, int b) {
        long a0 = array[a];
        long b0 = array[b];
        if (a0 < b0) {
            return true;
        }
        if (a0 > b0) {
            return false;
        }
        return array[a + 1] < array[b + 1];
    }

    private static void insertionSort(long[] a, int low, int high) {
        for (int i = low + 4; i <= high; i += 4) {
            for (int j = i; j > 0 && ArrayGroupSort.isLess(a, j, j - 4); j -= 4) {
                ArrayGroupSort.swap(a, j, j - 4);
            }
        }
    }

    private ArrayGroupSort() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

