/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.stats;

import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;

@StatsDoc(name="bookie", category="server", help="Bookie related stats")
public class BookieStats {
    final StatsLogger statsLogger;
    @StatsDoc(name="WRITE_BYTES", help="total bytes written to a bookie")
    private final Counter writeBytes;
    @StatsDoc(name="READ_BYTES", help="total bytes read from a bookie")
    private final Counter readBytes;
    @StatsDoc(name="BOOKIE_FORCE_LEDGER", help="total force operations occurred on a bookie")
    private final Counter forceLedgerOps;
    @StatsDoc(name="BOOKIE_ADD_ENTRY", help="operations stats of AddEntry on a bookie", parent="ADD_ENTRY")
    private final OpStatsLogger addEntryStats;
    @StatsDoc(name="BOOKIE_RECOVERY_ADD_ENTRY", help="operation stats of RecoveryAddEntry on a bookie")
    private final OpStatsLogger recoveryAddEntryStats;
    @StatsDoc(name="BOOKIE_READ_ENTRY", help="operation stats of ReadEntry on a bookie", parent="READ_ENTRY")
    private final OpStatsLogger readEntryStats;
    @StatsDoc(name="BOOKIE_GET_LIST_OF_ENTRIES_OF_LEDGER", help="operation stats of GetListOfEntriesOfLedger on a bookie", parent="GET_LIST_OF_ENTRIES_OF_LEDGER")
    private final OpStatsLogger getListOfEntriesOfLedgerStats;
    @StatsDoc(name="BOOKIE_ADD_ENTRY_BYTES", help="bytes stats of AddEntry on a bookie")
    private final OpStatsLogger addBytesStats;
    @StatsDoc(name="BOOKIE_READ_ENTRY_BYTES", help="bytes stats of ReadEntry on a bookie")
    private final OpStatsLogger readBytesStats;
    @StatsDoc(name="JOURNAL_DIRS", help="number of configured journal directories")
    private final Gauge<Integer> journalDirsGauge;
    @StatsDoc(name="JOURNAL_QUEUE_MAX_SIZE", help="maximum length of a journal queue")
    private final Gauge<Integer> journalQueueMaxQueueSizeGauge;

    public BookieStats(StatsLogger statsLogger, final int numJournalDirs, final int maxJournalQueueSize) {
        this.statsLogger = statsLogger;
        this.writeBytes = statsLogger.getCounter("WRITE_BYTES");
        this.readBytes = statsLogger.getCounter("READ_BYTES");
        this.forceLedgerOps = statsLogger.getCounter("BOOKIE_FORCE_LEDGER");
        this.addEntryStats = statsLogger.getOpStatsLogger("BOOKIE_ADD_ENTRY");
        this.recoveryAddEntryStats = statsLogger.getOpStatsLogger("BOOKIE_RECOVERY_ADD_ENTRY");
        this.readEntryStats = statsLogger.getOpStatsLogger("BOOKIE_READ_ENTRY");
        this.getListOfEntriesOfLedgerStats = statsLogger.getOpStatsLogger("BOOKIE_GET_LIST_OF_ENTRIES_OF_LEDGER");
        this.addBytesStats = statsLogger.getOpStatsLogger("BOOKIE_ADD_ENTRY_BYTES");
        this.readBytesStats = statsLogger.getOpStatsLogger("BOOKIE_READ_ENTRY_BYTES");
        this.journalDirsGauge = new Gauge<Integer>(){

            @Override
            public Integer getDefaultValue() {
                return numJournalDirs;
            }

            @Override
            public Integer getSample() {
                return numJournalDirs;
            }
        };
        statsLogger.registerGauge("JOURNAL_DIRS", this.journalDirsGauge);
        this.journalQueueMaxQueueSizeGauge = new Gauge<Integer>(){

            @Override
            public Integer getDefaultValue() {
                return maxJournalQueueSize;
            }

            @Override
            public Integer getSample() {
                return maxJournalQueueSize;
            }
        };
        statsLogger.registerGauge("JOURNAL_QUEUE_MAX_SIZE", this.journalQueueMaxQueueSizeGauge);
    }

    public StatsLogger getStatsLogger() {
        return this.statsLogger;
    }

    public Counter getWriteBytes() {
        return this.writeBytes;
    }

    public Counter getReadBytes() {
        return this.readBytes;
    }

    public Counter getForceLedgerOps() {
        return this.forceLedgerOps;
    }

    public OpStatsLogger getAddEntryStats() {
        return this.addEntryStats;
    }

    public OpStatsLogger getRecoveryAddEntryStats() {
        return this.recoveryAddEntryStats;
    }

    public OpStatsLogger getReadEntryStats() {
        return this.readEntryStats;
    }

    public OpStatsLogger getGetListOfEntriesOfLedgerStats() {
        return this.getListOfEntriesOfLedgerStats;
    }

    public OpStatsLogger getAddBytesStats() {
        return this.addBytesStats;
    }

    public OpStatsLogger getReadBytesStats() {
        return this.readBytesStats;
    }

    public Gauge<Integer> getJournalDirsGauge() {
        return this.journalDirsGauge;
    }

    public Gauge<Integer> getJournalQueueMaxQueueSizeGauge() {
        return this.journalQueueMaxQueueSizeGauge;
    }
}

