/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ExecutableTriggerStateMachine
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized int triggerIndex;
    private final @UnknownKeyFor @NonNull @Initialized int firstIndexAfterSubtree;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine> subTriggers = new ArrayList<ExecutableTriggerStateMachine>();
    private final @UnknownKeyFor @NonNull @Initialized TriggerStateMachine trigger;

    public static @UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine create(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine trigger) {
        return ExecutableTriggerStateMachine.create(trigger, 0);
    }

    private static @UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine create(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine trigger, @UnknownKeyFor @NonNull @Initialized int nextUnusedIndex) {
        return new ExecutableTriggerStateMachine(trigger, nextUnusedIndex);
    }

    public static @UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine createForOnceTrigger(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine trigger, @UnknownKeyFor @NonNull @Initialized int nextUnusedIndex) {
        return new ExecutableTriggerStateMachine(trigger, nextUnusedIndex);
    }

    private ExecutableTriggerStateMachine(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine trigger, @UnknownKeyFor @NonNull @Initialized int nextUnusedIndex) {
        this.trigger = (TriggerStateMachine)Preconditions.checkNotNull((Object)trigger, (Object)"trigger must not be null");
        this.triggerIndex = nextUnusedIndex++;
        if (trigger.subTriggers() != null) {
            for (TriggerStateMachine subTrigger : trigger.subTriggers()) {
                ExecutableTriggerStateMachine subExecutable = ExecutableTriggerStateMachine.create(subTrigger, nextUnusedIndex);
                this.subTriggers.add(subExecutable);
                nextUnusedIndex = subExecutable.firstIndexAfterSubtree;
            }
        }
        this.firstIndexAfterSubtree = nextUnusedIndex;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine> subTriggers() {
        return this.subTriggers;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.trigger.toString();
    }

    public @UnknownKeyFor @NonNull @Initialized TriggerStateMachine getSpec() {
        return this.trigger;
    }

    public @UnknownKeyFor @NonNull @Initialized int getTriggerIndex() {
        return this.triggerIndex;
    }

    public final @UnknownKeyFor @NonNull @Initialized int getFirstIndexAfterSubtree() {
        return this.firstIndexAfterSubtree;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(@UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine other) {
        return this.trigger.isCompatible(other.trigger);
    }

    public @UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine getSubTriggerContaining(@UnknownKeyFor @NonNull @Initialized int index) {
        Preconditions.checkNotNull(this.subTriggers);
        Preconditions.checkState((index > this.triggerIndex && index < this.firstIndexAfterSubtree ? 1 : 0) != 0, (Object)"Cannot find sub-trigger containing index not in this tree.");
        ExecutableTriggerStateMachine previous = null;
        for (ExecutableTriggerStateMachine subTrigger : this.subTriggers) {
            if (index < subTrigger.triggerIndex) {
                return previous;
            }
            previous = subTrigger;
        }
        return previous;
    }

    public void invokePrefetchOnElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext c) {
        this.trigger.prefetchOnElement(c.forTrigger(this));
    }

    public void invokeOnElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnElementContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.trigger.onElement(c.forTrigger(this));
    }

    public void invokePrefetchOnMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.MergingPrefetchContext c) {
        this.trigger.prefetchOnMerge(c.forTrigger(this));
    }

    public void invokeOnMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnMergeContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        TriggerStateMachine.OnMergeContext subContext = c.forTrigger(this);
        this.trigger.onMerge(subContext);
    }

    public void invokePrefetchShouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext c) {
        this.trigger.prefetchShouldFire(c.forTrigger(this));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean invokeShouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return this.trigger.shouldFire(c.forTrigger(this));
    }

    public void invokeOnFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.trigger.onFire(c.forTrigger(this));
    }

    public void invokeClear(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.trigger.clear(c.forTrigger(this));
    }
}

