/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SideInputHandler
implements ReadyCheckingSideInputReader {
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> SUPPORTED_MATERIALIZATIONS = ImmutableSet.of((Object)"beam:side_input:iterable:v1", (Object)"beam:side_input:multimap:v1");
    protected final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs;
    private final @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized BoundedWindow>, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized BoundedWindow>>>> availableWindowsTags;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>>>> sideInputContentsTags;

    public SideInputHandler(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals) {
        this.sideInputs = sideInputs;
        this.stateInternals = stateInternals;
        this.availableWindowsTags = new HashMap();
        this.sideInputContentsTags = new HashMap();
        for (PCollectionView<?> sideInput : sideInputs) {
            Preconditions.checkArgument((boolean)SUPPORTED_MATERIALIZATIONS.contains(sideInput.getViewFn().getMaterialization().getUrn()), (String)"This handler is only capable of dealing with %s materializations but was asked to handle %s for PCollectionView with tag %s.", SUPPORTED_MATERIALIZATIONS, (Object)sideInput.getViewFn().getMaterialization().getUrn(), (Object)sideInput.getTagInternal().getId());
            Coder windowCoder = sideInput.getWindowingStrategyInternal().getWindowFn().windowCoder();
            StateTag<CombiningState<BoundedWindow, Set<BoundedWindow>, Set<BoundedWindow>>> availableTag = StateTags.combiningValue("side-input-available-windows-" + sideInput.getTagInternal().getId(), SetCoder.of((Coder)windowCoder), new WindowSetCombineFn());
            this.availableWindowsTags.put(sideInput, availableTag);
            StateTag stateTag = StateTags.value("side-input-data-" + sideInput.getTagInternal().getId(), IterableCoder.of((Coder)sideInput.getCoderInternal()));
            this.sideInputContentsTags.put(sideInput, stateTag);
        }
    }

    public void addSideInputValue(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> sideInput, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>> value) {
        Coder windowCoder = sideInput.getWindowingStrategyInternal().getWindowFn().windowCoder();
        StateTag<ValueState<Iterable<?>>> stateTag = this.sideInputContentsTags.get(sideInput);
        for (BoundedWindow window : value.getWindows()) {
            this.stateInternals.state(StateNamespaces.window(windowCoder, window), stateTag).write((Object)((Iterable)value.getValue()));
            this.stateInternals.state(StateNamespaces.global(), this.availableWindowsTags.get(sideInput)).add((Object)window);
        }
    }

    @Override
    public <T> @Nullable T get(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Iterable elements = this.getIterable(view, window);
        switch (view.getViewFn().getMaterialization().getUrn()) {
            case "beam:side_input:iterable:v1": {
                ViewFn viewFn = view.getViewFn();
                return (T)viewFn.apply(() -> elements);
            }
            case "beam:side_input:multimap:v1": {
                ViewFn viewFn = view.getViewFn();
                Coder keyCoder = ((KvCoder)view.getCoderInternal()).getKeyCoder();
                return (T)viewFn.apply(InMemoryMultimapSideInputView.fromIterable(keyCoder, elements));
            }
        }
        throw new IllegalStateException(String.format("Unknown side input materialization format requested '%s'", view.getViewFn().getMaterialization().getUrn()));
    }

    public <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> getIterable(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Coder windowCoder = view.getWindowingStrategyInternal().getWindowFn().windowCoder();
        StateTag<ValueState<Iterable<?>>> stateTag = this.sideInputContentsTags.get(view);
        ValueState<Iterable<?>> state = this.stateInternals.state(StateNamespaces.window(windowCoder, window), stateTag);
        List elements = (List)state.read();
        return elements != null ? elements : Collections.emptyList();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isReady(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> sideInput, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Set readyWindows = (Set)this.stateInternals.state(StateNamespaces.global(), this.availableWindowsTags.get(sideInput)).read();
        return readyWindows != null && readyWindows.contains(window);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
        return this.sideInputs.contains(view);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.sideInputs.isEmpty();
    }

    private static class WindowSetCombineFn
    extends Combine.CombineFn<BoundedWindow, Set<BoundedWindow>, Set<BoundedWindow>> {
        private WindowSetCombineFn() {
        }

        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized BoundedWindow> createAccumulator() {
            return new HashSet<BoundedWindow>();
        }

        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized BoundedWindow> addInput(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized BoundedWindow> accumulator, @UnknownKeyFor @NonNull @Initialized BoundedWindow input) {
            accumulator.add(input);
            return accumulator;
        }

        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized BoundedWindow> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized BoundedWindow>> accumulators) {
            HashSet<BoundedWindow> result = new HashSet<BoundedWindow>();
            for (Set<BoundedWindow> acc : accumulators) {
                result.addAll(acc);
            }
            return result;
        }

        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized BoundedWindow> extractOutput(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized BoundedWindow> accumulator) {
            return accumulator;
        }
    }
}

