/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.server;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.sdk.fn.server.FnService;
import org.apache.beam.sdk.fn.server.ServerFactory;
import org.apache.beam.vendor.grpc.v1p54p0.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p54p0.io.grpc.Server;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class GrpcFnServer<@UnknownKeyFor ServiceT extends @UnknownKeyFor @NonNull @Initialized FnService>
implements AutoCloseable {
    private final @UnknownKeyFor @NonNull @Initialized Server server;
    private final ServiceT service;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor apiServiceDescriptor;

    public static <ServiceT extends FnService> @UnknownKeyFor @NonNull @Initialized GrpcFnServer<ServiceT> allocatePortAndCreateFor(ServiceT service, @UnknownKeyFor @NonNull @Initialized ServerFactory factory) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Endpoints.ApiServiceDescriptor.Builder apiServiceDescriptor = Endpoints.ApiServiceDescriptor.newBuilder();
        Server server = factory.allocateAddressAndCreate((List<BindableService>)ImmutableList.of(service), apiServiceDescriptor);
        return new GrpcFnServer<ServiceT>(server, service, apiServiceDescriptor.build());
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FnService>> allocatePortAndCreateFor(@UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FnService> services, @UnknownKeyFor @NonNull @Initialized ServerFactory factory) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Endpoints.ApiServiceDescriptor.Builder apiServiceDescriptor = Endpoints.ApiServiceDescriptor.newBuilder();
        Server server = factory.allocateAddressAndCreate(Collections.unmodifiableList(services), apiServiceDescriptor);
        AtomicInteger countdown = new AtomicInteger(services.size());
        return Lists.transform(services, service -> new SharedGrpcFnServer(server, (FnService)service, apiServiceDescriptor.build(), countdown, null));
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FnService>> create(@UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FnService> services, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor endpoint, @UnknownKeyFor @NonNull @Initialized ServerFactory factory) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Server server = factory.create(Collections.unmodifiableList(services), endpoint);
        AtomicInteger countdown = new AtomicInteger(services.size());
        return Lists.transform(services, service -> new SharedGrpcFnServer(server, (FnService)service, endpoint, countdown, null));
    }

    public static <ServiceT extends FnService> @UnknownKeyFor @NonNull @Initialized GrpcFnServer<ServiceT> create(ServiceT service, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor endpoint, @UnknownKeyFor @NonNull @Initialized ServerFactory factory) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new GrpcFnServer<ServiceT>(factory.create((List<BindableService>)ImmutableList.of(service), endpoint), service, endpoint);
    }

    @Deprecated
    public static <ServiceT extends FnService> @UnknownKeyFor @NonNull @Initialized GrpcFnServer<ServiceT> create(ServiceT service, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor endpoint) {
        return new GrpcFnServer(null, service, endpoint){

            @Override
            public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
            }
        };
    }

    private GrpcFnServer(@UnknownKeyFor @NonNull @Initialized Server server, ServiceT service, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor apiServiceDescriptor) {
        this.server = server;
        this.service = service;
        this.apiServiceDescriptor = apiServiceDescriptor;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor getApiServiceDescriptor() {
        return this.apiServiceDescriptor;
    }

    public ServiceT getService() {
        return this.service;
    }

    public @UnknownKeyFor @NonNull @Initialized Server getServer() {
        return this.server;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        try {
            this.server.shutdown();
            this.service.close();
            this.server.awaitTermination(60L, TimeUnit.SECONDS);
        }
        finally {
            this.server.shutdownNow();
            this.server.awaitTermination();
        }
    }

    /* synthetic */ GrpcFnServer(Server x0, FnService x1, Endpoints.ApiServiceDescriptor x2, 1 x3) {
        this(x0, x1, x2);
    }

    private static class SharedGrpcFnServer<@UnknownKeyFor ServiceT extends @UnknownKeyFor @NonNull @Initialized FnService>
    extends GrpcFnServer<ServiceT> {
        private @UnknownKeyFor @NonNull @Initialized AtomicInteger countdown;

        private SharedGrpcFnServer(@UnknownKeyFor @NonNull @Initialized Server server, ServiceT service, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor apiServiceDescriptor, @UnknownKeyFor @NonNull @Initialized AtomicInteger countdown) {
            super(server, (FnService)service, apiServiceDescriptor, null);
            this.countdown = countdown;
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.countdown.addAndGet(-1) == 0) {
                super.close();
            } else {
                this.getService().close();
            }
        }

        /* synthetic */ SharedGrpcFnServer(Server x0, FnService x1, Endpoints.ApiServiceDescriptor x2, AtomicInteger x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }
}

