/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnboundedReadFromBoundedSource<@UnknownKeyFor T>
extends PTransform<PBegin, PCollection<T>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(UnboundedReadFromBoundedSource.class);
    private static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_ESTIMATED_SIZE = 0x4000000L;
    private final @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source;

    public UnboundedReadFromBoundedSource(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source) {
        this.source = source;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        return (PCollection)input.getPipeline().apply((PTransform)Read.from(new BoundedToUnboundedSourceAdapter<T>(this.source)));
    }

    protected @UnknownKeyFor @NonNull @Initialized Coder<T> getDefaultOutputCoder() {
        return this.source.getDefaultOutputCoder();
    }

    public @UnknownKeyFor @NonNull @Initialized String getKindString() {
        return String.format("Read(%s)", NameUtils.approximateSimpleName(this.source));
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        builder.add(DisplayData.item((String)"source", this.source.getClass())).include("source", this.source);
    }

    @VisibleForTesting
    public static class BoundedToUnboundedSourceAdapter<@UnknownKeyFor T>
    extends UnboundedSource<T, Checkpoint<T>> {
        private @UnknownKeyFor @NonNull @Initialized BoundedSource<T> boundedSource;

        public BoundedToUnboundedSourceAdapter(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> boundedSource) {
            this.boundedSource = boundedSource;
        }

        public void validate() {
            this.boundedSource.validate();
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BoundedToUnboundedSourceAdapter<T>> split(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
            try {
                long desiredBundleSize;
                List splits;
                long estimatedSize = this.boundedSource.getEstimatedSizeBytes(options);
                if (estimatedSize <= 0L) {
                    LOG.warn("Cannot determine a valid estimated size for BoundedSource {}. Using default size of {} bytes", this.boundedSource, (Object)0x4000000L);
                    estimatedSize = 0x4000000L;
                }
                if ((splits = this.boundedSource.split(desiredBundleSize = Math.max(estimatedSize / (long)desiredNumSplits, 1L), options)).size() == 0) {
                    splits = ImmutableList.of(this.boundedSource);
                }
                return splits.stream().map(input -> new BoundedToUnboundedSourceAdapter(input)).collect(Collectors.toList());
            }
            catch (Exception e) {
                LOG.warn("Exception while splitting {}, skips the initial splits.", this.boundedSource, (Object)e);
                return ImmutableList.of((Object)((Object)this));
            }
        }

        public @UnknownKeyFor @NonNull @Initialized BoundedToUnboundedSourceAdapter. @UnknownKeyFor @NonNull @Initialized Reader createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized Checkpoint<T> checkpoint) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (checkpoint == null) {
                return new Reader(null, this.boundedSource, options);
            }
            return new Reader(((Checkpoint)checkpoint).residualElements, ((Checkpoint)checkpoint).residualSource, options);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<T> getDefaultOutputCoder() {
            return this.boundedSource.getDefaultOutputCoder();
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Checkpoint<T>> getCheckpointMarkCoder() {
            return new CheckpointCoder(this.boundedSource.getDefaultOutputCoder());
        }

        private class ResidualSource {
            private @UnknownKeyFor @NonNull @Initialized BoundedSource<T> residualSource;
            private @UnknownKeyFor @NonNull @Initialized PipelineOptions options;
            private // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable @UnknownKeyFor @Initialized BoundedSource.BoundedReader<T> reader;
            private @UnknownKeyFor @NonNull @Initialized boolean closed;
            private @UnknownKeyFor @NonNull @Initialized boolean readerDone;

            public ResidualSource(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> residualSource, PipelineOptions options) {
                this.residualSource = (BoundedSource)Preconditions.checkNotNull(residualSource, (Object)"residualSource");
                this.options = (PipelineOptions)Preconditions.checkNotNull((Object)options, (Object)"options");
                this.reader = null;
                this.closed = false;
                this.readerDone = false;
            }

            private @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
                Preconditions.checkArgument((!this.closed ? 1 : 0) != 0, (String)"advance() call on closed %s", (Object)this.getClass().getName());
                if (this.readerDone) {
                    return false;
                }
                if (this.reader == null) {
                    this.reader = this.residualSource.createReader(this.options);
                    this.readerDone = !this.reader.start();
                } else {
                    this.readerDone = !this.reader.advance();
                }
                return !this.readerDone;
            }

            T getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                if (this.reader == null) {
                    throw new NoSuchElementException();
                }
                return this.reader.getCurrent();
            }

            @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                if (this.reader == null) {
                    throw new NoSuchElementException();
                }
                return this.reader.getCurrentTimestamp();
            }

            void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
                if (this.reader != null) {
                    this.reader.close();
                    this.reader = null;
                }
                this.closed = true;
            }

            @UnknownKeyFor @NonNull @Initialized BoundedSource<T> getSource() {
                return this.residualSource;
            }

            @UnknownKeyFor @NonNull @Initialized Checkpoint<T> getCheckpointMark() {
                if (this.reader == null) {
                    return new Checkpoint(null, this.residualSource);
                }
                BoundedSource residualSplit = null;
                Double fractionConsumed = this.reader.getFractionConsumed();
                if (fractionConsumed != null && 0.0 <= fractionConsumed && fractionConsumed <= 1.0) {
                    double fractionRest = 1.0 - fractionConsumed;
                    int splitAttempts = 8;
                    for (int i = 0; i < 8 && residualSplit == null; ++i) {
                        double fractionToSplit = fractionConsumed + fractionRest * (double)i / (double)splitAttempts;
                        residualSplit = this.reader.splitAtFraction(fractionToSplit);
                    }
                }
                ArrayList newResidualElements = Lists.newArrayList();
                try {
                    while (this.advance()) {
                        newResidualElements.add(TimestampedValue.of((Object)this.reader.getCurrent(), (Instant)this.reader.getCurrentTimestamp()));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read elements from the bounded reader.", e);
                }
                return new Checkpoint(newResidualElements, residualSplit);
            }
        }

        private class ResidualElements {
            private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> elementsList;
            private @Nullable @UnknownKeyFor @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> elementsIterator;
            private @Nullable @UnknownKeyFor @Initialized TimestampedValue<T> currentT;
            private @UnknownKeyFor @NonNull @Initialized boolean hasCurrent;
            private @UnknownKeyFor @NonNull @Initialized boolean done;

            ResidualElements(List<TimestampedValue<T>> residualElementsList) {
                this.elementsList = (List)Preconditions.checkNotNull(residualElementsList, (Object)"residualElementsList");
                this.elementsIterator = null;
                this.currentT = null;
                this.hasCurrent = false;
                this.done = false;
            }

            public @UnknownKeyFor @NonNull @Initialized boolean advance() {
                if (this.elementsIterator == null) {
                    this.elementsIterator = this.elementsList.iterator();
                }
                if (this.elementsIterator.hasNext()) {
                    this.currentT = this.elementsIterator.next();
                    this.hasCurrent = true;
                    return true;
                }
                this.done = true;
                this.hasCurrent = false;
                return false;
            }

            @UnknownKeyFor @NonNull @Initialized boolean hasCurrent() {
                return this.hasCurrent;
            }

            @UnknownKeyFor @NonNull @Initialized boolean done() {
                return this.done;
            }

            @UnknownKeyFor @NonNull @Initialized TimestampedValue<T> getCurrentTimestampedValue() {
                if (!this.hasCurrent) {
                    throw new NoSuchElementException();
                }
                return this.currentT;
            }

            T getCurrent() {
                return this.getCurrentTimestampedValue().getValue();
            }

            @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() {
                return this.getCurrentTimestampedValue().getTimestamp();
            }

            @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> getRestElements() {
                if (this.elementsIterator == null) {
                    return this.elementsList;
                }
                ArrayList newResidualElements = Lists.newArrayList();
                while (this.elementsIterator.hasNext()) {
                    newResidualElements.add(this.elementsIterator.next());
                }
                return newResidualElements;
            }
        }

        @VisibleForTesting
        class Reader
        extends UnboundedSource.UnboundedReader<T> {
            private @UnknownKeyFor @NonNull @Initialized BoundedToUnboundedSourceAdapter. @Nullable @UnknownKeyFor @Initialized ResidualElements residualElements;
            private @UnknownKeyFor @NonNull @Initialized BoundedToUnboundedSourceAdapter. @Nullable @UnknownKeyFor @Initialized ResidualSource residualSource;
            private final @UnknownKeyFor @NonNull @Initialized PipelineOptions options;
            private @UnknownKeyFor @NonNull @Initialized boolean done;

            Reader(@Nullable @UnknownKeyFor @Initialized List<TimestampedValue<T>> residualElementsList, @UnknownKeyFor @NonNull @Initialized BoundedSource<T> residualSource, PipelineOptions options) {
                this.init(residualElementsList, residualSource, options);
                this.options = (PipelineOptions)Preconditions.checkNotNull((Object)options, (Object)"options");
                this.done = false;
            }

            private void init(@Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> residualElementsList, @Nullable @UnknownKeyFor @Initialized BoundedSource<T> residualSource, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
                this.residualElements = residualElementsList == null ? new ResidualElements(Collections.emptyList()) : new ResidualElements(residualElementsList);
                this.residualSource = residualSource == null ? null : new ResidualSource(residualSource, options);
            }

            public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
                return this.advance();
            }

            public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
                if (this.residualElements.advance()) {
                    return true;
                }
                if (this.residualSource != null && this.residualSource.advance()) {
                    return true;
                }
                this.done = true;
                return false;
            }

            public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
                if (this.residualSource != null) {
                    this.residualSource.close();
                }
            }

            public T getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                if (this.residualElements.hasCurrent()) {
                    return this.residualElements.getCurrent();
                }
                if (this.residualSource != null) {
                    return this.residualSource.getCurrent();
                }
                throw new NoSuchElementException();
            }

            public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                if (this.residualElements.hasCurrent()) {
                    return this.residualElements.getCurrentTimestamp();
                }
                if (this.residualSource != null) {
                    return this.residualSource.getCurrentTimestamp();
                }
                throw new NoSuchElementException();
            }

            public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
                return this.done ? BoundedWindow.TIMESTAMP_MAX_VALUE : BoundedWindow.TIMESTAMP_MIN_VALUE;
            }

            public @UnknownKeyFor @NonNull @Initialized Checkpoint<T> getCheckpointMark() {
                Checkpoint newCheckpoint = !this.residualElements.done() ? new Checkpoint(this.residualElements.getRestElements(), this.residualSource == null ? null : this.residualSource.getSource()) : (this.residualSource != null ? this.residualSource.getCheckpointMark() : new Checkpoint(null, null));
                this.init(newCheckpoint.residualElements, newCheckpoint.residualSource, this.options);
                return newCheckpoint;
            }

            public @UnknownKeyFor @NonNull @Initialized BoundedToUnboundedSourceAdapter<T> getCurrentSource() {
                return BoundedToUnboundedSourceAdapter.this;
            }
        }

        @VisibleForTesting
        static class CheckpointCoder<@UnknownKeyFor T>
        extends StructuredCoder<Checkpoint<T>> {
            private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>>> elemsCoder;
            private final @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder;
            private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BoundedSource> sourceCoder;

            CheckpointCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
                this.elemsCoder = NullableCoder.of((Coder)ListCoder.of((Coder)TimestampedValue.TimestampedValueCoder.of(elemCoder)));
                this.elemCoder = elemCoder;
                this.sourceCoder = NullableCoder.of((Coder)SerializableCoder.of(BoundedSource.class));
            }

            public void encode(@UnknownKeyFor @NonNull @Initialized Checkpoint<T> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
                this.elemsCoder.encode((Object)((Checkpoint)value).residualElements, outStream);
                this.sourceCoder.encode((Object)((Checkpoint)value).residualSource, outStream);
            }

            public @UnknownKeyFor @NonNull @Initialized Checkpoint<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
                return new Checkpoint((List)this.elemsCoder.decode(inStream), (BoundedSource)this.sourceCoder.decode(inStream));
            }

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
                return Arrays.asList(this.elemCoder);
            }

            public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
                throw new Coder.NonDeterministicException((Coder)this, "CheckpointCoder uses Java Serialization, which may be non-deterministic.");
            }
        }

        @VisibleForTesting
        public static class Checkpoint<@UnknownKeyFor T>
        implements UnboundedSource.CheckpointMark {
            private final @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> residualElements;
            private final @Nullable @UnknownKeyFor @Initialized BoundedSource<T> residualSource;

            public Checkpoint(@Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> residualElements, @Nullable @UnknownKeyFor @Initialized BoundedSource<T> residualSource) {
                this.residualElements = residualElements;
                this.residualSource = residualSource;
            }

            public void finalizeCheckpoint() {
            }

            @VisibleForTesting
            @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> getResidualElements() {
                return this.residualElements;
            }

            @VisibleForTesting
            @Nullable @UnknownKeyFor @Initialized BoundedSource<T> getResidualSource() {
                return this.residualSource;
            }
        }
    }
}

