/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.debug;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.beam.fn.harness.debug.ElementSample;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.sdk.util.WindowedValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class OutputSampler<@UnknownKeyFor T> {
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ElementSample<T>> buffer;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ElementSample<T>> exceptions = new HashMap<String, ElementSample<T>>();
    private final @UnknownKeyFor @NonNull @Initialized int maxElements;
    private final @UnknownKeyFor @NonNull @Initialized int sampleEveryN;
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong numSamples = new AtomicLong();
    private @UnknownKeyFor @NonNull @Initialized int resampleIndex = 0;
    @Nullable
    private final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Coder<T> valueCoder;
    @Nullable
    private final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> windowedValueCoder;

    public OutputSampler(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> coder, @UnknownKeyFor @NonNull @Initialized int maxElements, @UnknownKeyFor @NonNull @Initialized int sampleEveryN) {
        this.maxElements = maxElements;
        this.sampleEveryN = sampleEveryN;
        this.buffer = new ArrayList<ElementSample<T>>(this.maxElements);
        if (coder instanceof WindowedValue.WindowedValueCoder) {
            this.valueCoder = null;
            this.windowedValueCoder = coder;
        } else {
            this.valueCoder = coder;
            this.windowedValueCoder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized ElementSample<T> sample(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> element) {
        long samples = this.numSamples.get() + 1L;
        this.numSamples.lazySet(samples);
        ElementSample<T> elementSample = new ElementSample<T>(ThreadLocalRandom.current().nextInt(), element);
        if (samples > 10L && samples % (long)this.sampleEveryN != 0L) {
            return elementSample;
        }
        OutputSampler outputSampler = this;
        synchronized (outputSampler) {
            if (this.buffer.size() < this.maxElements) {
                this.buffer.add(elementSample);
            } else {
                this.buffer.set(this.resampleIndex, elementSample);
                this.resampleIndex = (this.resampleIndex + 1) % this.maxElements;
            }
        }
        return elementSample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(@UnknownKeyFor @NonNull @Initialized ElementSample<T> elementSample, @UnknownKeyFor @NonNull @Initialized Exception e, @UnknownKeyFor @NonNull @Initialized String ptransformId, @UnknownKeyFor @NonNull @Initialized String processBundleId) {
        if (elementSample == null || processBundleId == null) {
            return;
        }
        OutputSampler outputSampler = this;
        synchronized (outputSampler) {
            this.exceptions.computeIfAbsent(processBundleId, pbId -> {
                elementSample.exception = new ElementSample.ExceptionMetadata(e.toString(), ptransformId);
                return elementSample;
            });
        }
    }

    private  @UnknownKeyFor @NonNull @Initialized BeamFnApi.SampledElement sampleToProto(@UnknownKeyFor @NonNull @Initialized ElementSample<T> sample, @UnknownKeyFor @NonNull @Initialized ByteStringOutputStream stream, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String processBundleId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.valueCoder != null) {
            this.valueCoder.encode(sample.sample.getValue(), (OutputStream)stream, Coder.Context.NESTED);
        } else if (this.windowedValueCoder != null) {
            this.windowedValueCoder.encode(sample.sample, (OutputStream)stream, Coder.Context.NESTED);
        }
        BeamFnApi.SampledElement.Builder elementBuilder = BeamFnApi.SampledElement.newBuilder().setElement(stream.toByteStringAndReset());
        ElementSample.ExceptionMetadata exception = sample.exception;
        if (exception != null) {
            BeamFnApi.SampledElement.Exception.Builder exceptionBuilder = BeamFnApi.SampledElement.Exception.newBuilder().setTransformId(exception.ptransformId).setError(exception.message);
            if (processBundleId != null) {
                exceptionBuilder.setInstructionId(processBundleId);
            }
            elementBuilder.setException(exceptionBuilder);
        }
        return elementBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized BeamFnApi.SampledElement> samples() throws @UnknownKeyFor @NonNull @Initialized IOException {
        List<ElementSample<T>> bufferToSend;
        ArrayList<BeamFnApi.SampledElement> ret = new ArrayList<BeamFnApi.SampledElement>();
        int sampleIndex = 0;
        OutputSampler outputSampler = this;
        synchronized (outputSampler) {
            bufferToSend = this.buffer;
            sampleIndex = this.resampleIndex;
            this.buffer = new ArrayList<ElementSample<T>>(this.maxElements);
            this.resampleIndex = 0;
        }
        HashSet<Long> seen = new HashSet<Long>();
        ByteStringOutputStream stream = new ByteStringOutputStream();
        for (Map.Entry<String, ElementSample<T>> pair : this.exceptions.entrySet()) {
            String processBundleId = pair.getKey();
            ElementSample<T> sample = pair.getValue();
            seen.add(sample.id);
            ret.add(this.sampleToProto(sample, stream, processBundleId));
        }
        this.exceptions.clear();
        for (int i = 0; i < bufferToSend.size(); ++i) {
            int index = (sampleIndex + i) % bufferToSend.size();
            ElementSample<T> sample = bufferToSend.get(index);
            if (seen.contains(sample.id)) continue;
            ret.add(this.sampleToProto(sample, stream, null));
        }
        return ret;
    }
}

