/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.debug;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.fn.harness.debug.OutputSampler;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ProtocolStringList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSampler {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DataSampler.class);
    private final @UnknownKeyFor @NonNull @Initialized int maxSamples;
    private final @UnknownKeyFor @NonNull @Initialized int sampleEveryN;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputSampler<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputSamplers = new ConcurrentHashMap();

    public DataSampler() {
        this(10, 1000);
    }

    public DataSampler(@UnknownKeyFor @NonNull @Initialized int maxSamples, @UnknownKeyFor @NonNull @Initialized int sampleEveryN) {
        Preconditions.checkArgument((maxSamples > 0 ? 1 : 0) != 0, (Object)"Expected positive number of samples, did you mean to disable data sampling?");
        Preconditions.checkArgument((sampleEveryN > 0 ? 1 : 0) != 0, (Object)"Expected positive number for sampling period, did you mean to disable data sampling?");
        this.maxSamples = maxSamples;
        this.sampleEveryN = sampleEveryN;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized OutputSampler<T> sampleOutput(@UnknownKeyFor @NonNull @Initialized String pcollectionId, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        return this.outputSamplers.computeIfAbsent(pcollectionId, k -> new OutputSampler(coder, this.maxSamples, this.sampleEveryN));
    }

    public synchronized  @UnknownKeyFor @NonNull @Initialized BeamFnApi.InstructionResponse.Builder handleDataSampleRequest( @UnknownKeyFor @NonNull @Initialized BeamFnApi.InstructionRequest request) {
        BeamFnApi.SampleDataRequest sampleDataRequest = request.getSampleData();
        ProtocolStringList pcollections = sampleDataRequest.getPcollectionIdsList();
        BeamFnApi.SampleDataResponse.Builder response = BeamFnApi.SampleDataResponse.newBuilder();
        this.outputSamplers.forEach((arg_0, arg_1) -> DataSampler.lambda$handleDataSampleRequest$1((List)pcollections, response, arg_0, arg_1));
        return BeamFnApi.InstructionResponse.newBuilder().setSampleData(response);
    }

    private static /* synthetic */ void lambda$handleDataSampleRequest$1(List pcollections, BeamFnApi.SampleDataResponse.Builder response, String pcollectionId, OutputSampler outputSampler) {
        if (!pcollections.isEmpty() && !pcollections.contains(pcollectionId)) {
            return;
        }
        try {
            response.putElementSamples(pcollectionId, BeamFnApi.SampleDataResponse.ElementList.newBuilder().addAllElements(outputSampler.samples()).build());
        }
        catch (IOException e) {
            LOG.warn("Could not encode elements from \"" + pcollectionId + "\" to bytes: " + e);
        }
    }
}

