/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.Caches;
import org.apache.beam.runners.core.GlobalCombineFnRunner;
import org.apache.beam.runners.core.GlobalCombineFnRunners;
import org.apache.beam.runners.core.NullSideInputReader;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.Weighted;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

@NotThreadSafe
public class PrecombineGroupingTable<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor AccumT>
implements Cache.Shrinkable<PrecombineGroupingTable<K, InputT, AccumT>>,
Weighted {
    private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized GlobalCombineFnRunner<InputT, AccumT, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> combineFn;
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions options;
    private final @UnknownKeyFor @NonNull @Initialized SizeEstimator sizer;
    private final @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized Key, @UnknownKeyFor @NonNull @Initialized PrecombineGroupingTable<K, InputT, AccumT>> cache;
    private final @UnknownKeyFor @NonNull @Initialized LinkedHashMap<@UnknownKeyFor @NonNull @Initialized GroupingTableKey, @UnknownKeyFor @NonNull @Initialized PrecombineGroupingTable. @UnknownKeyFor @NonNull @Initialized GroupingTableEntry> lruMap;
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong maxWeight;
    private @UnknownKeyFor @NonNull @Initialized long weight;
    private final @UnknownKeyFor @NonNull @Initialized boolean isGloballyWindowed;
    private @UnknownKeyFor @NonNull @Initialized long lastWeightForFlush;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_GROUPING_TABLE_SIZE = 12000;

    public static <K, InputT, AccumT> @UnknownKeyFor @NonNull @Initialized PrecombineGroupingTable<K, InputT, AccumT> combining(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> cache, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> combineFn, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized boolean isGloballyWindowed) {
        return new PrecombineGroupingTable<K, InputT, AccumT>(options, cache, keyCoder, GlobalCombineFnRunners.create(combineFn), Caches::weigh, isGloballyWindowed);
    }

    public static <K, InputT, AccumT> @UnknownKeyFor @NonNull @Initialized PrecombineGroupingTable<K, InputT, AccumT> combiningAndSampling(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> cache, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> combineFn, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized double sizeEstimatorSampleRate, @UnknownKeyFor @NonNull @Initialized boolean isGloballyWindowed) {
        return new PrecombineGroupingTable<K, InputT, AccumT>(options, cache, keyCoder, GlobalCombineFnRunners.create(combineFn), new SamplingSizeEstimator(Caches::weigh, sizeEstimatorSampleRate, 1.0), isGloballyWindowed);
    }

    @Override
    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized PrecombineGroupingTable<K, InputT, AccumT> shrink() {
        long currentWeight = this.maxWeight.updateAndGet(operand -> operand >> 1);
        if (currentWeight <= 100L) {
            return null;
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized long getWeight() {
        return this.maxWeight.get();
    }

    PrecombineGroupingTable(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> cache, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized GlobalCombineFnRunner<InputT, AccumT, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> combineFn, @UnknownKeyFor @NonNull @Initialized SizeEstimator sizer, @UnknownKeyFor @NonNull @Initialized boolean isGloballyWindowed) {
        this.options = options;
        this.cache = cache;
        this.keyCoder = keyCoder;
        this.combineFn = combineFn;
        this.sizer = sizer;
        this.isGloballyWindowed = isGloballyWindowed;
        this.lruMap = new LinkedHashMap(16, 0.75f, true);
        this.maxWeight = new AtomicLong();
        this.weight = 0L;
        this.cache.put(Key.INSTANCE, this);
    }

    @VisibleForTesting
    public void put(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> value, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, AccumT>>> receiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
        GroupingTableKey groupingKey = this.isGloballyWindowed ? new GloballyWindowedTableGroupingKey(((KV)value.getValue()).getKey(), this.keyCoder, this.sizer) : new WindowedGroupingTableKey(((KV)value.getValue()).getKey(), value.getWindows(), this.keyCoder, this.sizer);
        this.lruMap.compute(groupingKey, (key, tableEntry) -> {
            if (tableEntry == null) {
                this.weight += groupingKey.getWeight();
                tableEntry = new GroupingTableEntry(groupingKey, value.getTimestamp(), ((KV)value.getValue()).getKey(), ((KV)value.getValue()).getValue());
            } else {
                this.weight -= tableEntry.getWeight();
                tableEntry.add(((KV)value.getValue()).getValue());
            }
            this.weight += tableEntry.getWeight();
            return tableEntry;
        });
        if (this.lruMap.size() >= 12000) {
            this.flush(receiver);
            this.lastWeightForFlush = this.weight;
        } else if (Caches.shouldUpdateOnSizeChange(this.lastWeightForFlush, this.weight)) {
            this.flushIfNeeded(receiver);
            this.lastWeightForFlush = this.weight;
        }
    }

    private void flushIfNeeded(@UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, AccumT>>> receiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.maxWeight.accumulateAndGet(this.weight, (current, update) -> current < update ? update : current);
        this.cache.put(Key.INSTANCE, this);
        long currentMax = this.maxWeight.get();
        if (this.weight > currentMax) {
            for (GroupingTableEntry valueToCompact : this.lruMap.values()) {
                long currentWeight = valueToCompact.getWeight();
                valueToCompact.compact();
                this.weight += valueToCompact.getWeight() - currentWeight;
            }
            if (this.weight > currentMax) {
                Iterator<GroupingTableEntry> iterator = this.lruMap.values().iterator();
                while (iterator.hasNext()) {
                    GroupingTableEntry valueToFlush = iterator.next();
                    this.weight -= valueToFlush.getWeight() + valueToFlush.getGroupingKey().getWeight();
                    iterator.remove();
                    this.output(valueToFlush, receiver);
                    if (this.weight > currentMax) continue;
                    break;
                }
            }
        }
    }

    private void output(@UnknownKeyFor @NonNull @Initialized PrecombineGroupingTable. @UnknownKeyFor @NonNull @Initialized GroupingTableEntry entry, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, AccumT>>> receiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
        entry.compact();
        receiver.accept(this.isGloballyWindowed ? WindowedValue.valueInGlobalWindow((Object)KV.of(entry.getKey(), entry.getAccumulator())) : WindowedValue.of((Object)KV.of(entry.getKey(), entry.getAccumulator()), (Instant)entry.getOutputTimestamp(), entry.getGroupingKey().getWindows(), (PaneInfo)PaneInfo.NO_FIRING));
    }

    public void flush(@UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, AccumT>>> receiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.cache.remove(Key.INSTANCE);
        for (GroupingTableEntry valueToFlush : this.lruMap.values()) {
            this.output(valueToFlush, receiver);
        }
        this.lruMap.clear();
        this.weight = 0L;
    }

    @VisibleForTesting
    static class SamplingSizeEstimator
    implements SizeEstimator {
        static final @UnknownKeyFor @NonNull @Initialized double CONFIDENCE_INTERVAL_SIGMA = 3.0;
        static final @UnknownKeyFor @NonNull @Initialized double CONFIDENCE_INTERVAL_SIZE = 0.25;
        static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_MIN_SAMPLED = 20L;
        private final @UnknownKeyFor @NonNull @Initialized SizeEstimator underlying;
        private final @UnknownKeyFor @NonNull @Initialized double minSampleRate;
        private final @UnknownKeyFor @NonNull @Initialized double maxSampleRate;
        private final @UnknownKeyFor @NonNull @Initialized long minSampled;
        private final @UnknownKeyFor @NonNull @Initialized Random random;
        private @UnknownKeyFor @NonNull @Initialized long totalElements = 0L;
        private @UnknownKeyFor @NonNull @Initialized long sampledElements = 0L;
        private @UnknownKeyFor @NonNull @Initialized long sampledSum = 0L;
        private @UnknownKeyFor @NonNull @Initialized double sampledSumSquares = 0.0;
        private @UnknownKeyFor @NonNull @Initialized long estimate;
        private @UnknownKeyFor @NonNull @Initialized long nextSample = 0L;

        private SamplingSizeEstimator(@UnknownKeyFor @NonNull @Initialized SizeEstimator underlying, @UnknownKeyFor @NonNull @Initialized double minSampleRate, @UnknownKeyFor @NonNull @Initialized double maxSampleRate) {
            this(underlying, minSampleRate, maxSampleRate, 20L, new Random());
        }

        @VisibleForTesting
        SamplingSizeEstimator(@UnknownKeyFor @NonNull @Initialized SizeEstimator underlying, @UnknownKeyFor @NonNull @Initialized double minSampleRate, @UnknownKeyFor @NonNull @Initialized double maxSampleRate, @UnknownKeyFor @NonNull @Initialized long minSampled, @UnknownKeyFor @NonNull @Initialized Random random) {
            this.underlying = underlying;
            this.minSampleRate = minSampleRate;
            this.maxSampleRate = maxSampleRate;
            this.minSampled = minSampled;
            this.random = random;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long estimateSize(@UnknownKeyFor @NonNull @Initialized Object element) {
            if (this.sampleNow()) {
                return this.recordSample(this.underlying.estimateSize(element));
            }
            return this.estimate;
        }

        private @UnknownKeyFor @NonNull @Initialized boolean sampleNow() {
            ++this.totalElements;
            return --this.nextSample < 0L;
        }

        private @UnknownKeyFor @NonNull @Initialized long recordSample(@UnknownKeyFor @NonNull @Initialized long value) {
            double rate;
            ++this.sampledElements;
            this.sampledSum += value;
            this.sampledSumSquares += (double)(value * value);
            this.estimate = (long)Math.ceil((double)this.sampledSum / (double)this.sampledElements);
            long target = this.desiredSampleSize();
            this.nextSample = this.sampledElements < this.minSampled || this.sampledElements < target ? 0L : ((rate = SamplingSizeEstimator.cap(this.minSampleRate, this.maxSampleRate, Math.max(1.0 / (double)(this.totalElements - this.minSampled + 1L), (double)target / (double)this.totalElements))) == 1.0 ? 0L : (long)Math.floor(Math.log(this.random.nextDouble()) / Math.log(1.0 - rate)));
            return value;
        }

        private static @UnknownKeyFor @NonNull @Initialized double cap(@UnknownKeyFor @NonNull @Initialized double min2, @UnknownKeyFor @NonNull @Initialized double max, @UnknownKeyFor @NonNull @Initialized double value) {
            return Math.min(max, Math.max(min2, value));
        }

        private @UnknownKeyFor @NonNull @Initialized long desiredSampleSize() {
            double mean = (double)this.sampledSum / (double)this.sampledElements;
            double sumSquareDiff = this.sampledSumSquares - 2.0 * mean * (double)this.sampledSum + (double)this.sampledElements * mean * mean;
            double stddev = Math.sqrt(sumSquareDiff / (double)(this.sampledElements - 1L));
            double sqrtDesiredSamples = 3.0 * stddev / (0.25 * mean);
            return (long)Math.ceil(sqrtDesiredSamples * sqrtDesiredSamples);
        }
    }

    @VisibleForTesting
    class GroupingTableEntry
    implements Weighted {
        private final @UnknownKeyFor @NonNull @Initialized GroupingTableKey groupingKey;
        private final K userKey;
        private final @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp;
        private final @UnknownKeyFor @NonNull @Initialized long keySize;
        private @UnknownKeyFor @NonNull @Initialized long accumulatorSize;
        private AccumT accumulator;
        private @UnknownKeyFor @NonNull @Initialized boolean dirty;

        private GroupingTableEntry(@UnknownKeyFor @NonNull @Initialized GroupingTableKey groupingKey, Instant outputTimestamp, K userKey, InputT initialInputValue) {
            this.groupingKey = groupingKey;
            this.outputTimestamp = outputTimestamp;
            this.userKey = userKey;
            this.keySize = groupingKey.getStructuralKey() == userKey ? 16L : 8L + PrecombineGroupingTable.this.sizer.estimateSize(userKey);
            this.accumulator = PrecombineGroupingTable.this.combineFn.createAccumulator(PrecombineGroupingTable.this.options, NullSideInputReader.empty(), groupingKey.getWindows());
            this.add(initialInputValue);
            this.accumulatorSize = PrecombineGroupingTable.this.sizer.estimateSize(this.accumulator);
        }

        public @UnknownKeyFor @NonNull @Initialized GroupingTableKey getGroupingKey() {
            return this.groupingKey;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getOutputTimestamp() {
            return this.outputTimestamp;
        }

        public K getKey() {
            return this.userKey;
        }

        public AccumT getAccumulator() {
            return this.accumulator;
        }

        public @UnknownKeyFor @NonNull @Initialized long getWeight() {
            return this.keySize + this.accumulatorSize;
        }

        public void compact() {
            if (this.dirty) {
                this.accumulator = PrecombineGroupingTable.this.combineFn.compact(this.accumulator, PrecombineGroupingTable.this.options, NullSideInputReader.empty(), this.groupingKey.getWindows());
                this.accumulatorSize = PrecombineGroupingTable.this.sizer.estimateSize(this.accumulator);
                this.dirty = false;
            }
        }

        public void add(InputT value) {
            this.dirty = true;
            this.accumulator = PrecombineGroupingTable.this.combineFn.addInput(this.accumulator, value, PrecombineGroupingTable.this.options, NullSideInputReader.empty(), this.groupingKey.getWindows());
            this.accumulatorSize = PrecombineGroupingTable.this.sizer.estimateSize(this.accumulator);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "GroupingTableEntry{groupingKey=" + this.groupingKey + ", userKey=" + this.userKey + ", keySize=" + this.keySize + ", accumulatorSize=" + this.accumulatorSize + ", accumulator=" + this.accumulator + ", dirty=" + this.dirty + '}';
        }
    }

    @VisibleForTesting
    static class GloballyWindowedTableGroupingKey
    implements GroupingTableKey {
        private static final @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> GLOBAL_WINDOWS = Collections.singletonList(GlobalWindow.INSTANCE);
        private final @UnknownKeyFor @NonNull @Initialized Object structuralKey;
        private final @UnknownKeyFor @NonNull @Initialized long weight;

        private <K> GloballyWindowedTableGroupingKey(K key, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized SizeEstimator sizer) {
            this.structuralKey = keyCoder.structuralValue(key);
            this.weight = sizer.estimateSize(this);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object getStructuralKey() {
            return this.structuralKey;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return GLOBAL_WINDOWS;
        }

        public @UnknownKeyFor @NonNull @Initialized long getWeight() {
            return this.weight;
        }

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GloballyWindowedTableGroupingKey)) {
                return false;
            }
            GloballyWindowedTableGroupingKey that = (GloballyWindowedTableGroupingKey)o;
            return this.structuralKey.equals(that.structuralKey);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.structuralKey.hashCode();
        }
    }

    @VisibleForTesting
    static class WindowedGroupingTableKey
    implements GroupingTableKey {
        private final @UnknownKeyFor @NonNull @Initialized Object structuralKey;
        private final @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows;
        private final @UnknownKeyFor @NonNull @Initialized long weight;

        <K> WindowedGroupingTableKey(K key, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized SizeEstimator sizer) {
            this.structuralKey = keyCoder.structuralValue(key);
            this.windows = windows;
            this.weight = sizer.estimateSize(this);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object getStructuralKey() {
            return this.structuralKey;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return this.windows;
        }

        public @UnknownKeyFor @NonNull @Initialized long getWeight() {
            return this.weight;
        }

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WindowedGroupingTableKey)) {
                return false;
            }
            WindowedGroupingTableKey that = (WindowedGroupingTableKey)o;
            return this.structuralKey.equals(that.structuralKey) && this.windows.equals(that.windows);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.structuralKey.hashCode() * 31 + this.windows.hashCode();
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "GroupingTableKey{structuralKey=" + this.structuralKey + ", windows=" + this.windows + ", weight=" + this.weight + '}';
        }
    }

    private static interface GroupingTableKey
    extends Weighted {
        public @UnknownKeyFor @NonNull @Initialized Object getStructuralKey();

        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows();

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object var1);

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode();
    }

    private static final class Key
    implements Weighted {
        private static final @UnknownKeyFor @NonNull @Initialized Key INSTANCE = new Key();

        private Key() {
        }

        public @UnknownKeyFor @NonNull @Initialized long getWeight() {
            return 0L;
        }
    }

    @FunctionalInterface
    public static interface SizeEstimator {
        public @UnknownKeyFor @NonNull @Initialized long estimateSize(@UnknownKeyFor @NonNull @Initialized Object var1);
    }
}

