/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.repo;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.axis2.maven2.repo.ArchiveDeployer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreateRepositoryMojo
extends AbstractMojo {
    private Set<Artifact> projectArtifacts;
    private List<MavenProject> collectedProjects;
    private String servicesDirectory;
    private String modulesDirectory;
    private File axis2xml;
    private String configurationDirectory;
    private boolean useDependencies;
    private boolean useModules;
    private boolean generateFileLists;
    private boolean stripServiceVersion;
    private boolean stripModuleVersion;
    private boolean includeModules;
    private String modules;
    private boolean includeServices;
    private String services;

    protected abstract String getScope();

    protected abstract File getOutputDirectory();

    public void execute() throws MojoExecutionException, MojoFailureException {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        if (this.useDependencies) {
            artifacts.addAll(this.projectArtifacts);
        }
        if (this.useModules) {
            for (MavenProject project : this.collectedProjects) {
                artifacts.add(project.getArtifact());
                artifacts.addAll(project.getAttachedArtifacts());
            }
        }
        File outputDirectory = this.getOutputDirectory();
        if (this.includeModules || this.includeServices) {
            FilterArtifacts filter = new FilterArtifacts();
            filter.addFilter((ArtifactsFilter)new ScopeFilter(this.getScope(), null));
            if (this.includeModules && this.includeServices) {
                filter.addFilter((ArtifactsFilter)new TypeFilter("aar,mar", null));
            } else if (this.includeModules) {
                filter.addFilter((ArtifactsFilter)new TypeFilter("mar", null));
            }
            try {
                artifacts = filter.filter(artifacts);
            }
            catch (ArtifactFilterException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
            }
            this.selectArtifacts(artifacts, this.modules, "mar");
            this.selectArtifacts(artifacts, this.services, "aar");
            HashMap<String, ArchiveDeployer> deployers = new HashMap<String, ArchiveDeployer>();
            deployers.put("aar", new ArchiveDeployer(outputDirectory, this.servicesDirectory, "services.list", this.generateFileLists, this.stripServiceVersion));
            deployers.put("mar", new ArchiveDeployer(outputDirectory, this.modulesDirectory, "modules.list", this.generateFileLists, this.stripModuleVersion));
            for (Artifact artifact : artifacts) {
                File file = artifact.getFile();
                if (file == null || file.isDirectory()) {
                    throw new MojoFailureException("Artifact " + artifact.getId() + " not available. " + "This typically means that it is part of the reactor but that the " + "package phase has not been executed.");
                }
                String type = artifact.getType();
                ArchiveDeployer deployer = (ArchiveDeployer)deployers.get(type);
                if (deployer == null) {
                    throw new MojoExecutionException("No deployer found for artifact type " + type);
                }
                deployer.deploy(this.getLog(), artifact);
            }
            for (ArchiveDeployer deployer : deployers.values()) {
                deployer.finish(this.getLog());
            }
        }
        if (this.axis2xml != null) {
            this.getLog().info((CharSequence)"Copying axis2.xml");
            File targetDirectory = this.configurationDirectory == null ? outputDirectory : new File(outputDirectory, this.configurationDirectory);
            try {
                FileUtils.copyFile((File)this.axis2xml, (File)new File(targetDirectory, "axis2.xml"));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error copying axis2.xml file: " + ex.getMessage(), (Exception)ex);
            }
        }
    }

    private void selectArtifacts(Set<Artifact> artifacts, String list, String type) throws MojoFailureException {
        if (list != null) {
            HashSet<String> set = new HashSet<String>(Arrays.asList(StringUtils.stripAll((String[])StringUtils.split((String)list, (String)","))));
            Iterator<Artifact> it = artifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = it.next();
                if (!artifact.getType().equals(type) || set.remove(artifact.getArtifactId())) continue;
                it.remove();
            }
            if (!set.isEmpty()) {
                throw new MojoFailureException("The following " + type + " artifacts have not been found: " + set);
            }
        }
    }
}

