/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl;

import org.apache.ws.java2wsdl.DefaultNamespaceGenerator;
import org.apache.ws.java2wsdl.NamespaceGenerator;

public class Java2WSDLUtils {
    public static final String HTTP = "http://";
    public static final char PACKAGE_CLASS_DELIMITER = '.';
    public static final String SCHEMA_NAMESPACE_EXTN = "/xsd";
    private static NamespaceGenerator defaultNsGenerator = new DefaultNamespaceGenerator();

    public static boolean isURL(String entry) {
        return entry.startsWith(HTTP);
    }

    public static String getSimpleClassName(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(".");
        if (index > 0) {
            return qualifiedName.substring(index + 1, qualifiedName.length());
        }
        return qualifiedName;
    }

    public static StringBuffer namespaceFromClassName(String className, ClassLoader classLoader) throws Exception {
        return Java2WSDLUtils.namespaceFromClassName(className, classLoader, defaultNsGenerator);
    }

    public static StringBuffer namespaceFromClassName(String className, ClassLoader classLoader, NamespaceGenerator nsGen) throws Exception {
        Class<?> clazz = Class.forName(className, true, classLoader);
        Package pkg = clazz.getPackage();
        String name = pkg != null ? pkg.getName() : Java2WSDLUtils.packageNameFromClass(className);
        return nsGen.namespaceFromPackageName(name);
    }

    public static StringBuffer schemaNamespaceFromClassName(String packageName, ClassLoader loader) throws Exception {
        return Java2WSDLUtils.schemaNamespaceFromClassName(packageName, loader, defaultNsGenerator);
    }

    public static StringBuffer schemaNamespaceFromClassName(String packageName, ClassLoader loader, NamespaceGenerator nsGen) throws Exception {
        StringBuffer stringBuffer = Java2WSDLUtils.namespaceFromClassName(packageName, loader, nsGen);
        if (stringBuffer.length() == 0) {
            stringBuffer.append("http://ws.apache.org/axis2");
        }
        stringBuffer.append(SCHEMA_NAMESPACE_EXTN);
        return stringBuffer;
    }

    public static StringBuffer targetNamespaceFromClassName(String packageName, ClassLoader loader, NamespaceGenerator nsGen) throws Exception {
        StringBuffer stringBuffer = Java2WSDLUtils.namespaceFromClassName(packageName, loader, nsGen);
        if (stringBuffer.length() == 0) {
            stringBuffer.append("http://ws.apache.org/axis2");
        }
        return stringBuffer;
    }

    public static String getPackageName(String className, ClassLoader classLoader) throws Exception {
        Class<?> clazz = Class.forName(className, true, classLoader);
        Package pkg = clazz.getPackage();
        String name = pkg != null ? pkg.getName() : Java2WSDLUtils.packageNameFromClass(className);
        return name;
    }

    protected static String packageNameFromClass(String name) {
        String ret = "";
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            ret = name.substring(0, lastDot);
        }
        return ret;
    }
}

