/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.TypeCategory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public abstract class AtlasBaseTypeDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ATLAS_TYPE_BOOLEAN = "boolean";
    public static final String ATLAS_TYPE_BYTE = "byte";
    public static final String ATLAS_TYPE_SHORT = "short";
    public static final String ATLAS_TYPE_INT = "int";
    public static final String ATLAS_TYPE_LONG = "long";
    public static final String ATLAS_TYPE_FLOAT = "float";
    public static final String ATLAS_TYPE_DOUBLE = "double";
    public static final String ATLAS_TYPE_BIGINTEGER = "biginteger";
    public static final String ATLAS_TYPE_BIGDECIMAL = "bigdecimal";
    public static final String ATLAS_TYPE_STRING = "string";
    public static final String ATLAS_TYPE_DATE = "date";
    public static final String ATLAS_TYPE_OBJECT_ID = "objectid";
    public static final String ATLAS_TYPE_ARRAY_PREFIX = "array<";
    public static final String ATLAS_TYPE_ARRAY_SUFFIX = ">";
    public static final String ATLAS_TYPE_MAP_PREFIX = "map<";
    public static final String ATLAS_TYPE_MAP_KEY_VAL_SEP = ",";
    public static final String ATLAS_TYPE_MAP_SUFFIX = ">";
    public static final String ATLAS_TYPE_PROCESS = "Process";
    public static final String ATLAS_TYPE_DATASET = "DataSet";
    public static final String ATLAS_TYPE_ASSET = "Asset";
    public static final String ATLAS_TYPE_INFRASTRUCTURE = "Infrastructure";
    public static final String TYPEDEF_OPTION_SUPPORTS_SCHEMA = "supportsSchema";
    public static final String TYPEDEF_OPTION_SUPPORTS_PROFILE = "supportsProfile";
    public static final String[] ATLAS_PRIMITIVE_TYPES = new String[]{"boolean", "byte", "short", "int", "long", "float", "double", "biginteger", "bigdecimal", "string"};
    public static final String[] ATLAS_RELATIONSHIP_ATTRIBUTE_TYPES = new String[]{"boolean", "byte", "short", "int", "long", "float", "double", "biginteger", "bigdecimal", "string", "date"};
    public static final String[] ATLAS_BUILTIN_TYPES = new String[]{"boolean", "byte", "short", "int", "long", "float", "double", "biginteger", "bigdecimal", "string", "date", "objectid"};
    public static final String SERVICE_TYPE_ATLAS_CORE = "atlas_core";
    public static final String SERIALIZED_DATE_FORMAT_STR = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    @Deprecated
    public static final DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final ThreadLocal<DateFormat> THREAD_LOCAL_DATE_FORMAT;
    private final TypeCategory category;
    private String guid = null;
    private String createdBy = null;
    private String updatedBy = null;
    private Date createTime = null;
    private Date updateTime = null;
    private Long version = null;
    private String name;
    private String description;
    private String typeVersion;
    private String serviceType;
    private Map<String, String> options;

    public static DateFormat getDateFormatter() {
        return THREAD_LOCAL_DATE_FORMAT.get();
    }

    protected AtlasBaseTypeDef(TypeCategory category, String name, String description, String typeVersion, String serviceType, Map<String, String> options) {
        this.category = category;
        this.setGuid(null);
        this.setCreatedBy(null);
        this.setUpdatedBy(null);
        this.setCreateTime(null);
        this.setUpdateTime(null);
        this.setVersion(null);
        this.setName(name);
        this.setDescription(description);
        this.setTypeVersion(typeVersion);
        this.setServiceType(serviceType);
        this.setOptions(options);
    }

    protected AtlasBaseTypeDef(AtlasBaseTypeDef other) {
        if (other != null) {
            this.category = other.category;
            this.setGuid(other.getGuid());
            this.setCreatedBy(other.getCreatedBy());
            this.setUpdatedBy(other.getUpdatedBy());
            this.setCreateTime(other.getCreateTime());
            this.setUpdateTime(other.getUpdateTime());
            this.setVersion(other.getVersion());
            this.setName(other.getName());
            this.setServiceType(other.getServiceType());
            this.setDescription(other.getDescription());
            this.setTypeVersion(other.getTypeVersion());
            this.setOptions(other.getOptions());
        } else {
            this.category = TypeCategory.PRIMITIVE;
            this.setGuid(null);
            this.setCreatedBy(null);
            this.setUpdatedBy(null);
            this.setCreateTime(null);
            this.setUpdateTime(null);
            this.setVersion(null);
            this.setName(null);
            this.setServiceType(null);
            this.setDescription(null);
            this.setTypeVersion(null);
            this.setOptions(null);
        }
    }

    public TypeCategory getCategory() {
        return this.category;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTypeVersion() {
        return this.typeVersion;
    }

    public void setTypeVersion(String typeVersion) {
        this.typeVersion = typeVersion;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options != null ? new HashMap<String, String>(options) : null;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasBaseTypeDef{");
        sb.append("category='").append((Object)this.category).append('\'');
        sb.append(", guid='").append(this.guid).append('\'');
        sb.append(", createdBy='").append(this.createdBy).append('\'');
        sb.append(", updatedBy='").append(this.updatedBy).append('\'');
        AtlasBaseTypeDef.dumpDateField(", createTime=", this.createTime, sb);
        AtlasBaseTypeDef.dumpDateField(", updateTime=", this.updateTime, sb);
        sb.append(", version=").append(this.version);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", typeVersion='").append(this.typeVersion).append('\'');
        sb.append(", serviceType='").append(this.serviceType).append('\'');
        sb.append(", options='").append(this.options).append('\'');
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtlasBaseTypeDef that = (AtlasBaseTypeDef)o;
        return this.category == that.category && Objects.equals(this.guid, that.guid) && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.updatedBy, that.updatedBy) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.updateTime, that.updateTime) && Objects.equals(this.version, that.version) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.typeVersion, that.typeVersion) && Objects.equals(this.serviceType, that.serviceType) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        int result = this.category != null ? this.category.hashCode() : 0;
        result = 31 * result + (this.guid != null ? this.guid.hashCode() : 0);
        result = 31 * result + (this.createdBy != null ? this.createdBy.hashCode() : 0);
        result = 31 * result + (this.updatedBy != null ? this.updatedBy.hashCode() : 0);
        result = 31 * result + (this.createTime != null ? this.createTime.hashCode() : 0);
        result = 31 * result + (this.updateTime != null ? this.updateTime.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.typeVersion != null ? this.typeVersion.hashCode() : 0);
        result = 31 * result + (this.serviceType != null ? this.serviceType.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }

    public static String getArrayTypeName(String elemTypeName) {
        return ATLAS_TYPE_ARRAY_PREFIX + elemTypeName + ">";
    }

    public static String getMapTypeName(String keyTypeName, String valueTypeName) {
        return String.format("%s%s%s%s%s", ATLAS_TYPE_MAP_PREFIX, keyTypeName, ATLAS_TYPE_MAP_KEY_VAL_SEP, valueTypeName, ">");
    }

    public static StringBuilder dumpObjects(Collection<?> objects, StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (CollectionUtils.isNotEmpty(objects)) {
            int i = 0;
            for (Object obj : objects) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(obj);
                ++i;
            }
        }
        return sb;
    }

    public static StringBuilder dumpObjects(Map<?, ?> objects, StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (MapUtils.isNotEmpty(objects)) {
            int i = 0;
            for (Map.Entry<?, ?> e : objects.entrySet()) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(e.getKey()).append(":").append(e.getValue());
                ++i;
            }
        }
        return sb;
    }

    public static StringBuilder dumpDateField(String prefix, Date value, StringBuilder sb) {
        sb.append(prefix);
        if (value == null) {
            sb.append(value);
        } else {
            sb.append(AtlasBaseTypeDef.getDateFormatter().format(value));
        }
        return sb;
    }

    static {
        DATE_FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
        THREAD_LOCAL_DATE_FORMAT = new ThreadLocal<DateFormat>(){

            @Override
            public DateFormat initialValue() {
                SimpleDateFormat ret = new SimpleDateFormat(AtlasBaseTypeDef.SERIALIZED_DATE_FORMAT_STR);
                ret.setTimeZone(TimeZone.getTimeZone("UTC"));
                return ret;
            }
        };
    }
}

