/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.common.metric;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.annotation.Name;
import com.datatorrent.common.metric.SingleMetricAggregator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class MetricsAggregator
implements AutoMetric.Aggregator,
Serializable {
    protected static final String DEFAULT_SEPARATOR = "-";
    protected final Map<String, List<LogicalMetricMeta>> metricLogicalAggregates = Maps.newHashMap();
    protected String aggregatorMetricSeparator = "-";
    private static final long serialVersionUID = 201604231337L;

    public Map<String, Object> aggregate(long windowId, Collection<AutoMetric.PhysicalMetricsContext> physicalMetrics) {
        ArrayListMultimap metricValues = ArrayListMultimap.create();
        for (AutoMetric.PhysicalMetricsContext pmCtx : physicalMetrics) {
            for (Map.Entry entry : pmCtx.getMetrics().entrySet()) {
                metricValues.put(entry.getKey(), entry.getValue());
            }
        }
        HashMap aggregates = Maps.newHashMap();
        for (String metric : metricValues.keySet()) {
            List<LogicalMetricMeta> logicalMetricMetas = this.metricLogicalAggregates.get(metric);
            if (logicalMetricMetas == null) continue;
            for (LogicalMetricMeta logicalMetricMeta : logicalMetricMetas) {
                Object aggregatedVal = logicalMetricMeta.aggregator.aggregate(metricValues.get((Object)metric));
                aggregates.put(logicalMetricMeta.name, aggregatedVal);
            }
        }
        return aggregates;
    }

    protected String deriveLogicalMetricName(String metric, SingleMetricAggregator aggregator) {
        Name aggregatorName = aggregator.getClass().getAnnotation(Name.class);
        String aggregatorDesc = aggregatorName == null ? aggregator.getClass().getName() : aggregatorName.value();
        return aggregatorDesc + this.aggregatorMetricSeparator + metric;
    }

    public void addAggregators(@NotNull String metric, @NotNull SingleMetricAggregator[] aggregators) {
        Preconditions.checkNotNull((Object)metric, (Object)"metric");
        Preconditions.checkNotNull((Object)aggregators, (Object)"aggregators");
        this.addAggregatorsHelper(metric, aggregators, null);
    }

    public void addAggregators(@NotNull String metric, @NotNull SingleMetricAggregator[] aggregators, @NotNull String[] logicalMetricNames) {
        Preconditions.checkNotNull((Object)metric, (Object)"metric");
        Preconditions.checkNotNull((Object)aggregators, (Object)"aggregators");
        Preconditions.checkNotNull((Object)logicalMetricNames, (Object)"logicalMetricNames");
        Preconditions.checkArgument((aggregators.length == logicalMetricNames.length ? 1 : 0) != 0, (Object)"different length aggregators and logical names");
        this.addAggregatorsHelper(metric, aggregators, logicalMetricNames);
    }

    private void addAggregatorsHelper(String metric, SingleMetricAggregator[] aggregators, String[] logicalMetricNames) {
        ArrayList laggregators = this.metricLogicalAggregates.get(metric);
        if (laggregators == null) {
            laggregators = Lists.newArrayList();
            this.metricLogicalAggregates.put(metric, laggregators);
        }
        for (int i = 0; i < aggregators.length; ++i) {
            String resultName = logicalMetricNames == null || logicalMetricNames[i] == null ? (aggregators.length == 1 ? metric : this.deriveLogicalMetricName(metric, aggregators[i])) : logicalMetricNames[i];
            laggregators.add(new LogicalMetricMeta(aggregators[i], resultName));
        }
    }

    public String getAggregatorMetricSeparator() {
        return this.aggregatorMetricSeparator;
    }

    public void setAggregatorMetricSeparator(String aggregatorMetricSeparator) {
        this.aggregatorMetricSeparator = aggregatorMetricSeparator;
    }

    public static class LogicalMetricMeta
    implements Serializable {
        private SingleMetricAggregator aggregator;
        private String name;
        private static final long serialVersionUID = 201604231340L;

        protected LogicalMetricMeta(@NotNull SingleMetricAggregator aggregator, @NotNull String name) {
            this.aggregator = (SingleMetricAggregator)Preconditions.checkNotNull((Object)aggregator, (Object)"aggregator");
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"logical metric name");
        }

        public SingleMetricAggregator getAggregator() {
            return this.aggregator;
        }

        protected void setAggregator(SingleMetricAggregator aggregator) {
            this.aggregator = aggregator;
        }

        public String getName() {
            return this.name;
        }

        protected void setName(String name) {
            this.name = name;
        }
    }
}

