/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.bufferserver.packet;

import com.datatorrent.bufferserver.packet.RequestTuple;
import com.datatorrent.bufferserver.packet.Tuple;
import com.datatorrent.bufferserver.util.Codec;
import com.datatorrent.netlet.util.VarInt;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeRequestTuple
extends RequestTuple {
    public static final String EMPTY_STRING = new String();
    private String version;
    private String identifier;
    private int baseSeconds;
    private int windowId;
    private String streamType;
    private String upstreamIdentifier;
    private int mask;
    private int[] partitions;
    private int bufferSize;
    private static final Logger logger = LoggerFactory.getLogger(SubscribeRequestTuple.class);

    @Override
    public void parse() {
        this.parsed = true;
        int dataOffset = this.offset + 1;
        int limit = this.offset + this.length;
        try {
            int idlen = this.readVarInt(dataOffset, limit);
            if (idlen > 0) {
                while (this.buffer[dataOffset++] < 0) {
                }
                this.version = new String(this.buffer, dataOffset, idlen);
                dataOffset += idlen;
            } else if (idlen == 0) {
                this.version = EMPTY_STRING;
                ++dataOffset;
            } else {
                return;
            }
            idlen = this.readVarInt(dataOffset, limit);
            if (idlen > 0) {
                while (this.buffer[dataOffset++] < 0) {
                }
                this.identifier = new String(this.buffer, dataOffset, idlen);
                dataOffset += idlen;
            } else if (idlen == 0) {
                this.identifier = EMPTY_STRING;
                ++dataOffset;
            } else {
                return;
            }
            this.baseSeconds = this.readVarInt(dataOffset, limit);
            while (this.buffer[dataOffset++] < 0) {
            }
            this.windowId = this.readVarInt(dataOffset, limit);
            while (this.buffer[dataOffset++] < 0) {
            }
            idlen = this.readVarInt(dataOffset, limit);
            if (idlen > 0) {
                while (this.buffer[dataOffset++] < 0) {
                }
                this.streamType = new String(this.buffer, dataOffset, idlen);
                dataOffset += idlen;
            } else if (idlen == 0) {
                this.streamType = EMPTY_STRING;
                ++dataOffset;
            } else {
                return;
            }
            idlen = this.readVarInt(dataOffset, limit);
            if (idlen > 0) {
                while (this.buffer[dataOffset++] < 0) {
                }
                this.upstreamIdentifier = new String(this.buffer, dataOffset, idlen);
                dataOffset += idlen;
            } else if (idlen == 0) {
                this.upstreamIdentifier = EMPTY_STRING;
                ++dataOffset;
            } else {
                return;
            }
            int count = this.readVarInt(dataOffset, limit);
            if (count > 0) {
                while (this.buffer[dataOffset++] < 0) {
                }
                this.mask = this.readVarInt(dataOffset, limit);
                if (this.mask > 0) {
                    while (this.buffer[dataOffset++] < 0) {
                    }
                } else {
                    return;
                }
                this.partitions = new int[count];
                for (int i = 0; i < count; ++i) {
                    this.partitions[i] = this.readVarInt(dataOffset, limit);
                    if (this.partitions[i] == -1) {
                        return;
                    }
                    while (this.buffer[dataOffset++] < 0) {
                    }
                }
            }
            this.bufferSize = this.readVarInt(dataOffset, limit);
            if (this.bufferSize == -1) {
                return;
            }
            while (this.buffer[dataOffset++] < 0) {
            }
            this.valid = true;
        }
        catch (NumberFormatException nfe) {
            logger.warn("Unparseable Tuple", (Throwable)nfe);
        }
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public String getStreamType() {
        return this.streamType;
    }

    public SubscribeRequestTuple(byte[] array, int offset, int length) {
        super(array, offset, length);
    }

    @Override
    public int getWindowId() {
        return this.windowId;
    }

    @Override
    public int getBaseSeconds() {
        return this.baseSeconds;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String getUpstreamIdentifier() {
        return this.upstreamIdentifier;
    }

    public int getMask() {
        return this.mask;
    }

    public int[] getPartitions() {
        return this.partitions;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public static byte[] getSerializedRequest(String version, String id, String down_type, String upstream_id, int mask, Collection<Integer> partitions, long startingWindowId, int bufferSize) {
        byte[] array = new byte[4096];
        int offset = 0;
        array[offset++] = 7;
        offset = Tuple.writeString(version == null ? "1.0" : version, array, offset);
        offset = Tuple.writeString(id, array, offset);
        int baseSeconds = (int)(startingWindowId >> 32);
        offset = VarInt.write((int)baseSeconds, (byte[])array, (int)offset);
        int windowId = (int)startingWindowId;
        offset = VarInt.write((int)windowId, (byte[])array, (int)offset);
        offset = Tuple.writeString(down_type, array, offset);
        offset = Tuple.writeString(upstream_id, array, offset);
        if (partitions == null || partitions.isEmpty()) {
            offset = VarInt.write((int)0, (byte[])array, (int)offset);
        } else {
            offset = VarInt.write((int)partitions.size(), (byte[])array, (int)offset);
            offset = VarInt.write((int)mask, (byte[])array, (int)offset);
            for (int i : partitions) {
                offset = VarInt.write((int)i, (byte[])array, (int)offset);
            }
        }
        offset = VarInt.write((int)bufferSize, (byte[])array, (int)offset);
        return Arrays.copyOfRange(array, 0, offset);
    }

    public String toString() {
        return "SubscribeRequestTuple{version=" + this.version + ", identifier=" + this.identifier + ", windowId=" + Codec.getStringWindowId((long)this.baseSeconds << 32 | (long)this.windowId) + ", type=" + this.streamType + ", upstreamIdentifier=" + this.upstreamIdentifier + ", mask=" + this.mask + ", partitions=" + (this.partitions == null ? "null" : Arrays.toString(this.partitions)) + ", bufferSize=" + this.bufferSize + '}';
    }
}

