/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.bufferserver.packet;

import com.datatorrent.bufferserver.packet.RequestTuple;
import com.datatorrent.bufferserver.util.Codec;
import com.datatorrent.netlet.util.VarInt;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRequestTuple
extends RequestTuple {
    public static final String EMPTY_STRING = new String();
    public String version;
    protected String identifier;
    protected int baseSeconds;
    protected int windowId;
    private static final Logger logger = LoggerFactory.getLogger(GenericRequestTuple.class);

    public GenericRequestTuple(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void parse() {
        this.parsed = true;
        int dataOffset = this.offset + 1;
        int limit = this.offset + this.length;
        try {
            int idlen = this.readVarInt(dataOffset, limit);
            if (idlen > 0) {
                while (this.buffer[dataOffset++] < 0) {
                }
                this.version = new String(this.buffer, dataOffset, idlen);
                dataOffset += idlen;
            } else if (idlen == 0) {
                this.version = EMPTY_STRING;
                ++dataOffset;
            } else {
                return;
            }
            idlen = this.readVarInt(dataOffset, limit);
            if (idlen > 0) {
                while (this.buffer[dataOffset++] < 0) {
                }
                this.identifier = new String(this.buffer, dataOffset, idlen);
                dataOffset += idlen;
            } else if (idlen == 0) {
                this.identifier = EMPTY_STRING;
                ++dataOffset;
            } else {
                return;
            }
            this.baseSeconds = this.readVarInt(dataOffset, limit);
            while (this.buffer[dataOffset++] < 0) {
            }
            this.windowId = this.readVarInt(dataOffset, limit);
            while (this.buffer[dataOffset++] < 0) {
            }
            this.valid = true;
        }
        catch (NumberFormatException nfe) {
            logger.warn("Unparseable Tuple", (Throwable)nfe);
        }
    }

    @Override
    public int getWindowId() {
        return this.windowId;
    }

    @Override
    public int getBaseSeconds() {
        return this.baseSeconds;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public static byte[] getSerializedRequest(String version, String identifier, long startingWindowId, byte type) {
        byte[] array = new byte[4096];
        int offset = 0;
        array[offset++] = type;
        if (version == null) {
            version = "1.0";
        }
        offset = GenericRequestTuple.writeString(version, array, offset);
        offset = GenericRequestTuple.writeString(identifier, array, offset);
        int baseSeconds = (int)(startingWindowId >> 32);
        offset = VarInt.write((int)baseSeconds, (byte[])array, (int)offset);
        int windowId = (int)startingWindowId;
        offset = VarInt.write((int)windowId, (byte[])array, (int)offset);
        return Arrays.copyOfRange(array, 0, offset);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "version=" + this.version + ", identifier=" + this.identifier + ", windowId=" + Codec.getStringWindowId((long)this.baseSeconds << 32 | (long)this.windowId) + '}';
    }
}

