/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.api;

import com.datatorrent.api.Context;
import com.datatorrent.api.Operator;
import com.datatorrent.api.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOutputPort<T>
implements Operator.OutputPort<T> {
    public static final String THREAD_AFFINITY_DISABLE_CHECK = "com.datatorrent.api.DefaultOutputPort.thread.check.disable";
    private static final Logger logger = LoggerFactory.getLogger(DefaultOutputPort.class);
    private transient Sink<Object> sink = Sink.BLACKHOLE;
    private transient Thread operatorThread;

    public void emit(T tuple) {
        if (this.operatorThread != null && Thread.currentThread() != this.operatorThread) {
            throw new IllegalStateException("Current thread " + Thread.currentThread().getName() + " is different from the operator thread " + this.operatorThread.getName());
        }
        this.sink.put(tuple);
    }

    @Override
    public final void setSink(Sink<Object> s) {
        this.sink = s == null ? Sink.BLACKHOLE : s;
    }

    public boolean isConnected() {
        return this.sink != Sink.BLACKHOLE;
    }

    @Override
    public Operator.Unifier<T> getUnifier() {
        return null;
    }

    @Override
    public void setup(Context.PortContext context) {
        if (!Boolean.getBoolean(THREAD_AFFINITY_DISABLE_CHECK)) {
            this.operatorThread = Thread.currentThread();
            logger.debug("Enforcing emit on {}", (Object)this.operatorThread.getName());
        }
    }

    @Override
    public void teardown() {
    }
}

