/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.api;

import com.datatorrent.api.Context;
import com.datatorrent.api.StringCodec;
import com.google.common.base.Throwables;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Attribute<T>
implements Serializable {
    public final T defaultValue;
    public final String name;
    public final StringCodec<T> codec;
    private static final long serialVersionUID = 201310111904L;

    public Attribute(StringCodec<T> codec) {
        this(null, null, codec);
    }

    public Attribute(T defaultValue) {
        this(null, defaultValue, null);
    }

    public Attribute(T defaultValue, StringCodec<T> codec) {
        this(null, defaultValue, codec);
    }

    private Attribute(String name, T defaultValue, StringCodec<T> codec) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.codec = codec;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj;
        return !(this.name != null ? !this.name.equals(other.name) : other.name != null);
    }

    public String getName() {
        return "attr" + this.name.substring(this.name.lastIndexOf(46));
    }

    public String getSimpleName() {
        return this.name.substring(this.name.lastIndexOf(46) + 1);
    }

    public String toString() {
        return "Attribute{defaultValue=" + this.defaultValue + ", name=" + this.name + ", codec=" + this.codec + '}';
    }

    public static interface AttributeMap
    extends Cloneable {
        public <T> T get(Attribute<T> var1);

        public boolean contains(Attribute<?> var1);

        public <T> T put(Attribute<T> var1, T var2);

        public Set<Map.Entry<Attribute<?>, Object>> entrySet();

        public AttributeMap clone() throws CloneNotSupportedException;

        public static class AttributeInitializer {
            static final HashMap<Class<?>, Set<Attribute<Object>>> map = new HashMap();

            public static Map<Attribute<Object>, Object> getAllAttributes(Context context, Class<?> clazz) {
                HashMap<Attribute<Object>, Object> result = new HashMap<Attribute<Object>, Object>();
                try {
                    for (Field f : clazz.getDeclaredFields()) {
                        if (!Modifier.isStatic(f.getModifiers()) || !Attribute.class.isAssignableFrom(f.getType())) continue;
                        Attribute attribute = (Attribute)f.get(null);
                        result.put(attribute, context.getValue(attribute));
                    }
                }
                catch (Exception ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
                return result;
            }

            public static Set<Attribute<Object>> getAttributes(Class<?> clazz) {
                return map.get(clazz);
            }

            public static long initialize(Class<?> clazz) {
                if (map.containsKey(clazz)) {
                    return 0L;
                }
                HashSet<Attribute> set = new HashSet<Attribute>();
                try {
                    for (Field f : clazz.getDeclaredFields()) {
                        if (!Modifier.isStatic(f.getModifiers()) || !Attribute.class.isAssignableFrom(f.getType())) continue;
                        Attribute attribute = (Attribute)f.get(null);
                        if (attribute.name == null) {
                            Field nameField = Attribute.class.getDeclaredField("name");
                            nameField.setAccessible(true);
                            nameField.set(attribute, clazz.getCanonicalName() + '.' + f.getName());
                            nameField.setAccessible(false);
                        }
                        if (attribute.codec == null) {
                            StringCodec<String> codec = null;
                            if (attribute.defaultValue != null) {
                                Class<?> klass = attribute.defaultValue.getClass();
                                if (klass == String.class) {
                                    codec = new StringCodec.String2String();
                                } else if (klass == Integer.class) {
                                    codec = new StringCodec.Integer2String();
                                } else if (klass == Long.class) {
                                    codec = new StringCodec.Long2String();
                                } else if (klass == Boolean.class) {
                                    codec = new StringCodec.Boolean2String();
                                } else if (Enum.class.isAssignableFrom(klass)) {
                                    codec = new StringCodec.Enum2String(klass);
                                }
                            }
                            if (codec != null) {
                                Field codecField = Attribute.class.getDeclaredField("codec");
                                codecField.setAccessible(true);
                                codecField.set(attribute, codec);
                                codecField.setAccessible(false);
                            }
                        }
                        set.add(attribute);
                    }
                }
                catch (Exception ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
                map.put(clazz, set);
                return (long)clazz.getModifiers() << 32 | (long)clazz.hashCode();
            }
        }

        public static class DefaultAttributeMap
        implements AttributeMap,
        Serializable {
            private HashMap<Attribute<?>, Object> map;
            private static final long serialVersionUID = 201306051022L;

            public DefaultAttributeMap() {
                this(new HashMap());
            }

            private DefaultAttributeMap(HashMap<Attribute<?>, Object> map) {
                this.map = map;
            }

            @Override
            public <T> T get(Attribute<T> key) {
                return (T)this.map.get(key);
            }

            public String toString() {
                return this.map.toString();
            }

            @Override
            public DefaultAttributeMap clone() throws CloneNotSupportedException {
                DefaultAttributeMap clone = (DefaultAttributeMap)super.clone();
                clone.map = (HashMap)this.map.clone();
                return clone;
            }

            @Override
            public <T> T put(Attribute<T> key, T value) {
                return (T)this.map.put(key, value);
            }

            @Override
            public Set<Map.Entry<Attribute<?>, Object>> entrySet() {
                return this.map.entrySet();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof DefaultAttributeMap)) {
                    return false;
                }
                DefaultAttributeMap that = (DefaultAttributeMap)o;
                return !(this.map == null ? that.map != null : !this.map.equals(that.map));
            }

            public int hashCode() {
                return this.map != null ? this.map.hashCode() : 0;
            }

            @Override
            public boolean contains(Attribute<?> key) {
                return this.map.containsKey(key);
            }
        }
    }
}

