/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.configuration;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.any23.configuration.Setting;

public final class Settings
extends AbstractSet<Setting<?>> {
    private static final Settings EMPTY_SETTINGS = new Settings(Collections.emptyMap());
    private final Map<String, Setting<?>> values;
    private static final float loadFactor = 0.75f;

    private Settings(Map<String, Setting<?>> values) {
        this.values = values;
    }

    public Optional<Setting<?>> find(String identifier) {
        return Optional.ofNullable(this.values.get(identifier));
    }

    public <S extends Setting<?>> Optional<S> find(S setting) {
        Setting<?> found = this.values.get(setting.getIdentifier());
        return found == null ? Optional.empty() : found.as(setting);
    }

    public <E> E get(Setting<E> defaultSetting) {
        return this.find(defaultSetting).orElse(defaultSetting).getValue();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Setting)) {
            return false;
        }
        return o.equals(this.values.get(((Setting)o).getIdentifier()));
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Iterator<Setting<?>> iterator() {
        return this.values.values().iterator();
    }

    public static Settings of() {
        return EMPTY_SETTINGS;
    }

    public static Settings of(Setting<?> s) {
        return new Settings(Collections.singletonMap(s.getIdentifier(), s));
    }

    public static Settings of(Setting<?> ... settings) {
        Map<String, Setting<?>> map = Settings.mapForSize(settings.length);
        for (Setting<?> s : settings) {
            Settings.put(map, s);
        }
        return Settings.ofModifiable(map);
    }

    public static Settings of(Collection<? extends Setting<?>> c) {
        if (c instanceof Settings) {
            return (Settings)c;
        }
        int size = c.size();
        if (size == 0) {
            return EMPTY_SETTINGS;
        }
        Map<String, Setting<?>> map = Settings.mapForSize(size);
        for (Setting<?> s : c) {
            Settings.put(map, s);
        }
        return Settings.ofModifiable(map);
    }

    private static Settings ofModifiable(Map<String, Setting<?>> map) {
        return new Settings(Collections.unmodifiableMap(map));
    }

    private static void put(Map<String, Setting<?>> map, Setting<?> setting) {
        Setting<?> existing = map.put(setting.getIdentifier(), setting);
        if (existing != null) {
            throw new IllegalArgumentException(setting.getIdentifier() + " is already defined");
        }
    }

    private static Map<String, Setting<?>> mapForSize(int size) {
        return new HashMap((int)((float)size / 0.75f) + 1, 0.75f);
    }
}

