/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.relocated.commons.io.IOUtils;
import org.apache.hadoop.metrics2.sink.relocated.commons.lang.StringUtils;
import org.apache.hadoop.metrics2.sink.relocated.google.common.base.Supplier;
import org.apache.hadoop.metrics2.sink.relocated.google.common.base.Suppliers;
import org.apache.hadoop.metrics2.sink.relocated.google.common.reflect.TypeToken;
import org.apache.hadoop.metrics2.sink.relocated.google.gson.Gson;
import org.apache.hadoop.metrics2.sink.relocated.google.gson.JsonSyntaxException;
import org.apache.hadoop.metrics2.sink.timeline.AppCookieManager;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.apache.hadoop.metrics2.sink.timeline.UnableToConnectException;
import org.apache.hadoop.metrics2.sink.timeline.availability.MetricCollectorHAHelper;
import org.apache.hadoop.metrics2.sink.timeline.availability.MetricCollectorUnavailableException;
import org.apache.hadoop.metrics2.sink.timeline.availability.MetricSinkWriteShardHostnameHashingStrategy;
import org.apache.hadoop.metrics2.sink.timeline.availability.MetricSinkWriteShardStrategy;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public abstract class AbstractTimelineMetricsSink {
    public static final String TAGS_FOR_PREFIX_PROPERTY_PREFIX = "tagsForPrefix.";
    public static final String MAX_METRIC_ROW_CACHE_SIZE = "maxRowCacheSize";
    public static final String METRICS_SEND_INTERVAL = "sendInterval";
    public static final String METRICS_POST_TIMEOUT_SECONDS = "timeout";
    public static final String COLLECTOR_HOSTS_PROPERTY = "collector.hosts";
    public static final String COLLECTOR_PROTOCOL = "protocol";
    public static final String COLLECTOR_PORT = "port";
    public static final String ZOOKEEPER_QUORUM = "zookeeper.quorum";
    public static final String COLLECTOR_ZOOKEEPER_QUORUM = "metrics.zookeeper.quorum";
    public static final int DEFAULT_POST_TIMEOUT_SECONDS = 10;
    public static final String SKIP_COUNTER_TRANSFROMATION = "skipCounterDerivative";
    public static final String RPC_METRIC_PREFIX = "metric.rpc";
    public static final String WS_V1_TIMELINE_METRICS = "/ws/v1/timeline/metrics";
    public static final String SSL_KEYSTORE_PATH_PROPERTY = "truststore.path";
    public static final String SSL_KEYSTORE_TYPE_PROPERTY = "truststore.type";
    public static final String SSL_KEYSTORE_PASSWORD_PROPERTY = "truststore.password";
    public static final String COLLECTOR_LIVE_NODES_PATH = "/ws/v1/timeline/metrics/livenodes";
    public static final String INSTANCE_ID_PROPERTY = "instanceId";
    public static final String SET_INSTANCE_ID_PROPERTY = "set.instanceId";
    public static final String COOKIE = "Cookie";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String NEGOTIATE = "Negotiate";
    protected static final AtomicInteger failedCollectorConnectionsCounter = new AtomicInteger(0);
    public static int NUMBER_OF_SKIPPED_COLLECTOR_EXCEPTIONS = 100;
    protected static final AtomicInteger nullCollectorCounter = new AtomicInteger(0);
    public static int NUMBER_OF_NULL_COLLECTOR_EXCEPTIONS = 20;
    public int ZK_CONNECT_TRY_COUNT = 10;
    public int ZK_SLEEP_BETWEEN_RETRY_TIME = 2000;
    public boolean shardExpired = true;
    private int zookeeperMinBackoffTimeMins = 2;
    private int zookeeperMaxBackoffTimeMins = 5;
    private long zookeeperBackoffTimeMillis;
    private long lastFailedZkRequestTime = 0L;
    private SSLSocketFactory sslSocketFactory;
    private AppCookieManager appCookieManager = null;
    protected final Log LOG;
    protected static ObjectMapper mapper = new ObjectMapper();
    protected MetricCollectorHAHelper collectorHAHelper;
    protected MetricSinkWriteShardStrategy metricSinkWriteShardStrategy;
    protected Supplier<String> targetCollectorHostSupplier;
    protected final SortedSet<String> allKnownLiveCollectors = new TreeSet<String>();
    private volatile boolean isInitializedForHA = false;
    private final int RETRY_COUNT_BEFORE_COLLECTOR_FAILOVER = 5;
    private final Gson gson = new Gson();
    private final Random rand = new Random();
    private static final int COLLECTOR_HOST_CACHE_MAX_EXPIRATION_MINUTES = 75;
    private static final int COLLECTOR_HOST_CACHE_MIN_EXPIRATION_MINUTES = 60;

    public AbstractTimelineMetricsSink() {
        this.LOG = LogFactory.getLog(this.getClass());
    }

    protected void init() {
        this.metricSinkWriteShardStrategy = new MetricSinkWriteShardHostnameHashingStrategy(this.getHostname());
        this.collectorHAHelper = new MetricCollectorHAHelper(this.getZookeeperQuorum(), this.ZK_CONNECT_TRY_COUNT, this.ZK_SLEEP_BETWEEN_RETRY_TIME);
        this.zookeeperBackoffTimeMillis = this.getZookeeperBackoffTimeMillis();
        this.isInitializedForHA = true;
    }

    protected boolean emitMetricsJson(String connectUrl, String jsonData) {
        int timeout = this.getTimeoutSeconds() * 1000;
        HttpURLConnection connection = null;
        try {
            int statusCode;
            AppCookieManager appCookieManager;
            String appCookie;
            if (connectUrl == null) {
                throw new IOException("Unknown URL. Unable to connect to metrics collector.");
            }
            HttpURLConnection httpURLConnection = connection = connectUrl.startsWith("https") ? this.getSSLConnection(connectUrl) : this.getConnection(connectUrl);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("emitMetricsJson to " + connectUrl + ", " + jsonData);
            }
            if ((appCookie = (appCookieManager = this.getAppCookieManager()).getCachedAppCookie(connectUrl)) != null) {
                if (this.LOG.isInfoEnabled()) {
                    this.LOG.info("Using cached app cookie for URL:" + connectUrl);
                }
                connection.setRequestProperty(COOKIE, appCookie);
            }
            if ((statusCode = this.emitMetricsJson(connection, timeout, jsonData)) == 401) {
                String wwwAuthHeader = connection.getHeaderField(WWW_AUTHENTICATE);
                if (this.LOG.isInfoEnabled()) {
                    this.LOG.info("Received WWW-Authentication header:" + wwwAuthHeader + ", for URL:" + connectUrl);
                }
                if (wwwAuthHeader != null && wwwAuthHeader.trim().startsWith(NEGOTIATE)) {
                    appCookie = appCookieManager.getAppCookie(connectUrl, true);
                    if (appCookie != null) {
                        this.cleanupInputStream(connection.getInputStream());
                        connection = connectUrl.startsWith("https") ? this.getSSLConnection(connectUrl) : this.getConnection(connectUrl);
                        connection.setRequestProperty(COOKIE, appCookie);
                        statusCode = this.emitMetricsJson(connection, timeout, jsonData);
                    }
                } else {
                    this.LOG.error("Unsupported WWW-Authentication header:" + wwwAuthHeader + ", for URL:" + connectUrl);
                }
            }
            if (statusCode != 200) {
                this.LOG.info("Unable to POST metrics to collector, " + connectUrl + ", " + "statusCode = " + statusCode);
            } else if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Metrics posted to Collector " + connectUrl);
            }
            this.cleanupInputStream(connection.getInputStream());
            failedCollectorConnectionsCounter.set(0);
            return true;
        }
        catch (IOException ioe) {
            StringBuilder errorMessage = new StringBuilder("Unable to connect to collector, " + connectUrl + "\n" + "This exceptions will be ignored for next " + NUMBER_OF_SKIPPED_COLLECTOR_EXCEPTIONS + " times\n");
            try {
                if (connection != null) {
                    errorMessage.append(this.cleanupInputStream(connection.getErrorStream()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (failedCollectorConnectionsCounter.getAndIncrement() == 0) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug(errorMessage, ioe);
                } else {
                    this.LOG.info(errorMessage);
                }
                throw new UnableToConnectException(ioe).setConnectUrl(connectUrl);
            }
            failedCollectorConnectionsCounter.compareAndSet(NUMBER_OF_SKIPPED_COLLECTOR_EXCEPTIONS, 0);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug(String.format("Ignoring %s AMS connection exceptions", NUMBER_OF_SKIPPED_COLLECTOR_EXCEPTIONS));
            }
            return false;
        }
    }

    private int emitMetricsJson(HttpURLConnection connection, int timeout, String jsonData) throws IOException {
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        connection.setDoOutput(true);
        if (jsonData != null) {
            try (OutputStream os = connection.getOutputStream();){
                os.write(jsonData.getBytes("UTF-8"));
            }
        }
        int statusCode = connection.getResponseCode();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("emitMetricsJson: statusCode = " + statusCode);
        }
        return statusCode;
    }

    protected String getCurrentCollectorHost() {
        String collectorHost;
        if (this.targetCollectorHostSupplier != null) {
            collectorHost = this.targetCollectorHostSupplier.get();
            if (failedCollectorConnectionsCounter.get() > 5) {
                this.LOG.debug("Removing collector " + collectorHost + " from allKnownLiveCollectors.");
                this.allKnownLiveCollectors.remove(collectorHost);
                this.targetCollectorHostSupplier = null;
                collectorHost = this.findPreferredCollectHost();
            }
        } else {
            collectorHost = this.findPreferredCollectHost();
        }
        if (collectorHost == null) {
            if (nullCollectorCounter.getAndIncrement() == 0) {
                this.LOG.info("No live collector to send metrics to. Metrics to be sent will be discarded. This message will be skipped for the next " + NUMBER_OF_NULL_COLLECTOR_EXCEPTIONS + " times.");
            } else {
                nullCollectorCounter.compareAndSet(NUMBER_OF_NULL_COLLECTOR_EXCEPTIONS, 0);
            }
        } else {
            nullCollectorCounter.set(0);
        }
        return collectorHost;
    }

    protected boolean emitMetrics(TimelineMetrics metrics) {
        String collectorHost = this.getCurrentCollectorHost();
        if (collectorHost != null) {
            String connectUrl = this.getCollectorUri(collectorHost);
            String jsonData = null;
            this.LOG.debug("EmitMetrics connectUrl = " + connectUrl);
            try {
                jsonData = mapper.writeValueAsString(metrics);
            }
            catch (IOException e) {
                this.LOG.error("Unable to parse metrics", e);
            }
            if (jsonData != null) {
                return this.emitMetricsJson(connectUrl, jsonData);
            }
        }
        return false;
    }

    public synchronized AppCookieManager getAppCookieManager() {
        if (this.appCookieManager == null) {
            this.appCookieManager = new AppCookieManager();
        }
        return this.appCookieManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String cleanupInputStream(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (is != null) {
            try (InputStreamReader isr = new InputStreamReader(is);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    if (!this.LOG.isDebugEnabled()) continue;
                    sb.append(line);
                }
            }
            finally {
                is.close();
            }
        }
        return sb.toString();
    }

    protected HttpURLConnection getConnection(String spec) throws IOException {
        return (HttpURLConnection)new URL(spec).openConnection();
    }

    protected HttpsURLConnection getSSLConnection(String spec) throws IOException, IllegalStateException {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(spec).openConnection();
        connection.setSSLSocketFactory(this.sslSocketFactory);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadTruststore(String trustStorePath, String trustStoreType, String trustStorePassword) {
        if (this.sslSocketFactory == null) {
            if (trustStorePath == null || trustStorePassword == null) {
                String msg = "Can't load TrustStore. Truststore path or password is not set.";
                this.LOG.error(msg);
                throw new IllegalStateException(msg);
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(new File(trustStorePath));
                KeyStore store = KeyStore.getInstance(trustStoreType == null ? KeyStore.getDefaultType() : trustStoreType);
                store.load(in, trustStorePassword.toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(store);
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, tmf.getTrustManagers(), null);
                this.sslSocketFactory = context.getSocketFactory();
            }
            catch (Exception e) {
                this.LOG.error("Unable to load TrustStore", e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.LOG.error("Unable to load TrustStore", e);
                    }
                }
            }
        }
    }

    protected synchronized String findPreferredCollectHost() {
        String targetCollector;
        if (!this.isInitializedForHA) {
            this.init();
        }
        this.shardExpired = false;
        if (this.targetCollectorHostSupplier != null && (targetCollector = this.targetCollectorHostSupplier.get()) != null) {
            return targetCollector;
        }
        Collection<String> collectorHosts = this.getConfiguredCollectorHosts();
        this.refreshCollectorsFromConfigured(collectorHosts);
        long currentTime = System.currentTimeMillis();
        if (this.allKnownLiveCollectors.size() == 0 && this.getZookeeperQuorum() != null && currentTime - this.lastFailedZkRequestTime > this.zookeeperBackoffTimeMillis) {
            this.LOG.debug("No live collectors from configuration. Requesting zookeeper...");
            this.allKnownLiveCollectors.addAll(this.collectorHAHelper.findLiveCollectorHostsFromZNode());
            boolean noNewCollectorFromZk = true;
            for (String collectorHostFromZk : this.allKnownLiveCollectors) {
                if (collectorHosts.contains(collectorHostFromZk)) continue;
                noNewCollectorFromZk = false;
                break;
            }
            if (noNewCollectorFromZk) {
                this.LOG.debug("No new collector was found from Zookeeper. Will not request zookeeper for " + this.zookeeperBackoffTimeMillis + " millis");
                this.lastFailedZkRequestTime = System.currentTimeMillis();
            }
        }
        if (this.allKnownLiveCollectors.size() != 0) {
            this.targetCollectorHostSupplier = Suppliers.memoizeWithExpiration(new Supplier<String>(){

                @Override
                public String get() {
                    if (AbstractTimelineMetricsSink.this.shardExpired) {
                        AbstractTimelineMetricsSink.this.refreshCollectorsFromConfigured(AbstractTimelineMetricsSink.this.getConfiguredCollectorHosts());
                    }
                    return AbstractTimelineMetricsSink.this.metricSinkWriteShardStrategy.findCollectorShard(new ArrayList<String>(AbstractTimelineMetricsSink.this.allKnownLiveCollectors));
                }
            }, this.rand.nextInt(16) + 60, TimeUnit.MINUTES);
            String collectorHost = this.targetCollectorHostSupplier.get();
            this.shardExpired = true;
            return collectorHost;
        }
        this.LOG.debug("Couldn't find any live collectors. Returning null");
        this.shardExpired = true;
        return null;
    }

    private void refreshCollectorsFromConfigured(Collection<String> collectorHosts) {
        this.LOG.debug("Trying to find live collector host from : " + collectorHosts);
        if (collectorHosts != null && !collectorHosts.isEmpty()) {
            for (String hostStr : collectorHosts) {
                if ((hostStr = hostStr.trim()).isEmpty()) continue;
                try {
                    Collection<String> liveHosts = this.findLiveCollectorHostsFromKnownCollector(hostStr, this.getCollectorPort());
                    for (String host : liveHosts) {
                        this.allKnownLiveCollectors.add(host);
                    }
                    break;
                }
                catch (MetricCollectorUnavailableException e) {
                    this.LOG.debug("Collector " + hostStr + " is not longer live. Removing " + "it from list of know live collector hosts : " + this.allKnownLiveCollectors);
                    this.allKnownLiveCollectors.remove(hostStr);
                }
            }
        }
    }

    Collection<String> findLiveCollectorHostsFromKnownCollector(String host, String port) throws MetricCollectorUnavailableException {
        List<String> collectors;
        block19: {
            collectors = new ArrayList<String>();
            HttpURLConnection connection = null;
            StringBuilder sb = new StringBuilder(this.getCollectorProtocol());
            sb.append("://");
            sb.append(host);
            sb.append(":");
            sb.append(port);
            sb.append(COLLECTOR_LIVE_NODES_PATH);
            String connectUrl = sb.toString();
            this.LOG.debug("Requesting live collector nodes : " + connectUrl);
            try {
                connection = this.getCollectorProtocol().startsWith("https") ? this.getSSLConnection(connectUrl) : this.getConnection(connectUrl);
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(3000);
                connection.setReadTimeout(2000);
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) break block19;
                try (InputStream in = connection.getInputStream();){
                    StringWriter writer = new StringWriter();
                    IOUtils.copy(in, (Writer)writer);
                    try {
                        collectors = (List)this.gson.fromJson(writer.toString(), new TypeToken<List<String>>(){}.getType());
                    }
                    catch (JsonSyntaxException jse) {
                        this.LOG.debug("Exception deserializing the json data on live collector nodes.", jse);
                    }
                }
            }
            catch (IOException ioe) {
                StringBuilder errorMessage = new StringBuilder("Unable to connect to collector, " + connectUrl);
                try {
                    if (connection != null) {
                        errorMessage.append(this.cleanupInputStream(connection.getErrorStream()));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.LOG.debug(errorMessage);
                this.LOG.debug(ioe);
                String warnMsg = "Unable to connect to collector to find live nodes.";
                throw new MetricCollectorUnavailableException(warnMsg);
            }
        }
        return collectors;
    }

    protected String constructTimelineMetricUri(String protocol, String host, String port) {
        StringBuilder sb = new StringBuilder(protocol);
        sb.append("://");
        sb.append(host);
        sb.append(":");
        sb.append(port);
        sb.append(WS_V1_TIMELINE_METRICS);
        return sb.toString();
    }

    public Collection<String> parseHostsStringIntoCollection(String hostsString) {
        HashSet<String> hosts = new HashSet<String>();
        if (StringUtils.isEmpty(hostsString)) {
            this.LOG.error("No Metric collector configured.");
            return hosts;
        }
        for (String host : hostsString.split(",")) {
            if (StringUtils.isEmpty(host)) continue;
            hosts.add(host.trim());
        }
        return hosts;
    }

    private long getZookeeperBackoffTimeMillis() {
        return (long)((this.zookeeperMinBackoffTimeMins + this.rand.nextInt(this.zookeeperMaxBackoffTimeMins - this.zookeeperMinBackoffTimeMins + 1)) * 60) * 1000L;
    }

    protected abstract String getCollectorUri(String var1);

    protected abstract String getCollectorProtocol();

    protected abstract String getCollectorPort();

    protected abstract int getTimeoutSeconds();

    protected abstract String getZookeeperQuorum();

    protected abstract Collection<String> getConfiguredCollectorHosts();

    protected abstract String getHostname();

    static {
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        mapper.setAnnotationIntrospector(introspector);
        mapper.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }
}

