/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.relocated.apache.http.client.protocol;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.Header;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HeaderIterator;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HttpException;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HttpResponse;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HttpResponseInterceptor;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.annotation.Immutable;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.client.CookieStore;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.cookie.Cookie;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.cookie.CookieOrigin;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.cookie.CookieSpec;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.cookie.MalformedCookieException;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.protocol.HttpContext;

@Immutable
public class ResponseProcessCookies
implements HttpResponseInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        CookieSpec cookieSpec = (CookieSpec)context.getAttribute("http.cookie-spec");
        if (cookieSpec == null) {
            this.log.debug("Cookie spec not specified in HTTP context");
            return;
        }
        CookieStore cookieStore = (CookieStore)context.getAttribute("http.cookie-store");
        if (cookieStore == null) {
            this.log.debug("Cookie store not specified in HTTP context");
            return;
        }
        CookieOrigin cookieOrigin = (CookieOrigin)context.getAttribute("http.cookie-origin");
        if (cookieOrigin == null) {
            this.log.debug("Cookie origin not specified in HTTP context");
            return;
        }
        HeaderIterator it = response.headerIterator("Set-Cookie");
        this.processCookies(it, cookieSpec, cookieOrigin, cookieStore);
        if (cookieSpec.getVersion() > 0) {
            it = response.headerIterator("Set-Cookie2");
            this.processCookies(it, cookieSpec, cookieOrigin, cookieStore);
        }
    }

    private void processCookies(HeaderIterator iterator, CookieSpec cookieSpec, CookieOrigin cookieOrigin, CookieStore cookieStore) {
        while (iterator.hasNext()) {
            Header header = iterator.nextHeader();
            try {
                List<Cookie> cookies = cookieSpec.parse(header, cookieOrigin);
                for (Cookie cookie : cookies) {
                    try {
                        cookieSpec.validate(cookie, cookieOrigin);
                        cookieStore.addCookie(cookie);
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Cookie accepted: \"" + cookie + "\". ");
                    }
                    catch (MalformedCookieException ex) {
                        if (!this.log.isWarnEnabled()) continue;
                        this.log.warn("Cookie rejected: \"" + cookie + "\". " + ex.getMessage());
                    }
                }
            }
            catch (MalformedCookieException ex) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn("Invalid cookie header: \"" + header + "\". " + ex.getMessage());
            }
        }
    }
}

