/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.net.URL;
import java.util.Properties;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;

public final class ClassloadingUtil {
    private static final Logger logger = Logger.getLogger(ClassloadingUtil.class);
    private static final String INSTANTIATION_EXCEPTION_MESSAGE = "Your class must have a constructor without arguments. If it is an inner class, it must be static!";

    public static Object newInstanceFromClassLoader(String className) {
        ClassLoader loader = ClassloadingUtil.class.getClassLoader();
        try {
            Class<?> clazz = loader.loadClass(className);
            return clazz.newInstance();
        }
        catch (Throwable t) {
            if (t instanceof InstantiationException) {
                System.out.println(INSTANTIATION_EXCEPTION_MESSAGE);
            }
            if ((loader = Thread.currentThread().getContextClassLoader()) == null) {
                throw new RuntimeException("No local context classloader", t);
            }
            try {
                return loader.loadClass(className).newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Your class must have a constructor without arguments. If it is an inner class, it must be static! " + className, e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Object newInstanceFromClassLoader(String className, Object ... objs) {
        ClassLoader loader = ClassloadingUtil.class.getClassLoader();
        try {
            Class[] parametersType = new Class[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                parametersType[i] = objs[i].getClass();
            }
            Class<?> clazz = loader.loadClass(className);
            return clazz.getConstructor(parametersType).newInstance(objs);
        }
        catch (Throwable t) {
            if (t instanceof InstantiationException) {
                System.out.println(INSTANTIATION_EXCEPTION_MESSAGE);
            }
            if ((loader = Thread.currentThread().getContextClassLoader()) == null) {
                throw new RuntimeException("No local context classloader", t);
            }
            try {
                return loader.loadClass(className).newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Your class must have a constructor without arguments. If it is an inner class, it must be static! " + className, e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static URL findResource(String resourceName) {
        return ClassloadingUtil.findResource(ClassloadingUtil.class.getClassLoader(), resourceName);
    }

    public static URL findResource(ClassLoader loader, String resourceName) {
        try {
            URL resource = loader.getResource(resourceName);
            if (resource != null) {
                return resource;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            return null;
        }
        return loader.getResource(resourceName);
    }

    public static String loadProperty(ClassLoader loader, String propertiesFile, String name) {
        Properties properties = ClassloadingUtil.loadProperties(loader, propertiesFile);
        return (String)properties.get(name);
    }

    public static Properties loadProperties(ClassLoader loader, String propertiesFile) {
        Properties properties = new Properties();
        try {
            URL url = ClassloadingUtil.findResource(loader, propertiesFile);
            if (url != null) {
                properties.load(url.openStream());
            }
        }
        catch (Throwable ignored) {
            logger.warn(ignored);
        }
        return properties;
    }
}

