/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.stack;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.PhysicalAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class IpAddress
implements PhysicalAddress {
    private static final long serialVersionUID = -1818672332115113291L;
    private InetAddress ip_addr;
    private int port;
    static boolean resolve_dns;

    public IpAddress() {
    }

    public IpAddress(String addr_port) throws Exception {
        int index = addr_port.lastIndexOf(58);
        if (index == -1) {
            this.ip_addr = InetAddress.getByName(addr_port);
        } else {
            this.ip_addr = InetAddress.getByName(addr_port.substring(0, index));
            this.port = Integer.valueOf(addr_port.substring(index + 1));
        }
    }

    public IpAddress(String i, int p) throws UnknownHostException {
        this.port = p;
        this.ip_addr = InetAddress.getByName(i);
    }

    public IpAddress(InetAddress i, int p) {
        this.ip_addr = i;
        this.port = p;
        if (this.ip_addr == null) {
            this.setAddressToLocalHost();
        }
    }

    private void setAddressToLocalHost() {
        try {
            this.ip_addr = InetAddress.getLocalHost();
        }
        catch (Exception e) {
            this.ip_addr = null;
        }
        if (this.ip_addr == null) {
            try {
                this.ip_addr = InetAddress.getByName(null);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public IpAddress(int port) {
        this(port, true);
    }

    public IpAddress(int port, boolean set_default_host) {
        this.port = port;
        if (set_default_host) {
            this.setAddressToLocalHost();
        }
    }

    public IpAddress(InetSocketAddress sock_addr) {
        this.port = sock_addr.getPort();
        this.ip_addr = sock_addr.getAddress();
    }

    public final InetAddress getIpAddress() {
        return this.ip_addr;
    }

    public final int getPort() {
        return this.port;
    }

    @Override
    public final int compareTo(Address o) {
        int rc;
        int h2;
        if (this == o) {
            return 0;
        }
        if (!(o instanceof IpAddress)) {
            throw new ClassCastException("comparison between different classes: the other object is " + (o != null ? o.getClass() : o));
        }
        IpAddress other = (IpAddress)o;
        if (this.ip_addr == null) {
            if (other.ip_addr == null) {
                return this.port < other.port ? -1 : (this.port > other.port ? 1 : 0);
            }
            return -1;
        }
        int h1 = this.ip_addr.hashCode();
        int n = h1 < (h2 = other.ip_addr.hashCode()) ? -1 : (rc = h1 > h2 ? 1 : 0);
        return rc != 0 ? rc : (this.port < other.port ? -1 : (this.port > other.port ? 1 : 0));
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IpAddress)) {
            return false;
        }
        IpAddress other = (IpAddress)obj;
        boolean sameIP = this.ip_addr != null ? this.ip_addr.equals(other.ip_addr) : other.ip_addr == null;
        return sameIP && this.port == other.port;
    }

    public final int hashCode() {
        return this.ip_addr != null ? this.ip_addr.hashCode() + this.port : this.port;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.ip_addr == null) {
            sb.append("<null>");
        } else if (this.ip_addr.isMulticastAddress()) {
            sb.append(this.ip_addr.getHostAddress());
        } else {
            String host_name = resolve_dns ? this.ip_addr.getHostName() : this.ip_addr.getHostAddress();
            sb.append(host_name);
        }
        sb.append(":").append(this.port);
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.readFrom(in);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            this.writeTo(out);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        if (this.ip_addr != null) {
            byte[] address = this.ip_addr.getAddress();
            out.writeByte(address.length);
            out.write(address, 0, address.length);
            if (this.ip_addr instanceof Inet6Address) {
                out.writeInt(((Inet6Address)this.ip_addr).getScopeId());
            }
        } else {
            out.writeByte(0);
        }
        out.writeShort(this.port);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        byte len = in.readByte();
        if (len > 0 && len != 4 && len != 16) {
            throw new IOException("length has to be 4 or 16 bytes (was " + len + " bytes)");
        }
        byte[] a = new byte[len];
        in.readFully(a);
        if (len == 16) {
            int scope_id = in.readInt();
            this.ip_addr = Inet6Address.getByAddress(null, a, scope_id);
        } else {
            this.ip_addr = InetAddress.getByAddress(a);
        }
        this.port = in.readUnsignedShort();
    }

    @Override
    public int size() {
        int tmp_size = 3;
        if (this.ip_addr != null) {
            tmp_size += this.ip_addr instanceof Inet4Address ? 4 : 20;
        }
        return tmp_size;
    }

    public IpAddress copy() {
        return new IpAddress(this.ip_addr, this.port);
    }

    static {
        try {
            String tmp = Util.getProperty(new String[]{"jgroups.resolve_dns", "resolve.dns"}, null, null, "false");
            resolve_dns = Boolean.valueOf(tmp);
        }
        catch (SecurityException ex) {
            resolve_dns = false;
        }
    }
}

