/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.MessageBatch;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class SIZE
extends Protocol {
    protected final List<Address> members = new ArrayList<Address>();
    @Property
    protected boolean print_msg = false;
    @Property
    protected boolean raw_buffer = false;
    @Property
    protected long min_size;
    protected Address local_addr;

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                long size;
                if (!this.log.isTraceEnabled()) break;
                Message msg = (Message)evt.getArg();
                long l = size = this.raw_buffer ? (long)msg.getLength() : msg.size();
                if (size < this.min_size) break;
                StringBuilder sb = new StringBuilder(this.local_addr + ".up(): size of message buffer=");
                sb.append(Util.printBytes(size)).append(", " + SIZE.numHeaders(msg) + " headers");
                if (this.print_msg) {
                    sb.append(", headers=" + msg.printHeaders());
                }
                this.log.trace(sb);
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        if (this.log.isTraceEnabled()) {
            long size;
            long l = size = this.raw_buffer ? (long)batch.length() : batch.totalSize();
            if (size >= this.min_size) {
                StringBuilder sb = new StringBuilder(this.local_addr + ".up(): size of message batch=");
                sb.append(Util.printBytes(size)).append(", " + batch.size() + " messages, " + SIZE.numHeaders(batch) + " headers");
                this.log.trace(sb);
            }
        }
        this.up_prot.up(batch);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                long size;
                if (!this.log.isTraceEnabled()) break;
                Message msg = (Message)evt.getArg();
                long l = size = this.raw_buffer ? (long)msg.getLength() : msg.size();
                if (size < this.min_size) break;
                StringBuilder sb = new StringBuilder(this.local_addr + ".down(): size of message buffer=");
                sb.append(Util.printBytes(size)).append(", " + SIZE.numHeaders(msg) + " headers");
                if (this.print_msg) {
                    sb.append(", headers=" + msg.printHeaders());
                }
                this.log.trace(sb);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    protected static int numHeaders(Message msg) {
        return msg == null ? 0 : msg.getNumHeaders();
    }

    protected static int numHeaders(MessageBatch batch) {
        int retval = 0;
        for (Message msg : batch) {
            retval += SIZE.numHeaders(msg);
        }
        return retval;
    }
}

