package org.apache.activemq.artemis.shaded.org.jgroups.tests;


/**
 * @author Bela Ban
 * @since x.y
 */
public class bla3 {
    public static void main(String[] args) throws Exception {
        int NUM=1000000, SIZE=1000;
        byte[] buffer;
        boolean use_pool=args.length > 0;
        byte[][] pool=null;
        int pool_index=0;
        long total_allocated=0;

        System.out.printf("Allocating %d buffers (use-pool=%b)\n", NUM, use_pool);
        if(use_pool)
            pool=new byte[1000][100];

        long start=System.currentTimeMillis();
        for(int i=0; i < NUM; i++) {
            if(!use_pool) {
                buffer=new byte[SIZE];
                total_allocated+=buffer.length;
            }
            else {
                buffer=pool[pool_index++ % pool.length];
                total_allocated+=buffer.length;
            }
        }

        long time=System.currentTimeMillis() - start;
        double allocs_s=(NUM / time) * 1000.0;
        System.out.printf("%d allocations took %d ms (%.2f allocations/sec)\n", NUM, time, allocs_s);
    }
}
