/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.activemq.artemis.shaded.org.jgroups.util.AsciiString;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Tuple;
import org.apache.activemq.artemis.shaded.org.jgroups.util.UUID;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class ExtendedUUID
extends UUID {
    private static final long serialVersionUID = -2335117576152990301L;
    protected short flags;
    protected byte[][] keys;
    protected byte[][] values;
    public static final short site_master = 1;
    public static final short can_become_site_master = 2;

    public ExtendedUUID() {
    }

    protected ExtendedUUID(byte[] data) {
        super(data);
    }

    public ExtendedUUID(long mostSigBits, long leastSigBits) {
        super(mostSigBits, leastSigBits);
    }

    public ExtendedUUID(ExtendedUUID other) {
        super(other.mostSigBits, other.leastSigBits);
        this.flags = other.flags;
        if (other.keys != null) {
            this.keys = (byte[][])Arrays.copyOf(other.keys, other.keys.length);
            this.values = (byte[][])Arrays.copyOf(other.values, other.values.length);
        }
    }

    public static ExtendedUUID randomUUID() {
        return new ExtendedUUID(ExtendedUUID.generateRandomBytes());
    }

    public static ExtendedUUID randomUUID(String name) {
        ExtendedUUID retval = new ExtendedUUID(ExtendedUUID.generateRandomBytes());
        if (name != null) {
            UUID.add(retval, name);
        }
        return retval;
    }

    public ExtendedUUID setFlag(short flag) {
        this.flags = (short)(this.flags | flag);
        return this;
    }

    public ExtendedUUID clearFlag(short flag) {
        this.flags = (short)(this.flags & ~flag);
        return this;
    }

    public boolean isFlagSet(short flag) {
        return (this.flags & flag) == flag;
    }

    public byte[] get(byte[] key) {
        if (this.keys == null || key == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte[] k = this.keys[i];
            if (k == null || !Arrays.equals(k, key)) continue;
            return this.values[i];
        }
        return null;
    }

    public byte[] get(String key) {
        return this.get(Util.stringToBytes(key));
    }

    public ExtendedUUID put(byte[] key, byte[] val) {
        return this.put(0, key, val);
    }

    protected ExtendedUUID put(int start_index, byte[] key, byte[] val) {
        if (val != null && val.length > 255) {
            throw new IllegalArgumentException("value has to be <= 255 bytes");
        }
        if (this.keys == null) {
            this.resize(3);
        }
        for (int i = start_index; i < this.keys.length; ++i) {
            byte[] k = this.keys[i];
            if (k != null && !Arrays.equals(key, k)) continue;
            this.keys[i] = key;
            this.values[i] = val;
            return this;
        }
        int index = this.keys.length;
        this.resize(this.keys.length + 3);
        return this.put(index, key, val);
    }

    public ExtendedUUID put(String key, byte[] val) {
        return this.put(Util.stringToBytes(key), val);
    }

    public byte[] remove(byte[] key) {
        if (this.keys == null || key == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte[] k = this.keys[i];
            if (k == null || !Arrays.equals(k, key)) continue;
            byte[] old_val = this.values[i];
            this.values[i] = null;
            this.keys[i] = null;
            return old_val;
        }
        return null;
    }

    public byte[] remove(String key) {
        return this.remove(Util.stringToBytes(key));
    }

    public boolean keyExists(byte[] key) {
        if (this.keys == null || key == null) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte[] k = this.keys[i];
            if (k == null || !Arrays.equals(k, key)) continue;
            return true;
        }
        return false;
    }

    public boolean keyExists(String key) {
        return this.keyExists(Util.stringToBytes(key));
    }

    public ExtendedUUID addContents(ExtendedUUID other) {
        this.flags = (short)(this.flags | other.flags);
        if (other.keys != null) {
            for (int i = 0; i < other.keys.length; ++i) {
                byte[] key = other.keys[i];
                byte[] val = other.values[i];
                if (this.keyExists(key)) continue;
                this.put(key, val);
            }
        }
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.write(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.read(in);
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        super.writeTo(out);
        this.write(out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        super.readFrom(in);
        this.read(in);
    }

    @Override
    public int size() {
        return super.size() + 2 + 1 + this.sizeofHashMap();
    }

    public int length() {
        if (this.keys == null) {
            return 0;
        }
        int retval = 0;
        for (byte[] key : this.keys) {
            if (key == null) continue;
            ++retval;
        }
        return retval;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public String print() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.flags != 0 || this.keys != null) {
            sb.append(" (");
        }
        if (this.flags != 0) {
            sb.append("flags=" + this.flags + " (" + this.flagsToString() + ")");
        }
        if (this.keys == null) {
            return sb.toString();
        }
        for (int i = 0; i < this.keys.length; ++i) {
            String obj;
            byte[] key = this.keys[i];
            if (key == null) continue;
            byte[] val = this.values[i];
            String string = obj = val != null && val.length >= Util.MAX_LIST_PRINT_SIZE ? val.length + " bytes" : null;
            if (val != null && val.length <= Util.MAX_LIST_PRINT_SIZE && obj == null) {
                try {
                    obj = Util.bytesToString(val);
                }
                catch (Throwable t) {
                    obj = val != null ? val.length + " bytes" : null;
                }
            }
            sb.append(", ").append(new AsciiString(key)).append("=").append((Object)obj);
        }
        if (this.flags != 0 || this.keys != null) {
            sb.append(")");
        }
        return sb.toString();
    }

    protected void write(DataOutput out) throws IOException {
        out.writeShort(this.flags);
        int length = this.length();
        out.writeByte(length);
        if (this.keys == null) {
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte[] k = this.keys[i];
            if (k == null) continue;
            out.writeByte(k.length);
            out.write(k);
            byte[] v = this.values[i];
            out.writeByte(v != null ? v.length : 0);
            if (v == null) continue;
            out.write(v);
        }
    }

    protected void read(DataInput in) throws IOException {
        this.flags = in.readShort();
        int length = in.readUnsignedByte();
        if (length == 0) {
            return;
        }
        this.resize(length);
        for (int i = 0; i < length; ++i) {
            int len = in.readUnsignedByte();
            this.keys[i] = new byte[len];
            in.readFully(this.keys[i]);
            len = in.readUnsignedByte();
            if (len <= 0) continue;
            this.values[i] = new byte[len];
            in.readFully(this.values[i]);
        }
    }

    protected int sizeofHashMap() {
        if (this.keys == null) {
            return 0;
        }
        int retval = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            byte[] key = this.keys[i];
            if (key == null) continue;
            retval += key.length + 1;
            byte[] val = this.values[i];
            retval += 1 + (val != null ? val.length : 0);
        }
        return retval;
    }

    protected void resize(int new_length) {
        if (this.keys == null) {
            this.keys = new byte[Math.min(new_length, 255)][];
            this.values = new byte[Math.min(new_length, 255)][];
            return;
        }
        if (new_length > 255) {
            if (this.keys.length < 255) {
                new_length = 255;
            } else {
                throw new ArrayIndexOutOfBoundsException("the hashmap cannot exceed 255 entries");
            }
        }
        this.keys = (byte[][])Arrays.copyOf(this.keys, new_length);
        this.values = (byte[][])Arrays.copyOf(this.values, new_length);
    }

    protected String flagsToString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Tuple flag : Arrays.asList(new Tuple<Short, String>((short)1, "sm"), new Tuple<Short, String>((short)2, "can_be_sm"))) {
            if (!this.isFlagSet((Short)flag.getVal1())) continue;
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append((String)flag.getVal2());
        }
        return sb.toString();
    }
}

