/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.tests.rt.transports;

import java.io.Closeable;
import java.net.InetAddress;
import java.util.List;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.BaseServer;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.NioClient;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.NioServer;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.ReceiverAdapter;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.TcpClient;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.TcpServer;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.tests.rt.RtReceiver;
import org.apache.activemq.artemis.shaded.org.jgroups.tests.rt.RtTransport;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class ServerTransport
extends ReceiverAdapter
implements RtTransport {
    protected BaseServer srv;
    protected RtReceiver receiver;
    protected InetAddress host;
    protected int port = 7800;
    protected boolean server;
    protected boolean nio;
    protected final Log log = LogFactory.getLog(ServerTransport.class);

    @Override
    public String[] options() {
        return new String[]{"-host <host>", "-port <port>", "-server", "-nio"};
    }

    @Override
    public void options(String ... options) throws Exception {
        if (options == null) {
            return;
        }
        for (int i = 0; i < options.length; ++i) {
            if (options[i].equals("-server")) {
                this.server = true;
                continue;
            }
            if (options[i].equals("-host")) {
                this.host = InetAddress.getByName(options[++i]);
                continue;
            }
            if (options[i].equals("-port")) {
                this.port = Integer.parseInt(options[++i]);
                continue;
            }
            if (!options[i].equals("-nio")) continue;
            this.nio = true;
        }
        if (this.host == null) {
            this.host = InetAddress.getLocalHost();
        }
    }

    @Override
    public void receiver(RtReceiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public Object localAddress() {
        return null;
    }

    public List<Object> clusterMembers() {
        return null;
    }

    @Override
    public void start(String ... options) throws Exception {
        this.options(options);
        if (this.server) {
            this.srv = this.nio ? new NioServer(this.host, this.port) : new TcpServer(this.host, this.port);
            this.srv.connExpireTimeout(0L);
            this.srv.tcpNodelay(false);
            this.srv.receiver(this);
            this.srv.start();
            System.out.printf("server started on %s (ctrl-c to terminate)\n", this.srv.localAddress());
        } else {
            this.srv = this.nio ? new NioClient(null, 0, this.host, this.port) : new TcpClient(null, 0, this.host, this.port);
            this.srv.tcpNodelay(false);
            this.srv.receiver(this);
            this.srv.start();
        }
    }

    @Override
    public void stop() {
        Util.close((Closeable)this.srv);
    }

    @Override
    public void send(Object dest, byte[] buf, int offset, int length) throws Exception {
        this.srv.send((Address)dest, buf, offset, length);
    }

    @Override
    public void receive(Address sender, byte[] buf, int offset, int length) {
        if (this.receiver != null) {
            this.receiver.receive(sender, buf, offset, length);
        }
    }
}

