/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.ViewId;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast.GMS;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast.GmsImpl;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast.JoinRsp;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast.ServerGmsImpl;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Digest;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Promise;

public class ParticipantGmsImpl
extends ServerGmsImpl {
    private final List<Address> suspected_mbrs = new ArrayList<Address>(11);
    private final Promise<Boolean> leave_promise = new Promise();

    public ParticipantGmsImpl(GMS g) {
        super(g);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.suspected_mbrs.clear();
        this.leave_promise.reset();
    }

    @Override
    public void join(Address mbr, boolean useFlushIfPresent) {
        this.wrongMethod("join");
    }

    @Override
    public void joinWithStateTransfer(Address mbr, boolean useFlushIfPresent) {
        this.wrongMethod("join");
    }

    @Override
    public void leave(Address mbr) {
        Address coord;
        this.leave_promise.reset();
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        if ((coord = this.gms.determineCoordinator()) != null) {
            if (this.gms.local_addr.equals(coord)) {
                this.gms.becomeCoordinator();
                this.gms.getImpl().leave(mbr);
                return;
            }
            this.log.trace("%s: sending LEAVE request to %s", this.gms.local_addr, coord);
            this.sendLeaveMessage(coord, mbr);
            Boolean result = this.leave_promise.getResult(this.gms.leave_timeout);
            if (result != null) {
                this.log.trace("%s: got LEAVE response from %s", this.gms.local_addr, coord);
            }
        }
        this.gms.becomeClient();
    }

    @Override
    public void handleJoinResponse(JoinRsp join_rsp) {
        View v = join_rsp.getView();
        ViewId tmp_vid = v != null ? v.getViewId() : null;
        ViewId my_view = this.gms.getViewId();
        if (tmp_vid != null && my_view != null && tmp_vid.compareToIDs(my_view) > 0) {
            Digest d = join_rsp.getDigest();
            this.gms.installView(v, d);
        }
    }

    @Override
    public void handleLeaveResponse() {
        this.leave_promise.setResult(true);
    }

    @Override
    public void suspect(Address mbr) {
        LinkedHashSet<GmsImpl.Request> suspected = new LinkedHashSet<GmsImpl.Request>(1);
        suspected.add(new GmsImpl.Request(3, mbr, true));
        this.handleMembershipChange(suspected);
    }

    @Override
    public void unsuspect(Address mbr) {
        if (mbr != null) {
            this.suspected_mbrs.remove(mbr);
        }
    }

    @Override
    public void handleMembershipChange(Collection<GmsImpl.Request> requests) {
        LinkedHashSet<Address> suspectedMembers = new LinkedHashSet<Address>(requests.size());
        for (GmsImpl.Request req : requests) {
            if (req.type != 3) continue;
            suspectedMembers.add(req.mbr);
        }
        if (suspectedMembers.isEmpty()) {
            return;
        }
        for (Address mbr : suspectedMembers) {
            if (this.suspected_mbrs.contains(mbr)) continue;
            this.suspected_mbrs.add(mbr);
        }
        if (this.wouldIBeCoordinator()) {
            this.log.debug("%s: members are %s, coord=%s: I'm the new coord !", this.gms.local_addr, this.gms.members, this.gms.local_addr);
            this.gms.becomeCoordinator();
            for (Address mbr : this.suspected_mbrs) {
                this.gms.getViewHandler().add(new GmsImpl.Request(3, mbr, true));
                this.gms.ack_collector.suspect(mbr);
            }
            this.suspected_mbrs.clear();
        }
    }

    @Override
    public void handleViewChange(View new_view, Digest digest) {
        this.suspected_mbrs.clear();
        if (this.leaving && !new_view.containsMember(this.gms.local_addr)) {
            return;
        }
        this.gms.installView(new_view, digest);
    }

    boolean wouldIBeCoordinator() {
        List<Address> mbrs = this.gms.computeNewMembership(this.gms.members.getMembers(), null, null, this.suspected_mbrs);
        if (mbrs.size() < 1) {
            return false;
        }
        Address new_coord = mbrs.get(0);
        return this.gms.local_addr.equals(new_coord);
    }

    void sendLeaveMessage(Address coord, Address mbr) {
        Message msg = new Message(coord).setFlag(Message.Flag.OOB).putHeader(this.gms.getId(), new GMS.GmsHeader(3, mbr));
        this.gms.getDownProtocol().down(new Event(1, msg));
    }
}

