/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.Bundler;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TP;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TpHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.util.AsciiString;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArrayDataOutputStream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.SingletonAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class BaseBundler
implements Bundler {
    protected final Map<SingletonAddress, List<Message>> msgs = new HashMap<SingletonAddress, List<Message>>(24);
    protected TP transport;
    protected long count;
    protected final ReentrantLock lock = new ReentrantLock();
    protected ByteArrayDataOutputStream output;
    protected Log log;

    @Override
    public void init(TP transport) {
        this.transport = transport;
        this.log = transport.getLog();
        this.output = new ByteArrayDataOutputStream(transport.getMaxBundleSize() + 3);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void send(Message msg) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChange(View view) {
        this.lock.lock();
        try {
            Iterator<SingletonAddress> it = this.msgs.keySet().iterator();
            while (it.hasNext()) {
                Address mbr = it.next().getAddress();
                if (mbr == null || view.containsMember(mbr)) continue;
                it.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        int num = 0;
        Collection<List<Message>> values = this.msgs.values();
        for (List<Message> list : values) {
            if (list == null) continue;
            num += list.size();
        }
        return num;
    }

    protected void sendBundledMessages() {
        if (this.log.isTraceEnabled()) {
            double percentage = 100.0 / (double)this.transport.getMaxBundleSize() * (double)this.count;
            this.log.trace("%s: sending %d msgs (%d bytes (%.2f%% of max_bundle_size) to %d dests(s): %s", this.transport.localAddress(), this.size(), this.count, percentage, this.msgs.size(), this.msgs.keySet());
        }
        for (Map.Entry<SingletonAddress, List<Message>> entry : this.msgs.entrySet()) {
            List<Message> list = entry.getValue();
            if (list == null || list.isEmpty()) continue;
            this.output.position(0);
            if (list.size() == 1) {
                this.sendSingleMessage(list.get(0));
                continue;
            }
            SingletonAddress dst = entry.getKey();
            this.sendMessageList(dst.getAddress(), list.get(0).getSrc(), dst.getClusterName(), list);
            if (!this.transport.statsEnabled()) continue;
            this.transport.incrBatchesSent();
        }
        this.clearMessages();
        this.count = 0L;
    }

    protected void clearMessages() {
        for (List<Message> l : this.msgs.values()) {
            if (l == null) continue;
            l.clear();
        }
    }

    protected void sendSingleMessage(Message msg) {
        Address dest = msg.getDest();
        try {
            Util.writeMessage(msg, this.output, dest == null);
            this.transport.doSend(this.transport.getClusterName(msg), this.output.buffer(), 0, this.output.position(), dest);
            if (this.transport.statsEnabled()) {
                this.transport.incrSingleMsgsInsteadOfBatches();
            }
        }
        catch (SocketException sock_ex) {
            this.log.trace(Util.getMessage("SendFailure"), this.transport.localAddress(), dest == null ? "cluster" : dest, msg.size(), sock_ex.toString(), msg.printHeaders());
        }
        catch (Throwable e) {
            this.log.error(Util.getMessage("SendFailure"), this.transport.localAddress(), dest == null ? "cluster" : dest, msg.size(), e.toString(), msg.printHeaders());
        }
    }

    protected void sendMessageList(Address dest, Address src, byte[] cluster_name, List<Message> list) {
        try {
            Util.writeMessageList(dest, src, cluster_name, list, this.output, dest == null, this.transport.getId());
            this.transport.doSend(this.transport.isSingleton() ? new AsciiString(cluster_name) : null, this.output.buffer(), 0, this.output.position(), dest);
        }
        catch (SocketException sock_ex) {
            this.log.debug(Util.getMessage("FailureSendingMsgBundle"), this.transport.localAddress(), sock_ex);
        }
        catch (Throwable e) {
            this.log.error(Util.getMessage("FailureSendingMsgBundle"), this.transport.localAddress(), e);
        }
    }

    protected void addMessage(Message msg, long size) {
        byte[] cname = !this.transport.isSingleton() ? this.transport.getClusterNameAscii().chars() : ((TpHeader)msg.getHeader((short)this.transport.getId())).cluster_name;
        SingletonAddress dest = new SingletonAddress(cname, msg.getDest());
        List<Message> tmp = this.msgs.get(dest);
        if (tmp == null) {
            tmp = new ArrayList<Message>(5);
            this.msgs.put(dest, tmp);
        }
        tmp.add(msg);
        this.count += size;
    }

    protected void checkForSharedTransport(TP tp) {
        if (tp.isSingleton()) {
            throw new IllegalStateException(String.format("bundler %s cannot handle shared transports", this.getClass().getSimpleName()));
        }
    }
}

