/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.logging;

import org.apache.activemq.artemis.shaded.org.jgroups.logging.CustomLogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.JDKLogImpl;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log4J2LogImpl;

public final class LogFactory {
    public static final boolean IS_LOG4J2_AVAILABLE;
    protected static boolean use_jdk_logger;
    protected static CustomLogFactory custom_log_factory;

    private LogFactory() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static CustomLogFactory getCustomLogFactory() {
        return custom_log_factory;
    }

    public static void setCustomLogFactory(CustomLogFactory factory) {
        custom_log_factory = factory;
    }

    public static boolean useJdkLogger() {
        return use_jdk_logger;
    }

    public static void useJdkLogger(boolean flag) {
        use_jdk_logger = flag;
    }

    public static String loggerType() {
        if (use_jdk_logger) {
            return "jdk";
        }
        if (IS_LOG4J2_AVAILABLE) {
            return "log4j2";
        }
        return "jdk";
    }

    protected static boolean isAvailable(String classname) {
        try {
            return Class.forName(classname) != null;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    protected static boolean isPropertySet(String property_name) {
        try {
            return Boolean.parseBoolean(System.getProperty(property_name));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Log getLog(Class clazz) {
        if (custom_log_factory != null) {
            return custom_log_factory.getLog(clazz);
        }
        if (use_jdk_logger) {
            return new JDKLogImpl(clazz);
        }
        if (IS_LOG4J2_AVAILABLE) {
            return new Log4J2LogImpl(clazz);
        }
        return new JDKLogImpl(clazz);
    }

    public static Log getLog(String category) {
        if (custom_log_factory != null) {
            return custom_log_factory.getLog(category);
        }
        if (use_jdk_logger) {
            return new JDKLogImpl(category);
        }
        if (IS_LOG4J2_AVAILABLE) {
            return new Log4J2LogImpl(category);
        }
        return new JDKLogImpl(category);
    }

    static {
        custom_log_factory = null;
        use_jdk_logger = LogFactory.isPropertySet("jgroups.use.jdk_logger");
        IS_LOG4J2_AVAILABLE = LogFactory.isAvailable("org.apache.logging.log4j.core.Logger");
    }
}

