/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.blocks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.AnycastAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.Channel;
import org.apache.activemq.artemis.shaded.org.jgroups.ChannelListener;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.MembershipListener;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.MessageListener;
import org.apache.activemq.artemis.shaded.org.jgroups.SuspectedException;
import org.apache.activemq.artemis.shaded.org.jgroups.TimeoutException;
import org.apache.activemq.artemis.shaded.org.jgroups.UnreachableException;
import org.apache.activemq.artemis.shaded.org.jgroups.UpHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.AsyncRequestHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.GroupRequest;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RequestCorrelator;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RequestHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RequestOptions;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.Response;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.ResponseMode;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.UnicastRequest;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.mux.Muxer;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TP;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.SiteAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.StateTransferInfo;
import org.apache.activemq.artemis.shaded.org.jgroups.util.FutureListener;
import org.apache.activemq.artemis.shaded.org.jgroups.util.NotifyingFuture;
import org.apache.activemq.artemis.shaded.org.jgroups.util.NullFuture;
import org.apache.activemq.artemis.shaded.org.jgroups.util.RpcStats;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Rsp;
import org.apache.activemq.artemis.shaded.org.jgroups.util.RspList;
import org.apache.activemq.artemis.shaded.org.jgroups.util.StateTransferResult;

public class MessageDispatcher
implements AsyncRequestHandler,
ChannelListener,
Closeable {
    protected Channel channel;
    protected RequestCorrelator corr;
    protected MessageListener msg_listener;
    protected MembershipListener membership_listener;
    protected RequestHandler req_handler;
    protected boolean async_dispatching;
    protected boolean wrap_exceptions = true;
    protected ProtocolAdapter prot_adapter;
    protected volatile Collection<Address> members = new HashSet<Address>();
    protected Address local_addr;
    protected final Log log = LogFactory.getLog(MessageDispatcher.class);
    protected boolean hardware_multicast_supported = false;
    protected final Set<ChannelListener> channel_listeners = new CopyOnWriteArraySet<ChannelListener>();
    protected final RpcStats rpc_stats = new RpcStats(false);

    public MessageDispatcher() {
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2) {
        this.channel = channel;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getAddress();
            channel.addChannelListener(this);
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            this.installUpHandler(this.prot_adapter, true);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, RequestHandler req_handler) {
        this(channel, null, null, req_handler);
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler) {
        this(channel, l, l2);
        this.setRequestHandler(req_handler);
    }

    public RpcStats rpcStats() {
        return this.rpc_stats;
    }

    public MessageDispatcher extendedStats(boolean fl) {
        this.rpc_stats.extendedStats(fl);
        return this;
    }

    public boolean extendedStats() {
        return this.rpc_stats.extendedStats();
    }

    public boolean asyncDispatching() {
        return this.async_dispatching;
    }

    public MessageDispatcher asyncDispatching(boolean flag) {
        this.async_dispatching = flag;
        if (this.corr != null) {
            this.corr.asyncDispatching(flag);
        }
        return this;
    }

    public boolean wrapExceptions() {
        return this.wrap_exceptions;
    }

    public MessageDispatcher wrapExceptions(boolean flag) {
        this.wrap_exceptions = flag;
        if (this.corr != null) {
            this.corr.wrapExceptions(flag);
        }
        return this;
    }

    public UpHandler getProtocolAdapter() {
        return this.prot_adapter;
    }

    public RequestCorrelator correlator() {
        return this.corr;
    }

    public <T extends MessageDispatcher> T correlator(RequestCorrelator c) {
        if (c == null) {
            return (T)this;
        }
        this.stop();
        this.corr = c;
        this.corr.asyncDispatching(this.async_dispatching).wrapExceptions(this.wrap_exceptions);
        this.start();
        return (T)this;
    }

    protected void setMembers(List<Address> new_mbrs) {
        if (new_mbrs != null) {
            this.members = new HashSet<Address>(new_mbrs);
        }
    }

    public void addChannelListener(ChannelListener l) {
        if (l != null) {
            this.channel_listeners.add(l);
        }
    }

    public void removeChannelListener(ChannelListener l) {
        if (l != null) {
            this.channel_listeners.remove(l);
        }
    }

    public void start() {
        if (this.corr == null) {
            this.corr = this.createRequestCorrelator(this.prot_adapter, this, this.local_addr).asyncDispatching(this.async_dispatching).wrapExceptions(this.wrap_exceptions);
        }
        this.correlatorStarted();
        this.corr.start();
        if (this.channel != null) {
            TP transport;
            List<Address> tmp_mbrs = this.channel.getView() != null ? this.channel.getView().getMembers() : null;
            this.setMembers(tmp_mbrs);
            if (this.channel instanceof JChannel) {
                transport = this.channel.getProtocolStack().getTransport();
                this.corr.registerProbeHandler(transport);
            }
            transport = this.channel.getProtocolStack().getTransport();
            this.hardware_multicast_supported = transport.supportsMulticasting();
        }
    }

    protected RequestCorrelator createRequestCorrelator(Protocol transport, RequestHandler handler, Address local_addr) {
        return new RequestCorrelator(transport, handler, local_addr);
    }

    protected void correlatorStarted() {
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    public void stop() {
        if (this.corr != null) {
            this.corr.stop();
        }
        if (this.channel instanceof JChannel) {
            TP transport = this.channel.getProtocolStack().getTransport();
            if (this.corr != null) {
                this.corr.unregisterProbeHandler(transport);
            }
        }
    }

    public final void setMessageListener(MessageListener l) {
        this.msg_listener = l;
    }

    public MessageListener getMessageListener() {
        return this.msg_listener;
    }

    public final void setMembershipListener(MembershipListener l) {
        this.membership_listener = l;
    }

    public final void setRequestHandler(RequestHandler rh) {
        this.req_handler = rh;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel ch) {
        if (ch == null) {
            return;
        }
        this.channel = ch;
        this.local_addr = this.channel.getAddress();
        if (this.prot_adapter == null) {
            this.prot_adapter = new ProtocolAdapter();
        }
        this.installUpHandler(this.prot_adapter, false);
    }

    protected void installUpHandler(UpHandler handler, boolean canReplace) {
        UpHandler existing = this.channel.getUpHandler();
        if (existing == null) {
            this.channel.setUpHandler(handler);
        } else if (existing instanceof Muxer) {
            Muxer mux = (Muxer)((Object)existing);
            if (mux.getDefaultHandler() == null) {
                mux.setDefaultHandler(handler);
            } else if (canReplace) {
                this.log.warn("Channel Muxer already has a default up handler installed (%s) but now it is being overridden", mux.getDefaultHandler());
                mux.setDefaultHandler(handler);
            }
        } else if (canReplace) {
            this.log.warn("Channel already has an up handler installed (%s) but now it is being overridden", existing);
            this.channel.setUpHandler(handler);
        }
    }

    public <T> RspList<T> castMessage(Collection<Address> dests, Message msg, RequestOptions options) throws Exception {
        GroupRequest<T> req = this.cast(dests, msg, options, true);
        return req != null ? req.getResults() : new RspList();
    }

    public <T> NotifyingFuture<RspList<T>> castMessageWithFuture(Collection<Address> dests, Message msg, RequestOptions options, FutureListener<RspList<T>> listener) throws Exception {
        GroupRequest<T> req = this.cast(dests, msg, options, false, listener);
        return req != null ? req : new NullFuture(new RspList());
    }

    public <T> NotifyingFuture<RspList<T>> castMessageWithFuture(Collection<Address> dests, Message msg, RequestOptions options) throws Exception {
        return this.castMessageWithFuture(dests, msg, options, null);
    }

    protected <T> GroupRequest<T> cast(Collection<Address> dests, Message msg, RequestOptions options, boolean block_for_results, FutureListener<RspList<T>> listener) throws Exception {
        long time;
        Channel tmp;
        ArrayList<Object> real_dests;
        if (msg.getDest() != null && !(msg.getDest() instanceof AnycastAddress)) {
            throw new IllegalArgumentException("message destination is non-null, cannot send message");
        }
        if (options == null) {
            this.log.warn("request options were null, using default of sync");
            options = RequestOptions.SYNC();
        }
        msg.setFlag(options.getFlags()).setTransientFlag(options.getTransientFlags());
        if (options.getScope() > 0) {
            msg.setScope(options.getScope());
        }
        if (dests != null) {
            real_dests = new ArrayList(dests.size());
            for (Address dest : dests) {
                if (!(dest instanceof SiteAddress) && !this.members.contains(dest) || real_dests.contains(dest)) continue;
                real_dests.add(dest);
            }
        } else {
            real_dests = new ArrayList<Address>(this.members);
        }
        if ((tmp = this.channel) != null && tmp.getDiscardOwnMessages() || msg.isTransientFlagSet(Message.TransientFlag.DONT_LOOPBACK)) {
            if (this.local_addr == null) {
                Address address = this.local_addr = tmp != null ? tmp.getAddress() : null;
            }
            if (this.local_addr != null) {
                real_dests.remove(this.local_addr);
            }
        }
        if (options.hasExclusionList()) {
            Address[] exclusion_list;
            for (Address excluding : exclusion_list = options.exclusionList()) {
                real_dests.remove(excluding);
            }
        }
        if (real_dests.isEmpty()) {
            this.log.trace("destination list is empty, won't send message");
            return null;
        }
        boolean sync = options.getMode() != ResponseMode.GET_NONE;
        boolean non_blocking = !sync || !block_for_results;
        boolean anycast = options.getAnycasting();
        if (non_blocking) {
            if (anycast) {
                this.rpc_stats.addAnycast(sync, 0L, real_dests);
            } else {
                this.rpc_stats.add(RpcStats.Type.MULTICAST, null, sync, 0L);
            }
        }
        GroupRequest req = new GroupRequest(this.corr, real_dests, options);
        if (listener != null) {
            req.setListener((FutureListener)listener);
        }
        req.setResponseFilter(options.getRspFilter());
        long start = non_blocking || !this.rpc_stats.extendedStats() ? 0L : System.nanoTime();
        req.execute(msg, block_for_results);
        long l = time = non_blocking || !this.rpc_stats.extendedStats() ? 0L : System.nanoTime() - start;
        if (!non_blocking) {
            if (anycast) {
                this.rpc_stats.addAnycast(sync, time, real_dests);
            } else {
                this.rpc_stats.add(RpcStats.Type.MULTICAST, null, sync, time);
            }
        }
        return req;
    }

    protected <T> GroupRequest<T> cast(Collection<Address> dests, Message msg, RequestOptions options, boolean block_for_results) throws Exception {
        return this.cast(dests, msg, options, block_for_results, null);
    }

    public void done(long req_id) {
        this.corr.done(req_id);
    }

    public <T> T sendMessage(Message msg, RequestOptions opts) throws Exception {
        boolean async_rpc;
        Address dest = msg.getDest();
        if (dest == null) {
            throw new IllegalArgumentException("message destination is null, cannot send message");
        }
        if (opts == null) {
            this.log.warn("request options were null, using default of sync");
            opts = RequestOptions.SYNC();
        }
        msg.setFlag(opts.getFlags()).setTransientFlag(opts.getTransientFlags());
        if (opts.getScope() > 0) {
            msg.setScope(opts.getScope());
        }
        boolean bl = async_rpc = opts.getMode() == ResponseMode.GET_NONE;
        if (async_rpc) {
            this.rpc_stats.add(RpcStats.Type.UNICAST, dest, false, 0L);
        }
        UnicastRequest req = new UnicastRequest(this.corr, dest, opts);
        long start = async_rpc || !this.rpc_stats.extendedStats() ? 0L : System.nanoTime();
        req.execute(msg, true);
        if (async_rpc) {
            return null;
        }
        long time = !this.rpc_stats.extendedStats() ? 0L : System.nanoTime() - start;
        this.rpc_stats.add(RpcStats.Type.UNICAST, dest, true, time);
        Rsp rsp = req.getResult();
        if (rsp.wasSuspected()) {
            throw new SuspectedException(dest);
        }
        Throwable exception = rsp.getException();
        if (exception != null) {
            if (exception instanceof Error) {
                throw (Error)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof Exception) {
                throw (Exception)exception;
            }
            throw new RuntimeException(exception);
        }
        if (rsp.wasUnreachable()) {
            throw new UnreachableException(dest);
        }
        if (!rsp.wasReceived() && !req.responseReceived()) {
            throw new TimeoutException("timeout waiting for response from " + dest + ", request: " + req.toString());
        }
        return rsp.getValue();
    }

    public <T> NotifyingFuture<T> sendMessageWithFuture(Message msg, RequestOptions options, FutureListener<T> listener) throws Exception {
        Address dest = msg.getDest();
        if (dest == null) {
            throw new IllegalArgumentException("message destination is null, cannot send message");
        }
        if (options == null) {
            this.log.warn("request options were null, using default of sync");
            options = RequestOptions.SYNC();
        }
        msg.setFlag(options.getFlags()).setTransientFlag(options.getTransientFlags());
        if (options.getScope() > 0) {
            msg.setScope(options.getScope());
        }
        this.rpc_stats.add(RpcStats.Type.UNICAST, dest, options.getMode() != ResponseMode.GET_NONE, 0L);
        UnicastRequest req = new UnicastRequest(this.corr, dest, options);
        if (listener != null) {
            req.setListener((FutureListener)listener);
        }
        req.execute(msg, false);
        if (options.getMode() == ResponseMode.GET_NONE) {
            return new NullFuture<Object>(null);
        }
        return req;
    }

    public <T> NotifyingFuture<T> sendMessageWithFuture(Message msg, RequestOptions options) throws Exception {
        return this.sendMessageWithFuture(msg, options, null);
    }

    @Override
    public Object handle(Message msg) throws Exception {
        if (this.req_handler != null) {
            return this.req_handler.handle(msg);
        }
        return null;
    }

    @Override
    public void handle(Message request, Response response) throws Exception {
        if (this.req_handler != null) {
            if (this.req_handler instanceof AsyncRequestHandler) {
                ((AsyncRequestHandler)this.req_handler).handle(request, response);
            } else {
                Object retval = this.req_handler.handle(request);
                if (response != null) {
                    response.send(retval, false);
                }
            }
            return;
        }
        Object retval = this.handle(request);
        if (response != null) {
            response.send(retval, false);
        }
    }

    @Override
    public void channelConnected(Channel channel) {
        for (ChannelListener l : this.channel_listeners) {
            try {
                l.channelConnected(channel);
            }
            catch (Throwable t) {
                this.log.warn("notifying channel listener " + l + " failed", t);
            }
        }
    }

    @Override
    public void channelDisconnected(Channel channel) {
        this.stop();
        for (ChannelListener l : this.channel_listeners) {
            try {
                l.channelDisconnected(channel);
            }
            catch (Throwable t) {
                this.log.warn("notifying channel listener " + l + " failed", t);
            }
        }
    }

    @Override
    public void channelClosed(Channel channel) {
        this.stop();
        for (ChannelListener l : this.channel_listeners) {
            try {
                l.channelClosed(channel);
            }
            catch (Throwable t) {
                this.log.warn("notifying channel listener " + l + " failed", t);
            }
        }
    }

    protected Object handleUpEvent(Event evt) throws Exception {
        switch (evt.getType()) {
            case 1: {
                if (this.msg_listener == null) break;
                this.msg_listener.receive((Message)evt.getArg());
                break;
            }
            case 17: {
                byte[] tmp_state = null;
                if (this.msg_listener != null) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
                    this.msg_listener.getState(output);
                    tmp_state = output.toByteArray();
                }
                return new StateTransferInfo(null, 0L, tmp_state);
            }
            case 20: {
                StateTransferResult result;
                if (this.msg_listener == null || !(result = (StateTransferResult)evt.getArg()).hasBuffer()) break;
                ByteArrayInputStream input = new ByteArrayInputStream(result.getBuffer());
                this.msg_listener.setState(input);
                break;
            }
            case 72: {
                OutputStream os = (OutputStream)evt.getArg();
                if (this.msg_listener == null || os == null) break;
                this.msg_listener.getState(os);
                break;
            }
            case 71: {
                InputStream is = (InputStream)evt.getArg();
                if (this.msg_listener == null || is == null) break;
                this.msg_listener.setState(is);
                break;
            }
            case 6: {
                View v = (View)evt.getArg();
                List<Address> new_mbrs = v.getMembers();
                this.setMembers(new_mbrs);
                if (this.membership_listener == null) break;
                this.membership_listener.viewAccepted(v);
                break;
            }
            case 8: {
                this.log.trace("setting local_addr (%s) to %s", this.local_addr, evt.getArg());
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 9: {
                if (this.membership_listener == null) break;
                this.membership_listener.suspect((Address)evt.getArg());
                break;
            }
            case 10: {
                if (this.membership_listener == null) break;
                this.membership_listener.block();
                break;
            }
            case 75: {
                if (this.membership_listener == null) break;
                this.membership_listener.unblock();
            }
        }
        return null;
    }

    class ProtocolAdapter
    extends Protocol
    implements UpHandler {
        ProtocolAdapter() {
        }

        @Override
        public String getName() {
            return "MessageDispatcher";
        }

        @Override
        public Object up(Event evt) {
            if (MessageDispatcher.this.corr != null && !MessageDispatcher.this.corr.receive(evt)) {
                try {
                    return MessageDispatcher.this.handleUpEvent(evt);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            return null;
        }

        @Override
        public Object down(Event evt) {
            if (MessageDispatcher.this.channel != null) {
                if (evt.getType() == 1 && !MessageDispatcher.this.channel.isConnected() && !MessageDispatcher.this.channel.isConnecting()) {
                    throw new IllegalStateException("channel is not connected");
                }
                return MessageDispatcher.this.channel.down(evt);
            }
            return null;
        }
    }
}

