/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.sm;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;

public class SecurityManagerShim {
    public static Subject currentSubject() {
        AccessControlContext accessControlContext = AccessController.getContext();
        if (accessControlContext != null) {
            return Subject.getSubject(accessControlContext);
        }
        return null;
    }

    public static <T> T callAs(Subject subject, Callable<T> callable) throws CompletionException {
        Objects.requireNonNull(callable, "callable must be provided");
        try {
            PrivilegedExceptionAction<Object> pa = () -> callable.call();
            return (T)Subject.doAs(subject, pa);
        }
        catch (PrivilegedActionException e) {
            throw new CompletionException(e.getCause());
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    public static boolean isSecurityManagerEnabled() {
        return System.getSecurityManager() != null;
    }

    public static Object getAccessControlContext() {
        return AccessController.getContext();
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        Objects.requireNonNull(action, "action must be provided");
        return AccessController.doPrivileged(action);
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action, Object accessControlContext) {
        Objects.requireNonNull(action, "action must be provided");
        AccessControlContext acc = (AccessControlContext)AccessControlContext.class.cast(accessControlContext);
        return AccessController.doPrivileged(action, acc);
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> exceptionAction) throws PrivilegedActionException {
        Objects.requireNonNull(exceptionAction, "exceptionAction must be provided");
        return AccessController.doPrivileged(exceptionAction);
    }
}

