/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.jgroups;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsReceiver
implements Receiver {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final BlockingQueue<byte[]> dequeue = new LinkedBlockingDeque<byte[]>();

    @Override
    public void receive(Message msg) {
        logger.trace("sending message {}", (Object)msg);
        this.dequeue.add(msg.getArray());
    }

    public byte[] receiveBroadcast() throws Exception {
        byte[] bytes = this.dequeue.take();
        if (logger.isTraceEnabled()) {
            this.logBytes("receiveBroadcast()", bytes);
        }
        return bytes;
    }

    private void logBytes(String methodName, byte[] bytes) {
        if (bytes != null) {
            logger.trace("{}::{} bytes", (Object)methodName, (Object)bytes.length);
        } else {
            logger.trace("{}:: no bytes", (Object)methodName);
        }
    }

    public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
        byte[] bytes = this.dequeue.poll(time, unit);
        if (logger.isTraceEnabled()) {
            this.logBytes("receiveBroadcast(long time, TimeUnit unit)", bytes);
        }
        return bytes;
    }
}

