/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.journal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.apache.activemq.artemis.utils.ActiveMQBufferInputStream;

public class JDBCJournalRecord {
    public static final byte ADD_RECORD = 11;
    public static final byte UPDATE_RECORD = 12;
    public static final byte ADD_RECORD_TX = 13;
    public static final byte UPDATE_RECORD_TX = 14;
    public static final byte DELETE_RECORD_TX = 15;
    public static final byte DELETE_RECORD = 16;
    public static final byte PREPARE_RECORD = 17;
    public static final byte COMMIT_RECORD = 18;
    public static final byte ROLLBACK_RECORD = 19;
    private IOCompletion ioCompletion = null;
    private boolean storeLineUp = true;
    private boolean sync = false;
    private Long id;
    private byte recordType;
    private byte compactCount;
    private long txId;
    private int variableSize;
    protected byte userRecordType;
    private InputStream record;
    private int txDataSize;
    private InputStream txData;
    private int txCheckNoRecords;
    private boolean isUpdate;
    private boolean isTransactional;
    private long seq;

    public JDBCJournalRecord(long id, byte recordType, long seq) {
        this.id = id;
        this.recordType = recordType;
        this.isUpdate = recordType == 12 || recordType == 14;
        this.isTransactional = recordType == 14 || recordType == 13 || recordType == 15;
        this.compactCount = 0;
        this.txId = 0L;
        this.variableSize = 0;
        this.userRecordType = (byte)-1;
        this.record = new ByteArrayInputStream(new byte[0]);
        this.txDataSize = 0;
        this.txData = new ByteArrayInputStream(new byte[0]);
        this.txCheckNoRecords = 0;
        this.seq = seq;
    }

    public static String createTableSQL(String tableName) {
        return "CREATE TABLE " + tableName + "(id BIGINT,recordType SMALLINT,compactCount SMALLINT,txId BIGINT,userRecordType SMALLINT,variableSize INTEGER,record BLOB,txDataSize INTEGER,txData BLOB,txCheckNoRecords INTEGER,seq BIGINT)";
    }

    public static String insertRecordsSQL(String tableName) {
        return "INSERT INTO " + tableName + "(id,recordType,compactCount,txId,userRecordType,variableSize,record,txDataSize,txData,txCheckNoRecords,seq) " + "VALUES (?,?,?,?,?,?,?,?,?,?,?)";
    }

    public static String selectRecordsSQL(String tableName) {
        return "SELECT id,recordType,compactCount,txId,userRecordType,variableSize,record,txDataSize,txData,txCheckNoRecords,seq FROM " + tableName + " ORDER BY seq ASC";
    }

    public static String deleteRecordsSQL(String tableName) {
        return "DELETE FROM " + tableName + " WHERE id = ?";
    }

    public static String deleteJournalTxRecordsSQL(String tableName) {
        return "DELETE FROM " + tableName + " WHERE txId=?";
    }

    public void complete(boolean success) {
        if (this.ioCompletion != null) {
            if (success) {
                this.ioCompletion.done();
            } else {
                this.ioCompletion.onError(1, "DATABASE TRANSACTION FAILED");
            }
        }
    }

    public void storeLineUp() {
        if (this.storeLineUp && this.ioCompletion != null) {
            this.ioCompletion.storeLineUp();
        }
    }

    protected void writeRecord(PreparedStatement statement) throws SQLException {
        byte[] recordBytes = new byte[this.variableSize];
        byte[] txDataBytes = new byte[this.txDataSize];
        try {
            this.record.read(recordBytes);
            this.txData.read(txDataBytes);
        }
        catch (IOException e) {
            ActiveMQJournalLogger.LOGGER.error((Object)"Error occurred whilst reading Journal Record", (Throwable)e);
        }
        statement.setLong(1, this.id);
        statement.setByte(2, this.recordType);
        statement.setByte(3, this.compactCount);
        statement.setLong(4, this.txId);
        statement.setByte(5, this.userRecordType);
        statement.setInt(6, this.variableSize);
        statement.setBytes(7, recordBytes);
        statement.setInt(8, this.txDataSize);
        statement.setBytes(9, txDataBytes);
        statement.setInt(10, this.txCheckNoRecords);
        statement.setLong(11, this.seq);
        statement.addBatch();
    }

    protected void writeDeleteRecord(PreparedStatement deleteStatement) throws SQLException {
        deleteStatement.setLong(1, this.id);
        deleteStatement.addBatch();
    }

    public static JDBCJournalRecord readRecord(ResultSet rs) throws SQLException {
        JDBCJournalRecord record = new JDBCJournalRecord(rs.getLong(1), (byte)rs.getShort(2), rs.getLong(11));
        record.setCompactCount((byte)rs.getShort(3));
        record.setTxId(rs.getLong(4));
        record.setUserRecordType((byte)rs.getShort(5));
        record.setVariableSize(rs.getInt(6));
        record.setRecord(rs.getBytes(7));
        record.setTxDataSize(rs.getInt(8));
        record.setTxData(rs.getBytes(9));
        record.setTxCheckNoRecords(rs.getInt(10));
        return record;
    }

    public IOCompletion getIoCompletion() {
        return this.ioCompletion;
    }

    public void setIoCompletion(IOCompletion ioCompletion) {
        this.ioCompletion = ioCompletion;
    }

    public boolean isStoreLineUp() {
        return this.storeLineUp;
    }

    public void setStoreLineUp(boolean storeLineUp) {
        this.storeLineUp = storeLineUp;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public Long getId() {
        return this.id;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public byte getCompactCount() {
        return this.compactCount;
    }

    public void setCompactCount(byte compactCount) {
        this.compactCount = compactCount;
    }

    public long getTxId() {
        return this.txId;
    }

    public void setTxId(long txId) {
        this.txId = txId;
    }

    public int getVariableSize() {
        return this.variableSize;
    }

    public void setVariableSize(int variableSize) {
        this.variableSize = variableSize;
    }

    public byte getUserRecordType() {
        return this.userRecordType;
    }

    public void setUserRecordType(byte userRecordType) {
        this.userRecordType = userRecordType;
    }

    public void setRecord(byte[] record) {
        if (record != null) {
            this.variableSize = record.length;
            this.record = new ByteArrayInputStream(record);
        }
    }

    public void setRecord(InputStream record) {
        this.record = record;
    }

    public void setRecord(EncodingSupport record) {
        this.variableSize = record.getEncodeSize();
        ActiveMQBuffer encodedBuffer = ActiveMQBuffers.fixedBuffer((int)this.variableSize);
        record.encode(encodedBuffer);
        this.record = new ActiveMQBufferInputStream(encodedBuffer);
    }

    public InputStream getRecord() {
        return this.record;
    }

    public int getTxCheckNoRecords() {
        return this.txCheckNoRecords;
    }

    public void setTxCheckNoRecords(int txCheckNoRecords) {
        this.txCheckNoRecords = txCheckNoRecords;
    }

    public void setTxDataSize(int txDataSize) {
        this.txDataSize = txDataSize;
    }

    public int getTxDataSize() {
        return this.txDataSize;
    }

    public InputStream getTxData() {
        return this.txData;
    }

    public void setTxData(InputStream record) {
        this.record = record;
    }

    public void setTxData(EncodingSupport txData) {
        this.txDataSize = txData.getEncodeSize();
        ActiveMQBuffer encodedBuffer = ActiveMQBuffers.fixedBuffer((int)this.txDataSize);
        txData.encode(encodedBuffer);
        this.txData = new ActiveMQBufferInputStream(encodedBuffer);
    }

    public void setTxData(byte[] txData) {
        if (txData != null) {
            this.txDataSize = txData.length;
            this.txData = new ByteArrayInputStream(txData);
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public byte[] getRecordData() throws IOException {
        byte[] data = new byte[this.variableSize];
        this.record.read(data);
        return data;
    }

    public byte[] getTxDataAsByteArray() throws IOException {
        byte[] data = new byte[this.txDataSize];
        this.txData.read(data);
        return data;
    }

    public RecordInfo toRecordInfo() throws IOException {
        return new RecordInfo(this.getId().longValue(), this.getUserRecordType(), this.getRecordData(), this.isUpdate(), (short)this.getCompactCount());
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public long getSeq() {
        return this.seq;
    }
}

