package org.apache.activemq.artemis.logs;

import java.util.Locale;
import java.lang.Integer;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import java.lang.Byte;
import java.lang.String;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.Exception;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2022-04-27T20:06:57-0400")
public class ActiveMQUtilBundle_$bundle implements ActiveMQUtilBundle, Serializable {
    private static final long serialVersionUID = 1L;
    protected ActiveMQUtilBundle_$bundle() {}
    public static final ActiveMQUtilBundle_$bundle INSTANCE = new ActiveMQUtilBundle_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String invalidProperty$str() {
        return "AMQ209000: invalid property: {0}";
    }
    @Override
    public final ActiveMQIllegalStateException invalidProperty(final String part) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(invalidProperty$str(), part));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidType$str() {
        return "AMQ209001: Invalid type: {0}";
    }
    @Override
    public final IllegalStateException invalidType(final Byte type) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(invalidType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String stringTooLong$str() {
        return "AMQ209002: the specified string is too long ({0})";
    }
    @Override
    public final IllegalStateException stringTooLong(final Integer length) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(stringTooLong$str(), length));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorCreatingCodec$str() {
        return "AMQ209003: Error instantiating codec {0}";
    }
    @Override
    public final IllegalArgumentException errorCreatingCodec(final Exception e, final String codecClassName) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(errorCreatingCodec$str(), codecClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToParseLong$str() {
        return "AMQ209004: Failed to parse long value from {0}";
    }
    @Override
    public final IllegalArgumentException failedToParseLong(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(failedToParseLong$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
