/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;

public class ByteUtil {
    public static final String NON_ASCII_STRING = "@@@@@";
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static String maxString(String value, int size) {
        if (value.length() < size) {
            return value;
        }
        return value.substring(0, size / 2) + " ... " + value.substring(value.length() - size / 2);
    }

    public static String bytesToHex(byte[] bytes, int groupSize) {
        char[] hexChars = new char[bytes.length * 2 + ByteUtil.numberOfGroups(bytes, groupSize)];
        int outPos = 0;
        for (int j = 0; j < bytes.length; ++j) {
            if (j > 0 && j % groupSize == 0) {
                hexChars[outPos++] = 32;
            }
            int v = bytes[j] & 0xFF;
            hexChars[outPos++] = hexArray[v >>> 4];
            hexChars[outPos++] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String toSimpleString(byte[] bytes) {
        SimpleString simpleString = new SimpleString(bytes);
        String value = simpleString.toString();
        for (char c : value.toCharArray()) {
            if (c >= ' ' && c <= '\u007f') continue;
            return NON_ASCII_STRING;
        }
        return value;
    }

    private static int numberOfGroups(byte[] bytes, int groupSize) {
        int groups = bytes.length / groupSize;
        if (bytes.length % groupSize == 0) {
            --groups;
        }
        return groups;
    }

    public static byte[] longToBytes(long x) {
        ByteBuf buffer = UnpooledByteBufAllocator.DEFAULT.heapBuffer(8, 8);
        buffer.writeLong(x);
        return buffer.array();
    }

    public static String readLine(ActiveMQBuffer buffer) {
        StringBuilder sb = new StringBuilder("");
        char c = buffer.readChar();
        while (c != '\n') {
            sb.append(c);
            c = buffer.readChar();
        }
        return sb.toString();
    }
}

