/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="4.0.0", label="dataformat,transformation,file", title="Parquet File")
@XmlRootElement(name="parquetAvro")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ParquetAvroDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(defaultValue="GZIP", enums="UNCOMPRESSED,SNAPPY,GZIP,LZO,BROTLI,LZ4,ZSTD,LZ4_RAW")
    private String compressionCodecName;
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute(name="unmarshalType")
    private String unmarshalTypeName;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String lazyLoad;

    public ParquetAvroDataFormat() {
        super("parquetAvro");
    }

    public ParquetAvroDataFormat(String unmarshalTypeName) {
        this();
        this.setUnmarshalTypeName(unmarshalTypeName);
    }

    public ParquetAvroDataFormat(Class<?> unmarshalType) {
        this();
        this.unmarshalType = unmarshalType;
    }

    public ParquetAvroDataFormat(boolean lazyLoad) {
        this();
        this.setLazyLoad(Boolean.toString(lazyLoad));
    }

    private ParquetAvroDataFormat(Builder builder) {
        this();
        this.compressionCodecName = builder.compressionCodecName;
        this.unmarshalTypeName = builder.unmarshalTypeName;
        this.unmarshalType = builder.unmarshalType;
        this.lazyLoad = builder.lazyLoad;
    }

    public void setCompressionCodecName(String compressionCodecName) {
        this.compressionCodecName = compressionCodecName;
    }

    public String getCompressionCodecName() {
        return this.compressionCodecName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public String getLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(String lazyLoad) {
        this.lazyLoad = lazyLoad;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<ParquetAvroDataFormat> {
        private String compressionCodecName;
        private Class<?> unmarshalType;
        private String unmarshalTypeName;
        private String lazyLoad;

        public Builder compressionCodecName(String compressionCodecName) {
            this.compressionCodecName = compressionCodecName;
            return this;
        }

        public Builder unmarshalTypeName(String unmarshalTypeName) {
            this.unmarshalTypeName = unmarshalTypeName;
            return this;
        }

        public Builder unmarshalType(Class<?> unmarshalType) {
            this.unmarshalType = unmarshalType;
            return this;
        }

        public Builder lazyLoad(String lazyLoad) {
            this.lazyLoad = lazyLoad;
            return this;
        }

        public Builder lazyLoad(boolean lazyLoad) {
            this.lazyLoad = Boolean.toString(lazyLoad);
            return this;
        }

        @Override
        public ParquetAvroDataFormat end() {
            return new ParquetAvroDataFormat(this);
        }
    }
}

