/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.spel;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Service;
import org.apache.camel.language.spel.SpelExpression;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.util.RegistryBeanResolver;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.ObjectHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;

public class SpelLanguage
extends LanguageSupport
implements Service {
    private BeanResolver beanResolver;

    @Override
    public Predicate createPredicate(String expression) {
        expression = this.loadResource(expression);
        return new SpelExpression(expression, Boolean.class, this.beanResolver);
    }

    @Override
    public Expression createExpression(String expression) {
        expression = this.loadResource(expression);
        return new SpelExpression(expression, Object.class, this.beanResolver);
    }

    @Override
    public void start() throws Exception {
        ObjectHelper.notNull(this.getCamelContext(), "CamelContext", this);
        if (this.getCamelContext() instanceof SpringCamelContext) {
            ApplicationContext applicationContext = ((SpringCamelContext)this.getCamelContext()).getApplicationContext();
            this.beanResolver = new BeanFactoryResolver(applicationContext);
        } else {
            this.beanResolver = new RegistryBeanResolver(this.getCamelContext().getRegistry());
        }
    }

    @Override
    public void stop() throws Exception {
    }
}

