/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.thread.SchedulerTimerTask;
import org.apache.activemq.transport.AbstractInactivityMonitor;
import org.apache.activemq.transport.InactivityIOException;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.mqtt.MQTTProtocolConverter;
import org.apache.activemq.util.ThreadPoolUtils;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTInactivityMonitor
extends TransportFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTInactivityMonitor.class);
    private static final long DEFAULT_CHECK_TIME_MILLS = 30000L;
    private static ThreadPoolExecutor ASYNC_TASKS;
    private static int CHECKER_COUNTER;
    private static Timer READ_CHECK_TIMER;
    private final AtomicBoolean monitorStarted = new AtomicBoolean(false);
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private final AtomicBoolean commandReceived = new AtomicBoolean(true);
    private final AtomicBoolean inReceive = new AtomicBoolean(false);
    private final AtomicInteger lastReceiveCounter = new AtomicInteger(0);
    private final ReentrantLock sendLock = new ReentrantLock();
    private SchedulerTimerTask readCheckerTask;
    private long readCheckTime = 30000L;
    private long initialDelayTime = 30000L;
    private boolean keepAliveResponseRequired;
    private MQTTProtocolConverter protocolConverter;
    private final Runnable readChecker = new Runnable(){
        long lastRunTime;

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            long elapsed = now - this.lastRunTime;
            if (this.lastRunTime != 0L && LOG.isDebugEnabled()) {
                LOG.debug("" + elapsed + " ms elapsed since last read check.");
            }
            if (!MQTTInactivityMonitor.this.allowReadCheck(elapsed)) {
                LOG.debug("Aborting read check.. Not enough time elapsed since last read check.");
                return;
            }
            this.lastRunTime = now;
            MQTTInactivityMonitor.this.readCheck();
        }
    };
    private ThreadFactory factory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "MQTTInactivityMonitor Async Task: " + runnable);
            thread.setDaemon(true);
            return thread;
        }
    };

    private boolean allowReadCheck(long elapsed) {
        return elapsed > this.readCheckTime * 9L / 10L;
    }

    public MQTTInactivityMonitor(Transport next, WireFormat wireFormat) {
        super(next);
    }

    public void start() throws Exception {
        this.next.start();
        this.startMonitorThread();
    }

    public void stop() throws Exception {
        this.stopMonitorThread();
        this.next.stop();
    }

    final void readCheck() {
        int currentCounter = this.next.getReceiveCounter();
        int previousCounter = this.lastReceiveCounter.getAndSet(currentCounter);
        if (this.inReceive.get() || currentCounter != previousCounter) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("A receive is in progress");
            }
            return;
        }
        if (!this.commandReceived.get() && this.monitorStarted.get() && !ASYNC_TASKS.isTerminating()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No message received since last read check for " + this.toString() + "! Throwing InactivityIOException.");
            }
            ASYNC_TASKS.execute(new Runnable(){

                @Override
                public void run() {
                    if (MQTTInactivityMonitor.this.protocolConverter != null) {
                        MQTTInactivityMonitor.this.protocolConverter.onTransportError();
                    }
                    MQTTInactivityMonitor.this.onException((IOException)new InactivityIOException("Channel was inactive for too (>" + MQTTInactivityMonitor.this.readCheckTime + ") long: " + MQTTInactivityMonitor.this.next.getRemoteAddress()));
                }
            });
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Message received since last read check, resetting flag: ");
        }
        this.commandReceived.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(Object command) {
        this.commandReceived.set(true);
        this.inReceive.set(true);
        try {
            this.transportListener.onCommand(command);
        }
        finally {
            this.inReceive.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oneway(Object o) throws IOException {
        this.sendLock.lock();
        try {
            this.doOnewaySend(o);
        }
        finally {
            this.sendLock.unlock();
        }
    }

    private void doOnewaySend(Object command) throws IOException {
        if (this.failed.get()) {
            throw new InactivityIOException("Cannot send, channel has already failed: " + this.next.getRemoteAddress());
        }
        this.next.oneway(command);
    }

    public void onException(IOException error) {
        if (this.failed.compareAndSet(false, true)) {
            this.stopMonitorThread();
            this.transportListener.onException(error);
        }
    }

    public long getReadCheckTime() {
        return this.readCheckTime;
    }

    public void setReadCheckTime(long readCheckTime) {
        this.readCheckTime = readCheckTime;
    }

    public long getInitialDelayTime() {
        return this.initialDelayTime;
    }

    public void setInitialDelayTime(long initialDelayTime) {
        this.initialDelayTime = initialDelayTime;
    }

    public boolean isKeepAliveResponseRequired() {
        return this.keepAliveResponseRequired;
    }

    public void setKeepAliveResponseRequired(boolean value) {
        this.keepAliveResponseRequired = value;
    }

    public boolean isMonitorStarted() {
        return this.monitorStarted.get();
    }

    public void setProtocolConverter(MQTTProtocolConverter protocolConverter) {
        this.protocolConverter = protocolConverter;
    }

    public MQTTProtocolConverter getProtocolConverter() {
        return this.protocolConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void startMonitorThread() {
        if (this.protocolConverter == null) {
            return;
        }
        if (this.monitorStarted.get()) {
            return;
        }
        if (this.readCheckTime > 0L) {
            this.readCheckerTask = new SchedulerTimerTask(this.readChecker);
        }
        if (this.readCheckTime <= 0L) return;
        this.monitorStarted.set(true);
        Class<AbstractInactivityMonitor> clazz = AbstractInactivityMonitor.class;
        synchronized (AbstractInactivityMonitor.class) {
            if (CHECKER_COUNTER == 0) {
                ASYNC_TASKS = this.createExecutor();
                READ_CHECK_TIMER = new Timer("InactivityMonitor ReadCheck", true);
            }
            ++CHECKER_COUNTER;
            if (this.readCheckTime <= 0L) return;
            READ_CHECK_TIMER.schedule((TimerTask)this.readCheckerTask, this.initialDelayTime, this.readCheckTime);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void stopMonitorThread() {
        if (!this.monitorStarted.compareAndSet(true, false)) return;
        if (this.readCheckerTask != null) {
            this.readCheckerTask.cancel();
        }
        Class<AbstractInactivityMonitor> clazz = AbstractInactivityMonitor.class;
        synchronized (AbstractInactivityMonitor.class) {
            READ_CHECK_TIMER.purge();
            if (--CHECKER_COUNTER != 0) return;
            READ_CHECK_TIMER.cancel();
            READ_CHECK_TIMER = null;
            ThreadPoolUtils.shutdown((ExecutorService)ASYNC_TASKS);
            ASYNC_TASKS = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ThreadPoolExecutor createExecutor() {
        ThreadPoolExecutor exec = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.factory);
        exec.allowCoreThreadTimeOut(true);
        return exec;
    }
}

