/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.activemq.jaas.CertificateLoginModule;

public class TextFileCertificateLoginModule
extends CertificateLoginModule {
    private static final String USER_FILE = "org.apache.activemq.jaas.textfiledn.user";
    private static final String GROUP_FILE = "org.apache.activemq.jaas.textfiledn.group";
    private File baseDir;
    private String usersFilePathname;
    private String groupsFilePathname;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.baseDir = System.getProperty("java.security.auth.login.config") != null ? new File(System.getProperty("java.security.auth.login.config")).getParentFile() : new File(".");
        this.usersFilePathname = (String)options.get(USER_FILE) + "";
        this.groupsFilePathname = (String)options.get(GROUP_FILE) + "";
    }

    @Override
    protected String getUserNameForCertificates(X509Certificate[] certs) throws LoginException {
        if (certs == null) {
            throw new LoginException("Client certificates not found. Cannot authenticate.");
        }
        File usersFile = new File(this.baseDir, this.usersFilePathname);
        Properties users = new Properties();
        try (FileInputStream in = new FileInputStream(usersFile);){
            users.load(in);
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load user properties file " + usersFile);
        }
        String dn = this.getDistinguishedName(certs);
        Enumeration<Object> keys = users.keys();
        Enumeration<Object> vals = users.elements();
        while (vals.hasMoreElements()) {
            if (((String)vals.nextElement()).equals(dn)) {
                return (String)keys.nextElement();
            }
            keys.nextElement();
        }
        return null;
    }

    @Override
    protected Set<String> getUserGroups(String username) throws LoginException {
        File groupsFile = new File(this.baseDir, this.groupsFilePathname);
        Properties groups = new Properties();
        try {
            FileInputStream in = new FileInputStream(groupsFile);
            groups.load(in);
            in.close();
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load group properties file " + groupsFile);
        }
        HashSet<String> userGroups = new HashSet<String>();
        Enumeration<Object> enumeration = groups.keys();
        block2: while (enumeration.hasMoreElements()) {
            String groupName = (String)enumeration.nextElement();
            String[] userList = (groups.getProperty(groupName) + "").split(",");
            for (int i = 0; i < userList.length; ++i) {
                if (!username.equals(userList[i])) continue;
                userGroups.add(groupName);
                continue block2;
            }
        }
        return userGroups;
    }
}

