/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.util;

import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.jms.Destination;
import org.apache.activemq.console.filter.AmqMessagesQueryFilter;
import org.apache.activemq.console.filter.GroupPropertiesViewFilter;
import org.apache.activemq.console.filter.MapTransformFilter;
import org.apache.activemq.console.filter.PropertiesViewFilter;
import org.apache.activemq.console.filter.QueryFilter;
import org.apache.activemq.console.filter.StubQueryFilter;
import org.apache.activemq.console.filter.WildcardToMsgSelectorTransformFilter;

public final class AmqMessagesUtil {
    public static final String JMS_MESSAGE_HEADER_PREFIX = "JMS_HEADER_FIELD:";
    public static final String JMS_MESSAGE_CUSTOM_PREFIX = "JMS_CUSTOM_FIELD:";
    public static final String JMS_MESSAGE_BODY_PREFIX = "JMS_BODY_FIELD:";

    private AmqMessagesUtil() {
    }

    public static List getAllMessages(URI brokerUrl, Destination dest) throws Exception {
        return AmqMessagesUtil.getMessages(brokerUrl, dest, "");
    }

    public static List getMessages(URI brokerUrl, Destination dest, String selector) throws Exception {
        return AmqMessagesUtil.createMessageQueryFilter(brokerUrl, dest).query(selector);
    }

    public static List getMessages(URI brokerUrl, Destination dest, List selectors) throws Exception {
        return AmqMessagesUtil.createMessageQueryFilter(brokerUrl, dest).query(selectors);
    }

    public static List filterMessagesView(List messages, Set groupViews, Set attributeViews) throws Exception {
        return new PropertiesViewFilter(attributeViews, new GroupPropertiesViewFilter(groupViews, new MapTransformFilter(new StubQueryFilter(messages)))).query("");
    }

    public static QueryFilter createMessageQueryFilter(URI brokerUrl, Destination dest) {
        return new WildcardToMsgSelectorTransformFilter(new AmqMessagesQueryFilter(brokerUrl, dest));
    }
}

